/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sbom;

import io.quarkus.maven.dependency.ResolvedDependency;
import java.nio.file.Path;

public class ApplicationComponent {
    protected Path path;
    protected String distributionPath;
    protected ResolvedDependency dep;
    protected String pedigree;
    protected String scope;

    public static Builder builder() {
        return new Builder();
    }

    private ApplicationComponent() {
    }

    private ApplicationComponent(ApplicationComponent builder) {
        this.path = builder.path;
        this.distributionPath = builder.distributionPath;
        this.dep = builder.dep;
        this.pedigree = builder.pedigree;
        this.scope = builder.scope;
    }

    public Path getPath() {
        return this.path;
    }

    public String getDistributionPath() {
        return this.distributionPath;
    }

    public ResolvedDependency getResolvedDependency() {
        return this.dep;
    }

    public String getPedigree() {
        return this.pedigree;
    }

    public String getScope() {
        return this.scope;
    }

    protected ApplicationComponent ensureImmutable() {
        return this;
    }

    public static class Builder
    extends ApplicationComponent {
        private Builder() {
        }

        public Builder(ApplicationComponent component) {
            super(component);
        }

        public Builder setPath(Path componentPath) {
            this.path = componentPath;
            return this;
        }

        public Builder setDistributionPath(String distributionPath) {
            this.distributionPath = distributionPath;
            return this;
        }

        public Builder setResolvedDependency(ResolvedDependency dep) {
            this.dep = dep;
            return this;
        }

        public Builder setPedigree(String pedigree) {
            this.pedigree = pedigree;
            return this;
        }

        public Builder setDevelopmentScope() {
            return this.setScope("development");
        }

        public Builder setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public ApplicationComponent build() {
            return this.ensureImmutable();
        }

        @Override
        protected ApplicationComponent ensureImmutable() {
            return new ApplicationComponent(this);
        }
    }
}

