/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.util;

public class GlobUtil {
    private GlobUtil() {
    }

    public static String toRegexPattern(String glob) {
        int length = glob.length();
        StringBuilder result = new StringBuilder(length + 4);
        GlobUtil.glob(glob, 0, length, null, result);
        return result.toString();
    }

    private static int glob(String glob, int i, int length, String stopChars, StringBuilder result) {
        block7: while (i < length) {
            char current = glob.charAt(i++);
            switch (current) {
                case '*': {
                    if (i < length && glob.charAt(i) == '*') {
                        result.append(".*");
                        ++i;
                        continue block7;
                    }
                    result.append("[^/]*");
                    continue block7;
                }
                case '?': {
                    result.append("[^/]");
                    continue block7;
                }
                case '[': {
                    i = GlobUtil.charClass(glob, i, length, result);
                    continue block7;
                }
                case '{': {
                    i = GlobUtil.alternation(glob, i, length, result);
                    continue block7;
                }
                case '\\': {
                    i = GlobUtil.unescape(glob, i, length, result, false);
                    continue block7;
                }
            }
            if (stopChars != null && stopChars.indexOf(current) >= 0) {
                return --i;
            }
            GlobUtil.escapeIfNeeded(current, result);
        }
        return i;
    }

    private static int alternation(String glob, int i, int length, StringBuilder result) {
        result.append("(?:");
        block4: while (i < length) {
            char current = glob.charAt(i++);
            switch (current) {
                case '}': {
                    result.append(')');
                    return i;
                }
                case ',': {
                    result.append('|');
                    i = GlobUtil.glob(glob, i, length, ",}", result);
                    continue block4;
                }
            }
            --i;
            i = GlobUtil.glob(glob, i, length, ",}", result);
        }
        throw new IllegalStateException(String.format("Missing } at the end of input in glob %s", glob));
    }

    private static int unescape(String glob, int i, int length, StringBuilder result, boolean charClass) {
        if (i < length) {
            char current = glob.charAt(i++);
            if (charClass) {
                GlobUtil.escapeCharClassIfNeeded(current, result);
            } else {
                GlobUtil.escapeIfNeeded(current, result);
            }
            return i;
        }
        throw new IllegalStateException(String.format("Incomplete escape sequence at the end of input in glob %s", glob));
    }

    private static int charClass(String glob, int i, int length, StringBuilder result) {
        result.append("[[^/]&&[");
        if (i < length && glob.charAt(i) == '!') {
            ++i;
            result.append('^');
        }
        block5: while (i < length) {
            char current = glob.charAt(i++);
            switch (current) {
                case ']': {
                    result.append("]]");
                    return i;
                }
                case '-': {
                    result.append('-');
                    continue block5;
                }
                case '\\': {
                    i = GlobUtil.unescape(glob, i, length, result, true);
                    continue block5;
                }
            }
            GlobUtil.escapeCharClassIfNeeded(current, result);
        }
        throw new IllegalStateException(String.format("Missing ] at the end of input in glob %s", glob));
    }

    private static void escapeIfNeeded(char current, StringBuilder result) {
        switch (current) {
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': {
                result.append('\\');
                break;
            }
        }
        result.append(current);
    }

    private static void escapeCharClassIfNeeded(char current, StringBuilder result) {
        switch (current) {
            case '&': 
            case '-': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': {
                result.append('\\');
                break;
            }
        }
        result.append(current);
    }
}

