/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTreeUtils;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

class PathTreeVisit
implements PathVisit {
    private final Path root;
    private final Path baseDir;
    private final PathFilter pathFilter;
    private final Map<String, String> multiReleaseMapping;
    private Path current;
    private String relativePath;
    private boolean stopWalking;

    static void walk(Path root, Path rootDir, Path walkDir, PathFilter pathFilter, Map<String, String> multiReleaseMapping, PathVisitor visitor) {
        PathTreeVisit visit = new PathTreeVisit(root, rootDir, pathFilter, multiReleaseMapping);
        try (Stream<Path> files = Files.walk(walkDir, new FileVisitOption[0]);){
            Iterator i = files.iterator();
            while (i.hasNext()) {
                if (!visit.setCurrent((Path)i.next())) continue;
                visitor.visitPath(visit);
                if (!visit.isStopWalking()) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to walk directory " + String.valueOf(root), e);
        }
        visit.visitMultiReleasePaths(visitor);
    }

    static <T> T process(Path root, Path rootDir, Path path, PathFilter pathFilter, Function<PathVisit, T> func) {
        PathTreeVisit visit = new PathTreeVisit(root, rootDir, pathFilter, Map.of());
        if (visit.setCurrent(path)) {
            return func.apply(visit);
        }
        return func.apply(null);
    }

    static void consume(Path root, Path rootDir, Path path, PathFilter pathFilter, Consumer<PathVisit> func) {
        PathTreeVisit visit = new PathTreeVisit(root, rootDir, pathFilter, Map.of());
        if (visit.setCurrent(path)) {
            func.accept(visit);
        } else {
            func.accept(null);
        }
    }

    private PathTreeVisit(Path root, Path rootDir, PathFilter pathFilter, Map<String, String> multiReleaseMapping) {
        this.root = root;
        this.baseDir = rootDir;
        this.pathFilter = pathFilter;
        this.multiReleaseMapping = multiReleaseMapping == null || multiReleaseMapping.isEmpty() ? Map.of() : new HashMap<String, String>(multiReleaseMapping);
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public Path getPath() {
        return this.current;
    }

    @Override
    public void stopWalking() {
        this.stopWalking = true;
    }

    boolean isStopWalking() {
        return this.stopWalking;
    }

    @Override
    public String getRelativePath(String separator) {
        if (this.relativePath == null) {
            return PathTreeUtils.asString(PathTreeVisit.relativize(this.baseDir, this.current), separator);
        }
        if (!this.current.getFileSystem().getSeparator().equals(separator)) {
            return this.relativePath.replace(this.current.getFileSystem().getSeparator(), separator);
        }
        return this.relativePath;
    }

    private boolean setCurrent(Path path) {
        this.current = path;
        this.relativePath = null;
        if (this.pathFilter != null) {
            this.relativePath = this.baseDir.relativize(path).toString();
            if (!PathFilter.isVisible(this.pathFilter, this.relativePath)) {
                return false;
            }
        }
        if (!this.multiReleaseMapping.isEmpty()) {
            String mrPath;
            if (this.relativePath == null) {
                this.relativePath = this.baseDir.relativize(path).toString();
            }
            if ((mrPath = this.multiReleaseMapping.remove(this.relativePath)) != null) {
                this.current = this.baseDir.resolve(mrPath);
            }
        }
        return true;
    }

    private void visitMultiReleasePaths(PathVisitor visitor) {
        for (Map.Entry<String, String> mrEntry : this.multiReleaseMapping.entrySet()) {
            this.relativePath = mrEntry.getKey();
            if (this.pathFilter != null && !PathFilter.isVisible(this.pathFilter, this.relativePath)) continue;
            this.current = this.baseDir.resolve(mrEntry.getValue());
            visitor.visitPath(this);
        }
    }

    private static Path relativize(Path baseDir, Path current) {
        if (baseDir.equals(current)) {
            return current.getFileSystem().getPath("", new String[0]);
        }
        return current.subpath(baseDir.getNameCount(), current.getNameCount());
    }
}

