/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.DefaultApplicationModel;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactCoordsPattern;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;

public class ApplicationModelBuilder {
    public static final String PARENT_FIRST_ARTIFACTS = "parent-first-artifacts";
    public static final String RUNNER_PARENT_FIRST_ARTIFACTS = "runner-parent-first-artifacts";
    public static final String EXCLUDED_ARTIFACTS = "excluded-artifacts";
    public static final String REMOVED_RESOURCES_DOT = "removed-resources.";
    public static final String LESSER_PRIORITY_ARTIFACTS = "lesser-priority-artifacts";
    private static final Logger log = Logger.getLogger(ApplicationModelBuilder.class);
    ResolvedDependency appArtifact;
    final Map<ArtifactKey, ResolvedDependencyBuilder> dependencies = new LinkedHashMap<ArtifactKey, ResolvedDependencyBuilder>();
    final Set<ArtifactKey> parentFirstArtifacts = new HashSet<ArtifactKey>();
    final Set<ArtifactKey> runnerParentFirstArtifacts = new HashSet<ArtifactKey>();
    final List<ArtifactCoordsPattern> excludedArtifacts = new ArrayList<ArtifactCoordsPattern>();
    final Map<ArtifactKey, Set<String>> excludedResources = new HashMap<ArtifactKey, Set<String>>(0);
    final Set<ArtifactKey> lesserPriorityArtifacts = new HashSet<ArtifactKey>();
    final Set<ArtifactKey> reloadableWorkspaceModules = new HashSet<ArtifactKey>();
    final List<ExtensionCapabilities> extensionCapabilities = new ArrayList<ExtensionCapabilities>();
    PlatformImports platformImports;
    final Map<WorkspaceModuleId, WorkspaceModule.Mutable> projectModules = new HashMap<WorkspaceModuleId, WorkspaceModule.Mutable>();

    public ApplicationModelBuilder() {
        this.excludedArtifacts.add(ArtifactCoordsPattern.builder().setGroupId("io.quarkus").setArtifactId("quarkus-ide-launcher").build());
    }

    public ApplicationModelBuilder setAppArtifact(ResolvedDependency appArtifact) {
        this.appArtifact = appArtifact;
        return this;
    }

    public ApplicationModelBuilder setPlatformImports(PlatformImports platformImports) {
        this.platformImports = platformImports;
        return this;
    }

    public ApplicationModelBuilder addExtensionCapabilities(ExtensionCapabilities extensionCapabilities) {
        this.extensionCapabilities.add(extensionCapabilities);
        return this;
    }

    public ApplicationModelBuilder addDependency(ResolvedDependencyBuilder dep) {
        this.dependencies.put(dep.getKey(), dep);
        return this;
    }

    public ApplicationModelBuilder addDependencies(Collection<ResolvedDependencyBuilder> deps) {
        deps.forEach(d -> this.addDependency((ResolvedDependencyBuilder)d));
        return this;
    }

    public ResolvedDependencyBuilder getDependency(ArtifactKey key) {
        return this.dependencies.get(key);
    }

    public Collection<ResolvedDependencyBuilder> getDependencies() {
        return this.dependencies.values();
    }

    public ApplicationModelBuilder addParentFirstArtifact(ArtifactKey deps) {
        this.parentFirstArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addParentFirstArtifacts(List<ArtifactKey> deps) {
        this.parentFirstArtifacts.addAll(deps);
        return this;
    }

    public ApplicationModelBuilder addRunnerParentFirstArtifact(ArtifactKey deps) {
        this.runnerParentFirstArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addRunnerParentFirstArtifacts(List<ArtifactKey> deps) {
        this.runnerParentFirstArtifacts.addAll(deps);
        return this;
    }

    public ApplicationModelBuilder addExcludedArtifact(ArtifactKey key) {
        this.excludedArtifacts.add(ArtifactCoordsPattern.builder().setGroupId(key.getGroupId()).setArtifactId(key.getArtifactId()).setClassifier(key.getClassifier()).setType(key.getType()).build());
        return this;
    }

    public ApplicationModelBuilder addExcludedArtifacts(List<ArtifactKey> keys) {
        for (ArtifactKey key : keys) {
            this.addExcludedArtifact(key);
        }
        return this;
    }

    public ApplicationModelBuilder addRemovedResources(ArtifactKey key, Set<String> resources) {
        this.excludedResources.computeIfAbsent(key, k -> new HashSet(resources.size())).addAll(resources);
        return this;
    }

    public ApplicationModelBuilder addLesserPriorityArtifact(ArtifactKey deps) {
        this.lesserPriorityArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addReloadableWorkspaceModule(ArtifactKey key) {
        this.reloadableWorkspaceModules.add(key);
        return this;
    }

    public ApplicationModelBuilder addReloadableWorkspaceModules(Collection<ArtifactKey> key) {
        this.reloadableWorkspaceModules.addAll(key);
        return this;
    }

    public ApplicationModelBuilder addLesserPriorityArtifacts(List<ArtifactKey> deps) {
        this.lesserPriorityArtifacts.addAll(deps);
        return this;
    }

    public WorkspaceModule.Mutable getOrCreateProjectModule(WorkspaceModuleId id, File moduleDir, File buildDir) {
        return this.projectModules.computeIfAbsent(id, k -> WorkspaceModule.builder().setModuleId(id).setModuleDir(moduleDir.toPath()).setBuildDir(buildDir.toPath()));
    }

    public void handleExtensionProperties(Properties props, String extension) {
        block14: for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String name;
            String value;
            if (prop.getValue() == null || (value = prop.getValue().toString()).isBlank()) continue;
            switch (name = prop.getKey().toString()) {
                case "parent-first-artifacts": {
                    for (String artifact : value.split(",")) {
                        this.parentFirstArtifacts.add(new GACT(artifact.split(":")));
                    }
                    continue block14;
                }
                case "runner-parent-first-artifacts": {
                    for (String artifact : value.split(",")) {
                        this.runnerParentFirstArtifacts.add(new GACT(artifact.split(":")));
                    }
                    continue block14;
                }
                case "excluded-artifacts": {
                    for (String artifact : value.split(",")) {
                        this.excludedArtifacts.add(ArtifactCoordsPattern.of(artifact));
                        log.debugf("Extension %s is excluding %s", (Object)extension, (Object)artifact);
                    }
                    continue block14;
                }
                case "lesser-priority-artifacts": {
                    String[] artifacts;
                    for (String artifact : artifacts = value.split(",")) {
                        this.lesserPriorityArtifacts.add(new GACT(artifact.split(":")));
                        log.debugf("Extension %s is making %s a lesser priority artifact", (Object)extension, (Object)artifact);
                    }
                    continue block14;
                }
                default: {
                    Set<String> resources;
                    String keyStr;
                    if (!name.startsWith(REMOVED_RESOURCES_DOT) || (keyStr = name.substring(REMOVED_RESOURCES_DOT.length())).isBlank()) continue block14;
                    ArtifactKey key = null;
                    try {
                        key = ArtifactKey.fromString(keyStr);
                    }
                    catch (IllegalArgumentException e) {
                        log.warnf("Failed to parse artifact key %s in %s from descriptor of extension %s", (Object)keyStr, (Object)name, (Object)extension);
                    }
                    if (key == null) continue block14;
                    Collection existingResources = this.excludedResources.get(key);
                    if (existingResources == null || existingResources.isEmpty()) {
                        resources = Set.of(value.split(","));
                    } else {
                        String[] split = value.split(",");
                        resources = new HashSet<String>(existingResources.size() + split.length);
                        resources.addAll(existingResources);
                        for (String s : split) {
                            resources.add(s);
                        }
                    }
                    log.debugf("Extension %s is excluding resources %s from artifact %s", (Object)extension, resources, (Object)key);
                    this.excludedResources.put(key, resources);
                }
            }
        }
    }

    private boolean isExcluded(ArtifactCoords coords) {
        for (ArtifactCoordsPattern pattern : this.excludedArtifacts) {
            if (!pattern.matches(coords)) continue;
            return true;
        }
        return false;
    }

    List<ResolvedDependency> buildDependencies() {
        ResolvedDependencyBuilder d;
        for (ArtifactKey key : this.parentFirstArtifacts) {
            d = this.dependencies.get(key);
            if (d == null || d.isFlagSet(4096)) continue;
            d.setFlags(256);
        }
        for (ArtifactKey key : this.runnerParentFirstArtifacts) {
            d = this.dependencies.get(key);
            if (d == null || d.isFlagSet(4096)) continue;
            d.setFlags(512);
        }
        for (ArtifactKey key : this.lesserPriorityArtifacts) {
            d = this.dependencies.get(key);
            if (d == null || d.isFlagSet(4096)) continue;
            d.setFlags(1024);
        }
        ArrayList<ResolvedDependency> result = new ArrayList<ResolvedDependency>(this.dependencies.size());
        for (ResolvedDependencyBuilder db : this.dependencies.values()) {
            if (this.isExcluded(db.getArtifactCoords())) {
                db.setFlags(4096);
                db.clearFlag(8);
                db.clearFlag(4);
            }
            result.add(db.build());
        }
        return result;
    }

    public DefaultApplicationModel build() {
        return new DefaultApplicationModel(this);
    }
}

