/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;

public class CachingPathTree
implements OpenPathTree {
    private final PathTree delegate;
    private volatile LinkedHashMap<String, PathVisitSnapshot> walkSnapshot;

    public static CachingPathTree of(PathTree pathTree) {
        return new CachingPathTree(pathTree);
    }

    private CachingPathTree(PathTree delegate) {
        this.delegate = delegate;
    }

    @Override
    public Collection<Path> getRoots() {
        return this.delegate.getRoots();
    }

    @Override
    public Manifest getManifest() {
        return this.delegate.getManifest();
    }

    @Override
    public void walk(final PathVisitor visitor) {
        LinkedHashMap<String, PathVisitSnapshot> snapshot = this.walkSnapshot;
        if (snapshot != null) {
            PathVisitWrapper wrapper = new PathVisitWrapper();
            for (PathVisitSnapshot visit : snapshot.values()) {
                wrapper.target = visit;
                visitor.visitPath(wrapper);
                if (!wrapper.stopWalking) continue;
                break;
            }
            return;
        }
        final LinkedHashMap walkSnapshot = new LinkedHashMap();
        final PathVisitWrapper wrapper = new PathVisitWrapper();
        this.delegate.walk(new PathVisitor(){

            @Override
            public void visitPath(PathVisit visit) {
                PathVisitSnapshot snapshot = new PathVisitSnapshot(visit);
                walkSnapshot.put(snapshot.getRelativePath("/"), snapshot);
                if (wrapper.stopWalking) {
                    return;
                }
                wrapper.target = snapshot;
                visitor.visitPath(wrapper);
            }
        });
        if (this.walkSnapshot == null) {
            this.walkSnapshot = walkSnapshot;
        }
    }

    @Override
    public <T> T apply(String relativePath, Function<PathVisit, T> func) {
        LinkedHashMap<String, PathVisitSnapshot> snapshot = this.walkSnapshot;
        if (snapshot != null) {
            return func.apply(snapshot.get(relativePath));
        }
        return this.delegate.apply(relativePath, func);
    }

    @Override
    public void accept(String relativePath, Consumer<PathVisit> func) {
        LinkedHashMap<String, PathVisitSnapshot> snapshot = this.walkSnapshot;
        if (snapshot != null) {
            func.accept(snapshot.get(relativePath));
            return;
        }
        this.delegate.accept(relativePath, func);
    }

    @Override
    public void acceptAll(String relativePath, Consumer<PathVisit> func) {
        this.delegate.acceptAll(relativePath, func);
    }

    @Override
    public boolean contains(String relativePath) {
        LinkedHashMap<String, PathVisitSnapshot> snapshot = this.walkSnapshot;
        if (snapshot != null) {
            return snapshot.get(relativePath) != null;
        }
        return this.delegate.contains(relativePath);
    }

    @Override
    public Path getPath(String relativePath) {
        LinkedHashMap<String, PathVisitSnapshot> snapshot = this.walkSnapshot;
        if (snapshot != null) {
            PathVisitSnapshot visit = snapshot.get(relativePath);
            return visit == null ? null : visit.getPath();
        }
        if (this.delegate instanceof OpenPathTree) {
            return ((OpenPathTree)this.delegate).getPath(relativePath);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public OpenPathTree open() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.walkSnapshot = null;
        if (this.delegate instanceof OpenPathTree) {
            ((OpenPathTree)this.delegate).close();
        }
    }

    @Override
    public PathTree getOriginalTree() {
        return this.delegate instanceof OpenPathTree ? ((OpenPathTree)this.delegate).getOriginalTree() : this.delegate;
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachingPathTree other = (CachingPathTree)obj;
        return Objects.equals(this.delegate, other.delegate);
    }

    private static class PathVisitWrapper
    implements PathVisit {
        PathVisit target;
        boolean stopWalking;

        private PathVisitWrapper() {
        }

        @Override
        public Path getRoot() {
            return this.target.getRoot();
        }

        @Override
        public Path getPath() {
            return this.target.getPath();
        }

        @Override
        public String getRelativePath(String separator) {
            return this.target.getRelativePath(separator);
        }

        @Override
        public URL getUrl() {
            return this.target.getUrl();
        }

        @Override
        public void stopWalking() {
            this.stopWalking = true;
        }
    }

    private static class PathVisitSnapshot
    implements PathVisit {
        private final Path root;
        private final Path path;
        private final String relativePathStr;
        private volatile URL url;

        private PathVisitSnapshot(PathVisit visit) {
            this.root = visit.getRoot();
            this.path = visit.getPath();
            this.relativePathStr = visit.getRelativePath("/");
        }

        @Override
        public Path getRoot() {
            return this.root;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public URL getUrl() {
            if (this.url != null) {
                return this.url;
            }
            try {
                this.url = this.path.toUri().toURL();
                return this.url;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to translate " + String.valueOf(this.path.toUri()) + " to a URL", e);
            }
        }

        @Override
        public String getRelativePath(String separator) {
            if (!this.path.getFileSystem().getSeparator().equals("/")) {
                return this.relativePathStr.replace("/", this.path.getFileSystem().getSeparator());
            }
            return this.relativePathStr;
        }

        @Override
        public void stopWalking() {
        }
    }
}

