/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ModelUtils {
    private static final String STATE_ARTIFACT_INITIAL_VERSION = "1";

    public static AppArtifact getStateArtifact(AppArtifact appArtifact) {
        return new AppArtifact(appArtifact.getGroupId() + ".quarkus.curate", appArtifact.getArtifactId(), "", "pom", STATE_ARTIFACT_INITIAL_VERSION);
    }

    public static List<AppDependency> getUpdateCandidates(List<Dependency> deps, List<AppDependency> appDeps, Set<String> groupIds) throws IOException {
        LinkedHashMap<AppArtifactKey, AppDependency> appDepMap = new LinkedHashMap<AppArtifactKey, AppDependency>(appDeps.size());
        for (AppDependency appDep : appDeps) {
            AppArtifact appArt = appDep.getArtifact();
            appDepMap.put(new AppArtifactKey(appArt.getGroupId(), appArt.getArtifactId(), appArt.getClassifier()), appDep);
        }
        ArrayList<AppDependency> updateCandidates = new ArrayList<AppDependency>(deps.size());
        for (Dependency dep : deps) {
            AppDependency appDep;
            if (!groupIds.contains(dep.getGroupId()) || "test".equals(dep.getScope()) || (appDep = (AppDependency)appDepMap.remove(new AppArtifactKey(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier()))) == null) continue;
            updateCandidates.add(appDep);
        }
        for (AppDependency appDep : appDepMap.values()) {
            if (!groupIds.contains(appDep.getArtifact().getGroupId())) continue;
            updateCandidates.add(appDep);
        }
        return updateCandidates;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AppArtifact resolveAppArtifact(Path appJar) throws IOException {
        fs = FileSystems.newFileSystem(appJar, null);
        var2_2 = null;
        try {
            metaInfMaven = fs.getPath("META-INF", new String[]{"maven"});
            if (Files.exists(metaInfMaven, new LinkOption[0]) == false) throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.properties in " + appJar);
            groupIds = Files.newDirectoryStream(metaInfMaven);
            var5_6 = null;
            for (Path groupIdPath : groupIds) {
                if (!Files.isDirectory(groupIdPath, new LinkOption[0])) continue;
                artifactIds = Files.newDirectoryStream(groupIdPath);
                var9_12 = null;
                for (Path artifactIdPath : artifactIds) {
                    if (!Files.isDirectory(artifactIdPath, new LinkOption[0])) continue;
                    propsPath = artifactIdPath.resolve("pom.properties");
                    if (!Files.exists(propsPath, new LinkOption[0])) ** GOTO lbl76
                    props = ModelUtils.loadPomProps(appJar, artifactIdPath);
                    var14_19 = new AppArtifact(props.getProperty("groupId"), props.getProperty("artifactId"), props.getProperty("version"));
                    if (artifactIds == null) ** GOTO lbl46
                    if (var9_12 == null) ** GOTO lbl45
                    ** GOTO lbl39
                }
                ** GOTO lbl78
                {
                    block42: {
                        catch (Throwable var10_15) {
                            try {
                                var9_12 = var10_15;
                                throw var10_15;
                            }
                            catch (Throwable var16_24) {
                                if (artifactIds == null) throw var16_24;
                                if (var9_12 != null) {
                                    try {
                                        artifactIds.close();
                                        throw var16_24;
                                    }
                                    catch (Throwable var17_25) {
                                        var9_12.addSuppressed(var17_25);
                                        throw var16_24;
                                    }
                                }
                                artifactIds.close();
                                throw var16_24;
                            }
                        }
lbl39:
                        // 1 sources

                        try {
                            artifactIds.close();
                        }
                        catch (Throwable var15_20) {
                            var9_12.addSuppressed(var15_20);
                        }
                        break block42;
lbl45:
                        // 1 sources

                        artifactIds.close();
                    }
                    if (groupIds == null) return var14_19;
                    if (var5_6 == null) break block40;
                    break block41;
                }
            }
            ** GOTO lbl89
            {
                block43: {
                    block40: {
                        block41: {
                            catch (Throwable var6_9) {
                                try {
                                    var5_6 = var6_9;
                                    throw var6_9;
                                }
                                catch (Throwable var18_26) {
                                    if (groupIds == null) throw var18_26;
                                    if (var5_6 == null) {
                                        groupIds.close();
                                        throw var18_26;
                                    }
                                    try {
                                        groupIds.close();
                                        throw var18_26;
                                    }
                                    catch (Throwable var19_27) {
                                        var5_6.addSuppressed(var19_27);
                                        throw var18_26;
                                    }
                                }
                            }
                        }
                        try {
                            groupIds.close();
                            return var14_19;
                        }
                        catch (Throwable var15_21) {
                            var5_6.addSuppressed(var15_21);
                            return var14_19;
                        }
                    }
                    groupIds.close();
                    return var14_19;
lbl76:
                    // 1 sources

                    ** try [egrp 7[TRYBLOCK] [18 : 318->541)] { 
lbl77:
                    // 1 sources

                    ** GOTO lbl-1000
lbl78:
                    // 1 sources

                    if (artifactIds == null) ** GOTO lbl-1000
                    if (var9_12 == null) break block43;
                    try {
                        artifactIds.close();
                    }
                    catch (Throwable var10_14) {
                        var9_12.addSuppressed(var10_14);
                    }
                    ** GOTO lbl-1000
                }
                artifactIds.close();
                ** GOTO lbl-1000
lbl89:
                // 1 sources

                if (groupIds == null) throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.properties in " + appJar);
                if (var5_6 == null) {
                    groupIds.close();
                    throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.properties in " + appJar);
                }
                try {
                    groupIds.close();
                    throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.properties in " + appJar);
                }
                catch (Throwable var6_8) {
                    var5_6.addSuppressed(var6_8);
                    throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.properties in " + appJar);
                }
            }
        }
lbl99:
        // 2 sources

        catch (Throwable var3_4) {
            var2_2 = var3_4;
            throw var3_4;
        }
        finally {
            if (fs != null) {
                if (var2_2 != null) {
                    try {
                        fs.close();
                    }
                    catch (Throwable var15_23) {
                        var2_2.addSuppressed(var15_23);
                    }
                } else {
                    fs.close();
                }
            }
        }
    }

    public static Model readAppModel(Path appJar, AppArtifact appArtifact) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(appJar, null);){
            Path pomXml = fs.getPath("META-INF", "maven", appArtifact.getGroupId(), appArtifact.getArtifactId(), "pom.xml");
            if (!Files.exists(pomXml, new LinkOption[0])) {
                throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
            }
            Model model = ModelUtils.readModel(pomXml);
            return model;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Model readAppModel(Path appJar) throws IOException {
        fs = FileSystems.newFileSystem(appJar, null);
        var2_2 = null;
        try {
            metaInfMaven = fs.getPath("META-INF", new String[]{"maven"});
            if (Files.exists(metaInfMaven, new LinkOption[0]) == false) throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
            groupIds = Files.newDirectoryStream(metaInfMaven);
            var5_6 = null;
            for (Path groupIdPath : groupIds) {
                if (!Files.isDirectory(groupIdPath, new LinkOption[0])) continue;
                artifactIds = Files.newDirectoryStream(groupIdPath);
                var9_12 = null;
                for (Path artifactIdPath : artifactIds) {
                    if (!Files.isDirectory(artifactIdPath, new LinkOption[0])) continue;
                    pomXml = artifactIdPath.resolve("pom.xml");
                    if (!Files.exists(pomXml, new LinkOption[0])) ** GOTO lbl89
                    model = ModelUtils.readModel(pomXml);
                    props = null;
                    if (model.getGroupId() == null) {
                        props = ModelUtils.loadPomProps(appJar, artifactIdPath);
                        groupId = props.getProperty("groupId");
                        if (groupId == null) {
                            throw new IOException("Failed to determine groupId for " + appJar);
                        }
                        model.setGroupId(groupId);
                    }
                    if (model.getVersion() == null) {
                        if (props == null) {
                            props = ModelUtils.loadPomProps(appJar, artifactIdPath);
                        }
                        if ((version = props.getProperty("version")) == null) {
                            throw new IOException("Failed to determine the artifact version for " + appJar);
                        }
                        model.setVersion(version);
                    }
                    var15_20 = model;
                    if (artifactIds == null) ** GOTO lbl59
                    if (var9_12 == null) ** GOTO lbl58
                    ** GOTO lbl52
                }
                ** GOTO lbl91
                {
                    block47: {
                        catch (Throwable var10_15) {
                            try {
                                var9_12 = var10_15;
                                throw var10_15;
                            }
                            catch (Throwable var17_25) {
                                if (artifactIds == null) throw var17_25;
                                if (var9_12 != null) {
                                    try {
                                        artifactIds.close();
                                        throw var17_25;
                                    }
                                    catch (Throwable var18_26) {
                                        var9_12.addSuppressed(var18_26);
                                        throw var17_25;
                                    }
                                }
                                artifactIds.close();
                                throw var17_25;
                            }
                        }
lbl52:
                        // 1 sources

                        try {
                            artifactIds.close();
                        }
                        catch (Throwable var16_21) {
                            var9_12.addSuppressed(var16_21);
                        }
                        break block47;
lbl58:
                        // 1 sources

                        artifactIds.close();
                    }
                    if (groupIds == null) return var15_20;
                    if (var5_6 == null) break block45;
                    break block46;
                }
            }
            ** GOTO lbl102
            {
                block48: {
                    block45: {
                        block46: {
                            catch (Throwable var6_9) {
                                try {
                                    var5_6 = var6_9;
                                    throw var6_9;
                                }
                                catch (Throwable var19_27) {
                                    if (groupIds == null) throw var19_27;
                                    if (var5_6 == null) {
                                        groupIds.close();
                                        throw var19_27;
                                    }
                                    try {
                                        groupIds.close();
                                        throw var19_27;
                                    }
                                    catch (Throwable var20_28) {
                                        var5_6.addSuppressed(var20_28);
                                        throw var19_27;
                                    }
                                }
                            }
                        }
                        try {
                            groupIds.close();
                            return var15_20;
                        }
                        catch (Throwable var16_22) {
                            var5_6.addSuppressed(var16_22);
                            return var15_20;
                        }
                    }
                    groupIds.close();
                    return var15_20;
lbl89:
                    // 1 sources

                    ** try [egrp 7[TRYBLOCK] [18 : 427->650)] { 
lbl90:
                    // 1 sources

                    ** GOTO lbl-1000
lbl91:
                    // 1 sources

                    if (artifactIds == null) ** GOTO lbl-1000
                    if (var9_12 == null) break block48;
                    try {
                        artifactIds.close();
                    }
                    catch (Throwable var10_14) {
                        var9_12.addSuppressed(var10_14);
                    }
                    ** GOTO lbl-1000
                }
                artifactIds.close();
                ** GOTO lbl-1000
lbl102:
                // 1 sources

                if (groupIds == null) throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
                if (var5_6 == null) {
                    groupIds.close();
                    throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
                }
                try {
                    groupIds.close();
                    throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
                }
                catch (Throwable var6_8) {
                    var5_6.addSuppressed(var6_8);
                    throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
                }
            }
        }
lbl112:
        // 2 sources

        catch (Throwable var3_4) {
            var2_2 = var3_4;
            throw var3_4;
        }
        finally {
            if (fs != null) {
                if (var2_2 != null) {
                    try {
                        fs.close();
                    }
                    catch (Throwable var16_24) {
                        var2_2.addSuppressed(var16_24);
                    }
                } else {
                    fs.close();
                }
            }
        }
    }

    private static Properties loadPomProps(Path appJar, Path artifactIdPath) throws IOException {
        Path propsPath = artifactIdPath.resolve("pom.properties");
        if (!Files.exists(propsPath, new LinkOption[0])) {
            throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.properties in " + appJar);
        }
        Properties props = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(propsPath);){
            props.load(reader);
        }
        return props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Model readModel(Path pomXml) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(pomXml);){
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            Model model = xpp3Reader.read((Reader)reader);
            return model;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Failed to parse application POM model", e);
        }
    }

    public static void persistModel(Path pomFile, Model model) throws IOException {
        MavenXpp3Writer xpp3Writer = new MavenXpp3Writer();
        try (BufferedWriter pomFileWriter = Files.newBufferedWriter(pomFile, new OpenOption[0]);){
            xpp3Writer.write((Writer)pomFileWriter, model);
        }
    }
}

