/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.MavenModelBuilder;
import io.quarkus.bootstrap.util.PropertyUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.jboss.logging.Logger;

public class MavenRepoInitializer {
    private static final String DEFAULT_REMOTE_REPO_ID = "central";
    private static final String DEFAULT_REMOTE_REPO_URL = "https://repo.maven.apache.org/maven2";
    private static final String MAVEN_CMD_LINE_ARGS = "MAVEN_CMD_LINE_ARGS";
    private static final String DOT_M2 = ".m2";
    private static final String MAVEN_HOME = "maven.home";
    private static final String M2_HOME = "M2_HOME";
    private static final String SETTINGS_XML = "settings.xml";
    private static final String userHome = PropertyUtils.getUserHome();
    private static final File userMavenConfigurationHome = new File(userHome, ".m2");
    private static final String envM2Home = System.getenv("M2_HOME");
    private static final File USER_SETTINGS_FILE;
    private static final File GLOBAL_SETTINGS_FILE;
    private static List<RemoteRepository> remoteRepos;
    private static Settings settings;
    private static final Logger log;

    private static File resolveUserSettings(String settingsArg) {
        File userSettings = new File(settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        String base = System.getenv("MAVEN_PROJECTBASEDIR");
        if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
            return userSettings;
        }
        base = PropertyUtils.getProperty("basedir");
        if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
            return userSettings;
        }
        userSettings = new File(userHome, settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        return null;
    }

    public static RepositorySystem getRepositorySystem() {
        return MavenRepoInitializer.getRepositorySystem(false, null);
    }

    public static RepositorySystem getRepositorySystem(boolean offline, WorkspaceModelResolver wsModelResolver) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        if (!offline) {
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, FileTransporterFactory.class);
            locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        }
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new MavenModelBuilder(wsModelResolver)});
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                System.err.println("Service creation failed");
                exception.printStackTrace();
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system) throws AppModelResolverException {
        return MavenRepoInitializer.newSession(system, MavenRepoInitializer.getSettings());
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system, Settings settings) {
        List mirrors;
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        org.apache.maven.settings.Proxy proxy = settings.getActiveProxy();
        if (proxy != null) {
            Authentication auth = null;
            if (proxy.getUsername() != null) {
                auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            }
            session.setProxySelector((ProxySelector)new DefaultProxySelector().add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth), proxy.getNonProxyHosts()));
        }
        if ((mirrors = settings.getMirrors()) != null && !mirrors.isEmpty()) {
            DefaultMirrorSelector ms = new DefaultMirrorSelector();
            for (Mirror m : mirrors) {
                ms.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
            }
            session.setMirrorSelector((MirrorSelector)ms);
        }
        String localRepoPath = MavenRepoInitializer.getLocalRepo(settings);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepoPath)));
        session.setOffline(settings.isOffline());
        return session;
    }

    public static List<RemoteRepository> getRemoteRepos() throws AppModelResolverException {
        if (remoteRepos != null) {
            return remoteRepos;
        }
        remoteRepos = Collections.unmodifiableList(MavenRepoInitializer.getRemoteRepos(MavenRepoInitializer.getSettings()));
        return remoteRepos;
    }

    public static List<RemoteRepository> getRemoteRepos(Settings settings) throws AppModelResolverException {
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
        for (Profile profile : settings.getProfiles()) {
            if (profile.getActivation() == null || !profile.getActivation().isActiveByDefault()) continue;
            MavenRepoInitializer.addProfileRepos(profile, remotes);
        }
        List activeProfiles = settings.getActiveProfiles();
        if (!activeProfiles.isEmpty()) {
            Map profilesMap = settings.getProfilesAsMap();
            for (String profileName : activeProfiles) {
                MavenRepoInitializer.addProfileRepos((Profile)profilesMap.get(profileName), remotes);
            }
        }
        if (remotes.isEmpty() || !MavenRepoInitializer.includesDefaultRepo(remotes)) {
            remotes.add(new RemoteRepository.Builder(DEFAULT_REMOTE_REPO_ID, "default", DEFAULT_REMOTE_REPO_URL).setReleasePolicy(new RepositoryPolicy(true, "daily", "warn")).setSnapshotPolicy(new RepositoryPolicy(false, "daily", "warn")).build());
        }
        return remotes;
    }

    private static void addProfileRepos(Profile profile, List<RemoteRepository> all) {
        List repositories = profile.getRepositories();
        for (Repository repo : repositories) {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            org.apache.maven.settings.RepositoryPolicy policy = repo.getReleases();
            if (policy != null) {
                repoBuilder.setReleasePolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            if ((policy = repo.getSnapshots()) != null) {
                repoBuilder.setSnapshotPolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            all.add(repoBuilder.build());
        }
    }

    public static Settings getSettings() throws AppModelResolverException {
        Settings effectiveSettings;
        if (settings != null) {
            return settings;
        }
        try {
            SettingsBuildingResult result = new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)new DefaultSettingsBuildingRequest().setSystemProperties(System.getProperties()).setUserSettingsFile(USER_SETTINGS_FILE).setGlobalSettingsFile(GLOBAL_SETTINGS_FILE));
            List problems = result.getProblems();
            if (!problems.isEmpty()) {
                for (SettingsProblem problem : problems) {
                    switch (problem.getSeverity()) {
                        case ERROR: 
                        case FATAL: {
                            throw new AppModelResolverException("Settings problem encountered at " + problem.getLocation(), problem.getException());
                        }
                    }
                    log.warn((Object)("Settings problem encountered at " + problem.getLocation()), (Throwable)problem.getException());
                }
            }
            effectiveSettings = result.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new AppModelResolverException("Failed to initialize Maven repository settings", e);
        }
        settings = effectiveSettings;
        return settings;
    }

    private static String getMvnCmdArg(String mvnCmd, String argName) {
        int argStart = mvnCmd.indexOf(argName);
        if (argStart > 0) {
            StringBuilder buf = new StringBuilder();
            int i = argStart + argName.length();
            while (i < mvnCmd.length()) {
                char c;
                if (Character.isWhitespace(c = mvnCmd.charAt(i++))) {
                    if (buf.length() <= 0) continue;
                    return buf.toString();
                }
                buf.append(c);
            }
            return buf.length() == 0 ? null : buf.toString();
        }
        return null;
    }

    public static String getLocalRepo(Settings settings) {
        String localRepo = settings.getLocalRepository();
        return localRepo == null ? MavenRepoInitializer.getDefaultLocalRepo() : localRepo;
    }

    private static String getDefaultLocalRepo() {
        return new File(userMavenConfigurationHome, "repository").getAbsolutePath();
    }

    private static boolean includesDefaultRepo(List<RemoteRepository> repositories) {
        for (ArtifactRepository artifactRepository : repositories) {
            if (!artifactRepository.getId().equals(DEFAULT_REMOTE_REPO_ID)) continue;
            return true;
        }
        return false;
    }

    private static RepositoryPolicy toAetherRepoPolicy(org.apache.maven.settings.RepositoryPolicy settingsPolicy) {
        return new RepositoryPolicy(settingsPolicy.isEnabled(), MavenRepoInitializer.isEmpty(settingsPolicy.getUpdatePolicy()) ? "daily" : settingsPolicy.getUpdatePolicy(), MavenRepoInitializer.isEmpty(settingsPolicy.getChecksumPolicy()) ? "warn" : settingsPolicy.getChecksumPolicy());
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    static {
        String mvnCmd = System.getenv(MAVEN_CMD_LINE_ARGS);
        String userSettings = null;
        String globalSettings = null;
        if (mvnCmd != null) {
            userSettings = MavenRepoInitializer.getMvnCmdArg(mvnCmd, " -s ");
            if (userSettings == null) {
                userSettings = MavenRepoInitializer.getMvnCmdArg(mvnCmd, "--settings ");
            }
            if ((globalSettings = MavenRepoInitializer.getMvnCmdArg(mvnCmd, " -gs ")) == null) {
                globalSettings = MavenRepoInitializer.getMvnCmdArg(mvnCmd, "--global-settings ");
            }
        }
        File f = userSettings != null ? MavenRepoInitializer.resolveUserSettings(userSettings) : new File(userMavenConfigurationHome, SETTINGS_XML);
        File file = USER_SETTINGS_FILE = f != null && f.exists() ? f : null;
        f = globalSettings != null ? MavenRepoInitializer.resolveUserSettings(globalSettings) : new File(PropertyUtils.getProperty(MAVEN_HOME, envM2Home != null ? envM2Home : ""), "conf/settings.xml");
        GLOBAL_SETTINGS_FILE = f != null && f.exists() ? f : null;
        log = Logger.getLogger(MavenRepoInitializer.class);
    }
}

