/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.jboss.logging.Logger;

public class LocalProject {
    private static final Logger log = Logger.getLogger(LocalProject.class);
    private static final String POM_XML = "pom.xml";
    private final Model rawModel;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Path dir;
    private final LocalWorkspace workspace;

    public static LocalProject resolveLocalProject(Path currentProjectDir) throws BootstrapException {
        try {
            return new LocalProject(currentProjectDir, null);
        }
        catch (IOException e) {
            throw new BootstrapException("Failed to resolve local Maven project for " + currentProjectDir, e);
        }
    }

    public static LocalProject resolveLocalProjectWithWorkspace(Path currentProjectDir) throws BootstrapException {
        LocalProject project;
        Path rootDir = LocalProject.locateRootProjectDir(currentProjectDir);
        log.debugf("Root project dir %s", (Object)rootDir);
        LocalWorkspace workspace = new LocalWorkspace();
        try {
            project = LocalProject.loadProject(workspace, rootDir, currentProjectDir);
        }
        catch (IOException e) {
            throw new BootstrapException("Failed to resolve local Maven projects for " + currentProjectDir, e);
        }
        if (project == null) {
            throw new BootstrapException("Failed to locate current project among the loaded local projects");
        }
        return project;
    }

    private static LocalProject loadProject(LocalWorkspace workspace, Path dir, Path currentProjectDir) throws IOException {
        LocalProject project = new LocalProject(dir, workspace);
        Path projectDir = project.getDir();
        LocalProject result = currentProjectDir == null || !currentProjectDir.equals(projectDir) ? null : project;
        List modules = project.getRawModel().getModules();
        if (!modules.isEmpty()) {
            Path dirArg = result == null ? currentProjectDir : null;
            for (String module : modules) {
                LocalProject loaded = LocalProject.loadProject(workspace, projectDir.resolve(module), dirArg);
                if (loaded == null || result != null) continue;
                result = loaded;
                dirArg = null;
            }
        }
        return result;
    }

    private static Path locateRootProjectDir(Path currentProjectDir) throws BootstrapException {
        Path p = currentProjectDir;
        Path parentDir;
        while ((parentDir = p.getParent()) != null) {
            if (!Files.exists(parentDir.resolve(POM_XML), new LinkOption[0])) {
                return p;
            }
            p = parentDir;
        }
        return p;
    }

    public static Path locateCurrentProjectDir(Path path) throws BootstrapException {
        for (Path p = path; p != null; p = p.getParent()) {
            if (!Files.exists(p.resolve(POM_XML), new LinkOption[0])) continue;
            return p;
        }
        throw new BootstrapException("Failed to locate project pom.xml for " + path);
    }

    private LocalProject(Path dir, LocalWorkspace workspace) throws IOException {
        this.dir = dir;
        this.workspace = workspace;
        Path pomXml = dir.resolve(POM_XML);
        this.rawModel = ModelUtils.readModel(pomXml);
        this.rawModel.setPomFile(pomXml.toFile());
        Parent parent = this.rawModel.getParent();
        String groupId = this.rawModel.getGroupId();
        if (groupId == null) {
            if (parent == null) {
                throw new IOException("Failed to determine groupId for " + pomXml);
            }
            this.groupId = parent.getGroupId();
        } else {
            this.groupId = groupId;
        }
        this.artifactId = this.rawModel.getArtifactId();
        String version = this.rawModel.getVersion();
        if (version == null) {
            if (parent == null) {
                throw new IOException("Failed to determine version for " + pomXml);
            }
            this.version = parent.getVersion();
        } else {
            this.version = version;
        }
        if (workspace != null) {
            workspace.addProject(this, pomXml.toFile().lastModified());
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Path getDir() {
        return this.dir;
    }

    public Path getOutputDir() {
        return this.dir.resolve("target");
    }

    public Path getClassesDir() {
        return this.getOutputDir().resolve("classes");
    }

    public Model getRawModel() {
        return this.rawModel;
    }

    public LocalWorkspace getWorkspace() {
        return this.workspace;
    }

    public AppArtifactKey getKey() {
        return new AppArtifactKey(this.groupId, this.artifactId);
    }

    public AppArtifact getAppArtifact() {
        AppArtifact appArtifact = new AppArtifact(this.groupId, this.artifactId, "", this.rawModel.getPackaging(), this.version);
        appArtifact.setPath(this.getClassesDir());
        return appArtifact;
    }
}

