/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Resource;

public class LocalProject {
    public static final String PROJECT_GROUPID = "${project.groupId}";
    private static final String PROJECT_BASEDIR = "${project.basedir}";
    private static final String POM_XML = "pom.xml";
    private final Model rawModel;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Path dir;
    private final LocalWorkspace workspace;
    private final List<LocalProject> modules = new ArrayList<LocalProject>(0);

    public static LocalProject load(Path path) throws BootstrapException {
        return new LocalProject(LocalProject.readModel(LocalProject.locateCurrentProjectDir(path).resolve(POM_XML)), null);
    }

    public static LocalProject loadWorkspace(Path path) throws BootstrapException {
        LocalWorkspace ws = new LocalWorkspace();
        Path currentProjectDir = LocalProject.locateCurrentProjectDir(path);
        LocalProject project = LocalProject.load(ws, null, LocalProject.loadRootModel(currentProjectDir), currentProjectDir);
        return project == null ? LocalProject.load(ws, null, LocalProject.readModel(currentProjectDir.resolve(POM_XML)), currentProjectDir) : project;
    }

    private static LocalProject load(LocalWorkspace workspace, LocalProject parent, Model model, Path currentProjectDir) throws BootstrapException {
        LocalProject project = new LocalProject(model, workspace);
        if (parent != null) {
            parent.modules.add(project);
        }
        LocalProject result = currentProjectDir == null || !currentProjectDir.equals(project.getDir()) ? null : project;
        List modules = project.getRawModel().getModules();
        if (!modules.isEmpty()) {
            Path dirArg = result == null ? currentProjectDir : null;
            for (String module : modules) {
                LocalProject loaded = LocalProject.load(workspace, project, LocalProject.readModel(project.getDir().resolve(module).resolve(POM_XML)), dirArg);
                if (loaded == null || result != null) continue;
                result = loaded;
                dirArg = null;
            }
        }
        return result;
    }

    private static Model loadRootModel(Path currentProjectDir) throws BootstrapException {
        Path pomXml = currentProjectDir.resolve(POM_XML);
        Model model = LocalProject.readModel(pomXml);
        Parent parent = model.getParent();
        while (parent != null) {
            if (parent.getRelativePath() != null) {
                if (!Files.exists(pomXml = pomXml.getParent().resolve(parent.getRelativePath()).normalize(), new LinkOption[0])) {
                    return model;
                }
                if (Files.isDirectory(pomXml, new LinkOption[0])) {
                    pomXml = pomXml.resolve(POM_XML);
                }
            } else if (!Files.exists(pomXml = pomXml.getParent().getParent().resolve(POM_XML), new LinkOption[0])) {
                return model;
            }
            model = LocalProject.readModel(pomXml);
            parent = model.getParent();
        }
        return model;
    }

    private static final Model readModel(Path pom) throws BootstrapException {
        try {
            Model model = ModelUtils.readModel(pom);
            model.setPomFile(pom.toFile());
            return model;
        }
        catch (IOException e) {
            throw new BootstrapException("Failed to read " + pom, e);
        }
    }

    private static Path locateCurrentProjectDir(Path path) throws BootstrapException {
        for (Path p = path; p != null; p = p.getParent()) {
            if (!Files.exists(p.resolve(POM_XML), new LinkOption[0])) continue;
            return p;
        }
        throw new BootstrapException("Failed to locate project pom.xml for " + path);
    }

    private LocalProject(Model rawModel, LocalWorkspace workspace) throws BootstrapException {
        this.rawModel = rawModel;
        this.dir = rawModel.getProjectDirectory().toPath();
        this.workspace = workspace;
        Parent parent = rawModel.getParent();
        String groupId = rawModel.getGroupId();
        if (groupId == null) {
            if (parent == null) {
                throw new BootstrapException("Failed to determine groupId for " + rawModel.getPomFile());
            }
            this.groupId = parent.getGroupId();
        } else {
            this.groupId = groupId;
        }
        this.artifactId = rawModel.getArtifactId();
        String version = rawModel.getVersion();
        if (version == null) {
            if (parent == null) {
                throw new BootstrapException("Failed to determine version for " + rawModel.getPomFile());
            }
            this.version = parent.getVersion();
        } else {
            this.version = version;
        }
        if (workspace != null) {
            workspace.addProject(this, rawModel.getPomFile().lastModified());
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Path getDir() {
        return this.dir;
    }

    public Path getOutputDir() {
        return this.dir.resolve("target");
    }

    public Path getClassesDir() {
        return this.getOutputDir().resolve("classes");
    }

    public Path getSourcesSourcesDir() {
        if (this.getRawModel().getBuild() != null && this.getRawModel().getBuild().getSourceDirectory() != null) {
            String originalValue = this.getRawModel().getBuild().getSourceDirectory();
            return Paths.get(originalValue.startsWith(PROJECT_BASEDIR) ? originalValue.replace(PROJECT_BASEDIR, this.dir.toString()) : originalValue, new String[0]);
        }
        return this.dir.resolve("src/main/java");
    }

    public Path getResourcesSourcesDir() {
        Iterator iterator;
        if (this.getRawModel().getBuild() != null && this.getRawModel().getBuild().getResources() != null && (iterator = this.getRawModel().getBuild().getResources().iterator()).hasNext()) {
            Resource i = (Resource)iterator.next();
            return Paths.get(i.getDirectory(), new String[0]);
        }
        return this.dir.resolve("src/main/resources");
    }

    public Model getRawModel() {
        return this.rawModel;
    }

    public LocalWorkspace getWorkspace() {
        return this.workspace;
    }

    public AppArtifactKey getKey() {
        return new AppArtifactKey(this.groupId, this.artifactId);
    }

    public AppArtifact getAppArtifact() {
        AppArtifact appArtifact = new AppArtifact(this.groupId, this.artifactId, "", this.rawModel.getPackaging(), this.version);
        appArtifact.setPath(this.getClassesDir());
        return appArtifact;
    }

    public List<LocalProject> getSelfWithLocalDeps() {
        if (this.workspace == null) {
            return Collections.singletonList(this);
        }
        ArrayList<LocalProject> ordered = new ArrayList<LocalProject>();
        LocalProject.collectSelfWithLocalDeps(this, new HashSet<AppArtifactKey>(), ordered);
        return ordered;
    }

    private static void collectSelfWithLocalDeps(LocalProject project, Set<AppArtifactKey> addedDeps, List<LocalProject> ordered) {
        if (!project.modules.isEmpty()) {
            for (LocalProject module : project.modules) {
                LocalProject.collectSelfWithLocalDeps(module, addedDeps, ordered);
            }
        }
        for (Dependency dep : project.getRawModel().getDependencies()) {
            AppArtifactKey depKey = project.getKey(dep);
            LocalProject localDep = project.workspace.getProject(depKey);
            if (localDep == null || addedDeps.contains(depKey)) continue;
            LocalProject.collectSelfWithLocalDeps(localDep, addedDeps, ordered);
        }
        if (addedDeps.add(project.getKey())) {
            ordered.add(project);
        }
    }

    private AppArtifactKey getKey(Dependency dep) {
        return new AppArtifactKey(PROJECT_GROUPID.equals(dep.getGroupId()) ? this.getGroupId() : dep.getGroupId(), dep.getArtifactId());
    }
}

