/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;

public class BootstrapClassLoaderFactory {
    private static final String QUARKUS = "quarkus";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String DEPLOYMENT_CP = "deployment.cp";
    public static final String PROP_CP_CACHE = "quarkus-classpath-cache";
    public static final String PROP_WS_DISCOVERY = "quarkus-workspace-discovery";
    public static final String PROP_OFFLINE = "quarkus-bootstrap-offline";
    private static final int CP_CACHE_FORMAT_ID = 1;
    private static final Logger log = Logger.getLogger(BootstrapClassLoaderFactory.class);
    private ClassLoader parent;
    private Path appClasses;
    private List<Path> appCp = new ArrayList<Path>(0);
    private boolean localProjectsDiscovery;
    private Boolean offline;
    private boolean enableClasspathCache;

    public static BootstrapClassLoaderFactory newInstance() {
        return new BootstrapClassLoaderFactory();
    }

    private static URL[] toURLs(List<AppDependency> deps) throws BootstrapException {
        URL[] urls = new URL[deps.size()];
        BootstrapClassLoaderFactory.addDeps(urls, 0, deps);
        return urls;
    }

    private static URL toURL(Path p) throws BootstrapException {
        try {
            return p.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new BootstrapException("Failed to create a URL for " + p, e);
        }
    }

    private static int addDeps(URL[] urls, int offset, List<AppDependency> deps) throws BootstrapException {
        BootstrapClassLoaderFactory.assertCapacity(urls, offset, deps.size());
        int i = 0;
        while (i < deps.size()) {
            urls[offset + i] = BootstrapClassLoaderFactory.toURL(deps.get(i++).getArtifact().getPath());
        }
        return i + offset;
    }

    private static int addPaths(URL[] urls, int offset, List<Path> deps) throws BootstrapException {
        BootstrapClassLoaderFactory.assertCapacity(urls, offset, deps.size());
        int i = 0;
        while (i < deps.size()) {
            urls[offset + i] = BootstrapClassLoaderFactory.toURL(deps.get(i++));
        }
        return i + offset;
    }

    private static void assertCapacity(URL[] urls, int offset, int deps) throws BootstrapException {
        if (urls.length < offset + deps) {
            throw new BootstrapException("Failed to add dependency URLs: the target array of length " + urls.length + " is not big enough to add " + deps + " dependencies with offset " + offset);
        }
    }

    private static Path resolveCachedCpPath(LocalProject project) {
        return project.getOutputDir().resolve(QUARKUS).resolve(BOOTSTRAP).resolve(DEPLOYMENT_CP);
    }

    private static void persistCp(LocalProject project, URL[] urls, int limit, Path p) {
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(p, new OpenOption[0]);){
                writer.write(Integer.toString(1));
                writer.newLine();
                writer.write(Integer.toString(project.getWorkspace().getId()));
                writer.newLine();
                for (int i = 0; i < limit; ++i) {
                    writer.write(urls[i].toExternalForm());
                    writer.newLine();
                }
            }
            BootstrapClassLoaderFactory.debug("Deployment classpath for %s was cached in %s", project.getAppArtifact(), p);
        }
        catch (IOException e) {
            log.warn((Object)("Failed to persist deployment classpath cache in " + p + " for " + project.getAppArtifact()), (Throwable)e);
        }
    }

    private BootstrapClassLoaderFactory() {
    }

    public BootstrapClassLoaderFactory setParent(ClassLoader parent) {
        this.parent = parent;
        return this;
    }

    public BootstrapClassLoaderFactory setAppClasses(Path appClasses) {
        this.appClasses = appClasses;
        return this;
    }

    public BootstrapClassLoaderFactory addToClassPath(Path path) {
        this.appCp.add(path);
        return this;
    }

    public BootstrapClassLoaderFactory setLocalProjectsDiscovery(boolean localProjectsDiscovery) {
        this.localProjectsDiscovery = localProjectsDiscovery;
        return this;
    }

    public BootstrapClassLoaderFactory setOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }

    public BootstrapClassLoaderFactory setEnableClasspathCache(boolean enable) {
        this.enableClasspathCache = enable;
        return this;
    }

    public URLClassLoader newAllInclusiveClassLoader(boolean hierarchical) throws BootstrapException {
        if (this.appClasses == null) {
            throw new IllegalArgumentException("Application classes path has not been set");
        }
        try {
            LocalProject localProject;
            MavenArtifactResolver.Builder mvnBuilder = MavenArtifactResolver.builder();
            if (this.offline != null) {
                mvnBuilder.setOffline(this.offline);
            }
            if (this.localProjectsDiscovery) {
                localProject = LocalProject.loadWorkspace(this.appClasses);
                mvnBuilder.setWorkspace(localProject.getWorkspace());
            } else {
                localProject = LocalProject.load(this.appClasses);
            }
            AppModel appModel = new BootstrapAppModelResolver(mvnBuilder.build()).resolveModel(localProject.getAppArtifact());
            if (hierarchical) {
                URLClassLoader cl = this.initAppCp(appModel.getUserDependencies());
                try {
                    return new URLClassLoader(BootstrapClassLoaderFactory.toURLs(appModel.getDeploymentDependencies()), (ClassLoader)cl);
                }
                catch (Throwable e) {
                    try {
                        cl.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    throw e;
                }
            }
            return this.initAppCp(appModel.getAllDependencies());
        }
        catch (AppModelResolverException e) {
            throw new BootstrapException("Failed to init application classloader", e);
        }
    }

    private URLClassLoader initAppCp(List<AppDependency> deps) throws BootstrapException {
        URL[] urls = new URL[deps.size() + this.appCp.size() + 1];
        urls[0] = BootstrapClassLoaderFactory.toURL(this.appClasses);
        int offset = BootstrapClassLoaderFactory.addDeps(urls, 1, deps);
        if (!this.appCp.isEmpty()) {
            BootstrapClassLoaderFactory.addPaths(urls, offset, this.appCp);
        }
        return new URLClassLoader(urls, this.parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLClassLoader newDeploymentClassLoader() throws BootstrapException {
        if (this.appClasses == null) {
            throw new IllegalArgumentException("Application classes path has not been set");
        }
        Path cachedCpPath = null;
        LocalProject localProject = this.localProjectsDiscovery || this.enableClasspathCache ? LocalProject.loadWorkspace(this.appClasses) : LocalProject.load(this.appClasses);
        try {
            URL[] urls;
            if (this.enableClasspathCache && Files.exists(cachedCpPath = BootstrapClassLoaderFactory.resolveCachedCpPath(localProject), new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(cachedCpPath);){
                    if (BootstrapClassLoaderFactory.matchesInt(reader.readLine(), 1)) {
                        if (BootstrapClassLoaderFactory.matchesInt(reader.readLine(), localProject.getWorkspace().getId())) {
                            URL[] arr;
                            ArrayList<URL> urls2 = new ArrayList<URL>();
                            String line = reader.readLine();
                            while (line != null) {
                                urls2.add(new URL(line));
                                line = reader.readLine();
                            }
                            BootstrapClassLoaderFactory.debug("Deployment classloader for %s was re-created from the classpath cache", localProject.getAppArtifact());
                            if (this.appCp.isEmpty()) {
                                arr = urls2.toArray(new URL[urls2.size()]);
                            } else {
                                arr = new URL[urls2.size() + this.appCp.size()];
                                int i = 0;
                                while (i < urls2.size()) {
                                    arr[i] = (URL)urls2.get(i++);
                                }
                                BootstrapClassLoaderFactory.addPaths(arr, i, this.appCp);
                            }
                            URLClassLoader uRLClassLoader = new URLClassLoader(arr, this.parent);
                            return uRLClassLoader;
                        }
                        BootstrapClassLoaderFactory.debug("Cached deployment classpath has expired for %s", localProject.getAppArtifact());
                    } else {
                        BootstrapClassLoaderFactory.debug("Unsupported classpath cache format in %s for %s", cachedCpPath, localProject.getAppArtifact());
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Failed to read deployment classpath cache from " + cachedCpPath + " for " + localProject.getAppArtifact()), (Throwable)e);
                }
            }
            MavenArtifactResolver.Builder mvn = MavenArtifactResolver.builder().setWorkspace(localProject.getWorkspace());
            if (this.offline != null) {
                mvn.setOffline(this.offline);
            }
            List<AppDependency> deploymentDeps = new BootstrapAppModelResolver(mvn.build()).resolveModel(localProject.getAppArtifact()).getDeploymentDependencies();
            if (this.appCp.isEmpty()) {
                urls = BootstrapClassLoaderFactory.toURLs(deploymentDeps);
            } else {
                urls = new URL[deploymentDeps.size() + this.appCp.size()];
                BootstrapClassLoaderFactory.addDeps(urls, BootstrapClassLoaderFactory.addPaths(urls, 0, this.appCp), deploymentDeps);
            }
            if (cachedCpPath == null) return new URLClassLoader(urls, this.parent);
            BootstrapClassLoaderFactory.persistCp(localProject, urls, deploymentDeps.size(), cachedCpPath);
            return new URLClassLoader(urls, this.parent);
        }
        catch (AppModelResolverException e) {
            throw new BootstrapException("Failed to create the deployment classloader for " + localProject.getAppArtifact(), e);
        }
    }

    private static boolean matchesInt(String line, int value) {
        if (line == null) {
            return false;
        }
        try {
            return Integer.parseInt(line) == value;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static void debug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(msg, args));
        }
    }
}

