/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.MavenLocalRepositoryManager;
import io.quarkus.bootstrap.resolver.maven.MavenRepoInitializer;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

public class MavenArtifactResolver {
    protected final RepositorySystem repoSystem;
    protected final RepositorySystemSession repoSession;
    protected final List<RemoteRepository> remoteRepos;
    protected final MavenLocalRepositoryManager localRepoManager;

    public static Builder builder() {
        return new Builder();
    }

    private MavenArtifactResolver(Builder builder) throws AppModelResolverException {
        DefaultRepositorySystemSession newSession;
        this.repoSystem = builder.repoSystem == null ? MavenRepoInitializer.getRepositorySystem(builder.offline == null ? (builder.repoSession == null ? MavenRepoInitializer.getSettings().isOffline() : builder.repoSession.isOffline()) : builder.offline, builder.workspace) : builder.repoSystem;
        DefaultRepositorySystemSession defaultRepositorySystemSession = newSession = builder.repoSession == null ? MavenRepoInitializer.newSession(this.repoSystem) : new DefaultRepositorySystemSession(builder.repoSession);
        if (builder.offline != null) {
            newSession.setOffline(builder.offline.booleanValue());
        }
        if (builder.repoHome != null) {
            MavenLocalRepositoryManager appCreatorLocalRepoManager = new MavenLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager((RepositorySystemSession)newSession, new LocalRepository(builder.repoHome.toString())), Paths.get(MavenRepoInitializer.getLocalRepo(MavenRepoInitializer.getSettings()), new String[0]));
            newSession.setLocalRepositoryManager((LocalRepositoryManager)appCreatorLocalRepoManager);
            this.localRepoManager = appCreatorLocalRepoManager;
        } else {
            this.localRepoManager = null;
        }
        if (newSession.getCache() == null) {
            newSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        }
        if (builder.workspace != null) {
            newSession.setWorkspaceReader((WorkspaceReader)builder.workspace);
        }
        this.repoSession = newSession;
        this.remoteRepos = builder.remoteRepos == null ? MavenRepoInitializer.getRemoteRepos() : builder.remoteRepos;
    }

    public MavenLocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepoManager;
    }

    public RepositorySystem getSystem() {
        return this.repoSystem;
    }

    public RepositorySystemSession getSession() {
        return this.repoSession;
    }

    public List<RemoteRepository> getRepositories() {
        return this.remoteRepos;
    }

    public void addRemoteRepositories(List<RemoteRepository> repos) {
        this.remoteRepos.addAll(repos);
    }

    public ArtifactResult resolve(Artifact artifact) throws AppModelResolverException {
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact(artifact).setRepositories(this.remoteRepos));
        }
        catch (ArtifactResolutionException e) {
            throw new AppModelResolverException("Failed to resolve artifact " + artifact, e);
        }
    }

    public List<ArtifactResult> resolve(List<ArtifactRequest> artifacts) throws AppModelResolverException {
        try {
            return this.repoSystem.resolveArtifacts(this.repoSession, artifacts);
        }
        catch (ArtifactResolutionException e) {
            throw new AppModelResolverException("Failed to resolve artifacts", e);
        }
    }

    public ArtifactDescriptorResult resolveDescriptor(Artifact artifact) throws AppModelResolverException {
        try {
            return this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact(artifact));
        }
        catch (ArtifactDescriptorException e) {
            throw new AppModelResolverException("Failed to read descriptor of " + artifact, e);
        }
    }

    public VersionRangeResult resolveVersionRange(Artifact artifact) throws AppModelResolverException {
        try {
            return this.repoSystem.resolveVersionRange(this.repoSession, new VersionRangeRequest().setArtifact(artifact).setRepositories(this.remoteRepos));
        }
        catch (VersionRangeResolutionException ex) {
            throw new AppModelResolverException("Failed to resolve version range for " + artifact, ex);
        }
    }

    public CollectResult collectDependencies(Artifact artifact) throws AppModelResolverException {
        return this.collectDependencies(artifact, Collections.emptyList());
    }

    public DependencyResult resolveDependencies(Artifact artifact) throws AppModelResolverException {
        return this.resolveDependencies(artifact, Collections.emptyList());
    }

    public CollectResult collectDependencies(Artifact artifact, List<Dependency> deps) throws AppModelResolverException {
        CollectRequest request = this.newCollectRequest(artifact);
        request.setDependencies(deps);
        try {
            return this.repoSystem.collectDependencies(this.repoSession, request);
        }
        catch (DependencyCollectionException e) {
            throw new AppModelResolverException("Failed to collect dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolveDependencies(Artifact artifact, List<Dependency> deps) throws AppModelResolverException {
        CollectRequest request = this.newCollectRequest(artifact);
        request.setDependencies(deps);
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(request));
        }
        catch (DependencyResolutionException e) {
            throw new AppModelResolverException("Failed to resolve dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolveDependencies(Artifact artifact, String ... excludedScopes) throws AppModelResolverException {
        ArtifactDescriptorResult descr = this.resolveDescriptor(artifact);
        ArrayList<Dependency> deps = descr.getDependencies();
        if (excludedScopes.length > 0) {
            HashSet<String> excluded = new HashSet<String>(Arrays.asList(excludedScopes));
            deps = new ArrayList<Dependency>(deps.size());
            for (Dependency dep : descr.getDependencies()) {
                if (excluded.contains(dep.getScope())) continue;
                deps.add(dep);
            }
        }
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(new CollectRequest().setRootArtifact(artifact).setDependencies(deps).setManagedDependencies(descr.getManagedDependencies()).setRepositories(descr.getRepositories())));
        }
        catch (DependencyResolutionException e) {
            throw new AppModelResolverException("Failed to resolve dependencies for " + artifact, e);
        }
    }

    public void install(Artifact artifact) throws AppModelResolverException {
        try {
            this.repoSystem.install(this.repoSession, new InstallRequest().addArtifact(artifact));
        }
        catch (InstallationException ex) {
            throw new AppModelResolverException("Failed to install " + artifact, ex);
        }
    }

    private CollectRequest newCollectRequest(Artifact artifact) throws AppModelResolverException {
        return new CollectRequest().setRoot(new Dependency(artifact, "runtime")).setRepositories(this.remoteRepos);
    }

    public static class Builder {
        private Path repoHome;
        private RepositorySystem repoSystem;
        private RepositorySystemSession repoSession;
        private List<RemoteRepository> remoteRepos = null;
        private Boolean offline;
        private LocalWorkspace workspace;

        private Builder() {
        }

        public Builder setRepoHome(Path home) {
            this.repoHome = home;
            return this;
        }

        public Builder setRepositorySystem(RepositorySystem system) {
            this.repoSystem = system;
            return this;
        }

        public Builder setRepositorySystemSession(RepositorySystemSession session) {
            this.repoSession = session;
            return this;
        }

        public Builder setRemoteRepositories(List<RemoteRepository> repos) {
            this.remoteRepos = repos;
            return this;
        }

        public Builder setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder setWorkspace(LocalWorkspace workspace) {
            this.workspace = workspace;
            return this;
        }

        public MavenArtifactResolver build() throws AppModelResolverException {
            return new MavenArtifactResolver(this);
        }
    }
}

