/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import java.util.List;
import org.apache.maven.settings.Mirror;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;

class ProxyAwareMirrorSelector
implements MirrorSelector {
    private final ProxySelector proxySelector;
    private final MirrorSelector wrappedMirrorSelector;
    private static final ProxySelector NULL_PROXY_SELECTOR = new ProxySelector(){

        public Proxy getProxy(RemoteRepository repository) {
            return null;
        }
    };

    private static MirrorSelector createMirrorSelector(List<Mirror> mirrors) {
        DefaultMirrorSelector ms = new DefaultMirrorSelector();
        if (mirrors != null) {
            for (Mirror m : mirrors) {
                ms.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
            }
        }
        return ms;
    }

    ProxyAwareMirrorSelector(List<Mirror> mirrors, ProxySelector proxySelector) {
        this.wrappedMirrorSelector = ProxyAwareMirrorSelector.createMirrorSelector(mirrors);
        this.proxySelector = proxySelector == null ? NULL_PROXY_SELECTOR : proxySelector;
    }

    public RemoteRepository getMirror(RemoteRepository remoteRepository) {
        Proxy proxy;
        RemoteRepository remoteRepositoryResult = this.wrappedMirrorSelector.getMirror(remoteRepository);
        if (remoteRepositoryResult == null) {
            remoteRepositoryResult = remoteRepository;
        }
        if ((proxy = this.proxySelector.getProxy(remoteRepositoryResult)) == null) {
            return remoteRepositoryResult;
        }
        return new RemoteRepository.Builder(remoteRepositoryResult).setProxy(proxy).build();
    }
}

