/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class BootstrapUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int logUrls(ClassLoader cl) {
        Object[] urlStrs;
        String offset;
        int depth;
        block37: {
            URL[] urls;
            block38: {
                depth = 0;
                if (cl.getParent() != null) {
                    depth += BootstrapUtils.logUrls(cl.getParent());
                }
                StringBuilder buf = new StringBuilder();
                if (depth == 0) {
                    offset = "";
                } else {
                    for (int i = 0; i < depth; ++i) {
                        buf.append("  ");
                    }
                    offset = buf.toString();
                }
                if (!(cl instanceof URLClassLoader)) {
                    System.out.println(buf.append(cl.getClass().getName()).toString());
                    return depth + 1;
                }
                urls = ((URLClassLoader)cl).getURLs();
                if (urls.length != 1) break block38;
                Path p = Paths.get(urls[0].getFile(), new String[0]);
                if (Files.isDirectory(p, new LinkOption[0])) {
                    urlStrs = new String[]{urls[0].toExternalForm()};
                    break block37;
                } else {
                    try (FileSystem fs = FileSystems.newFileSystem(p, (ClassLoader)null);){
                        Manifest manifest;
                        Path path = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
                        if (!Files.exists(path, new LinkOption[0])) {
                            throw new IllegalStateException("Failed to locate the manifest");
                        }
                        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
                            manifest = new Manifest(input);
                        }
                        Attributes attrs = manifest.getMainAttributes();
                        urlStrs = attrs.getValue("Class-Path").split("\\s+");
                        break block37;
                    }
                    catch (Exception e1) {
                        throw new IllegalStateException("Failed to read MANIFEST.MF from " + urls[0]);
                    }
                }
            }
            urlStrs = new String[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                urlStrs[i] = url.toExternalForm();
            }
        }
        Arrays.sort(urlStrs);
        int i = 0;
        System.out.println(offset + cl);
        while (i < urlStrs.length) {
            System.out.println(offset + (i + 1) + ") " + (String)urlStrs[i++]);
        }
        return depth + 1;
    }

    public static void logUrlDiff(ClassLoader cl1, String cl1Header, ClassLoader cl2, String cl2Header) {
        HashSet<String> cl1Urls = new HashSet<String>();
        BootstrapUtils.collectUrls(cl1, cl1Urls);
        HashSet<String> cl2Urls = new HashSet<String>();
        BootstrapUtils.collectUrls(cl2, cl2Urls);
        int commonUrls = 0;
        Iterator i = cl1Urls.iterator();
        while (i.hasNext()) {
            String next = (String)i.next();
            if (!cl2Urls.remove(next)) continue;
            i.remove();
            ++commonUrls;
        }
        System.out.println("URLs not in " + cl2Header + ":");
        ArrayList<String> list = new ArrayList<String>(cl1Urls);
        Collections.sort(list);
        for (String s : list) {
            System.out.println(s);
        }
        System.out.println("URLs not in " + cl1Header + ":");
        list = new ArrayList<String>(cl2Urls);
        Collections.sort(list);
        for (String s : list) {
            System.out.println(s);
        }
        System.out.println("Common URLs: " + commonUrls);
    }

    private static void collectUrls(ClassLoader cl, Set<String> set) {
        URL[] urls;
        ClassLoader parent = cl.getParent();
        if (parent != null) {
            BootstrapUtils.collectUrls(parent, set);
        }
        if (!(cl instanceof URLClassLoader)) {
            return;
        }
        for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
            set.add(url.getFile());
        }
    }
}

