/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import java.io.Closeable;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class CuratedApplication
implements Serializable,
Closeable {
    private static final String AUGMENTOR = "io.quarkus.runner.bootstrap.AugmentActionImpl";
    private final Map<AppArtifact, List<ClassPathElement>> augmentationElements = new HashMap<AppArtifact, List<ClassPathElement>>();
    private volatile QuarkusClassLoader augmentClassLoader;
    private volatile QuarkusClassLoader baseRuntimeClassLoader;
    private final QuarkusBootstrap quarkusBootstrap;
    private final CurationResult curationResult;
    final AppModel appModel;

    CuratedApplication(QuarkusBootstrap quarkusBootstrap, CurationResult curationResult) {
        this.quarkusBootstrap = quarkusBootstrap;
        this.curationResult = curationResult;
        this.appModel = curationResult.getAppModel();
    }

    public AppModel getAppModel() {
        return this.appModel;
    }

    public QuarkusBootstrap getQuarkusBootstrap() {
        return this.quarkusBootstrap;
    }

    public boolean hasUpdatedDeps() {
        return this.curationResult.hasUpdatedDeps();
    }

    public List<AppDependency> getUpdatedDeps() {
        return this.curationResult.getUpdatedDependencies();
    }

    public Object runInAugmentClassLoader(String consumerName, Map<String, Object> params) {
        return this.runInCl(consumerName, params, this.getAugmentClassLoader());
    }

    public Object runInBaseRuntimeClassLoader(String consumerName, Map<String, Object> params) {
        return this.runInCl(consumerName, params, this.getBaseRuntimeClassLoader());
    }

    public CurationResult getCurationResult() {
        return this.curationResult;
    }

    public AugmentAction createAugmentor() {
        try {
            Class<?> augmentor = this.getAugmentClassLoader().loadClass(AUGMENTOR);
            return (AugmentAction)augmentor.getConstructor(CuratedApplication.class).newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AugmentAction createAugmentor(String functionName, Map<String, Object> props) {
        try {
            Class<?> augmentor = this.getAugmentClassLoader().loadClass(AUGMENTOR);
            Function function = (Function)this.getAugmentClassLoader().loadClass(functionName).newInstance();
            List res = (List)function.apply(props);
            return (AugmentAction)augmentor.getConstructor(CuratedApplication.class, List.class).newInstance(this, res);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object runInCl(String consumerName, Map<String, Object> params, QuarkusClassLoader cl) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> clazz = cl.loadClass(consumerName);
            BiConsumer biConsumer = (BiConsumer)clazz.newInstance();
            biConsumer.accept(this, params);
            BiConsumer biConsumer2 = biConsumer;
            return biConsumer2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private synchronized void processCpElement(AppArtifact artifact, Consumer<ClassPathElement> consumer) {
        if (!artifact.getType().equals("jar")) {
            consumer.accept(ClassPathElement.EMPTY);
            return;
        }
        List<ClassPathElement> cpeList = this.augmentationElements.get(artifact);
        if (cpeList != null) {
            for (ClassPathElement cpe : cpeList) {
                consumer.accept(cpe);
            }
            return;
        }
        cpeList = new ArrayList<ClassPathElement>(2);
        for (Path path : artifact.getPaths()) {
            ClassPathElement element = ClassPathElement.fromPath(path);
            consumer.accept(element);
            cpeList.add(element);
        }
        this.augmentationElements.put(artifact, cpeList);
    }

    private void addCpElement(QuarkusClassLoader.Builder builder, AppArtifact dep, ClassPathElement element) {
        AppArtifactKey key = dep.getKey();
        if (this.appModel.getParentFirstArtifacts().contains(key)) {
            builder.addParentFirstElement(element);
        } else if (this.appModel.getLesserPriorityArtifacts().contains(key)) {
            builder.addLesserPriorityElement(element);
        }
        builder.addElement(element);
    }

    public synchronized QuarkusClassLoader getAugmentClassLoader() {
        if (this.augmentClassLoader == null) {
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Augmentation Class Loader", this.quarkusBootstrap.getBaseClassLoader(), !this.quarkusBootstrap.isIsolateDeployment());
            builder.addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners());
            for (AppDependency appDependency : this.appModel.getFullDeploymentDeps()) {
                this.processCpElement(appDependency.getArtifact(), element -> this.addCpElement(builder, appDependency.getArtifact(), (ClassPathElement)element));
            }
            for (Path path : this.quarkusBootstrap.getAdditionalDeploymentArchives()) {
                builder.addElement(ClassPathElement.fromPath(path));
            }
            this.augmentClassLoader = builder.build();
        }
        return this.augmentClassLoader;
    }

    public synchronized QuarkusClassLoader getBaseRuntimeClassLoader() {
        if (this.baseRuntimeClassLoader == null) {
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Quarkus Base Runtime ClassLoader", this.quarkusBootstrap.getBaseClassLoader(), false);
            builder.addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners());
            if (this.quarkusBootstrap.getMode() == QuarkusBootstrap.Mode.TEST) {
                for (Path root : this.quarkusBootstrap.getApplicationRoot()) {
                    builder.addElement(ClassPathElement.fromPath(root));
                }
            }
            HashSet<Path> hotReloadPaths = new HashSet<Path>();
            for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
                if (!i.isHotReloadable()) {
                    for (Path root : i.getArchivePath()) {
                        builder.addElement(ClassPathElement.fromPath(root));
                    }
                    continue;
                }
                for (Path root : i.getArchivePath()) {
                    hotReloadPaths.add(root);
                }
            }
            builder.setResettableElement(new MemoryClassPathElement(Collections.emptyMap()));
            for (AppDependency dependency : this.appModel.getUserDependencies()) {
                if (CuratedApplication.isHotReloadable(dependency.getArtifact(), hotReloadPaths)) continue;
                this.processCpElement(dependency.getArtifact(), element -> this.addCpElement(builder, dependency.getArtifact(), (ClassPathElement)element));
            }
            this.baseRuntimeClassLoader = builder.build();
        }
        return this.baseRuntimeClassLoader;
    }

    private static boolean isHotReloadable(AppArtifact a, Set<Path> hotReloadPaths) {
        for (Path p : a.getPaths()) {
            if (!hotReloadPaths.contains(p)) continue;
            return true;
        }
        return false;
    }

    public QuarkusClassLoader createDeploymentClassLoader() {
        QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Deployment Class Loader", this.getAugmentClassLoader(), false).addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners()).setAggregateParentResources(true);
        for (Path root : this.quarkusBootstrap.getApplicationRoot()) {
            builder.addElement(ClassPathElement.fromPath(root));
        }
        builder.setResettableElement(new MemoryClassPathElement(Collections.emptyMap()));
        for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
            for (Path root : i.getArchivePath()) {
                builder.addElement(ClassPathElement.fromPath(root));
            }
        }
        return builder.build();
    }

    public QuarkusClassLoader createRuntimeClassLoader(QuarkusClassLoader loader, Map<String, byte[]> resources, Map<String, byte[]> transformedClasses) {
        QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Quarkus Runtime ClassLoader", loader, false).setAggregateParentResources(true);
        builder.setTransformedClasses(transformedClasses);
        builder.addElement(new MemoryClassPathElement(resources));
        for (Path root : this.quarkusBootstrap.getApplicationRoot()) {
            builder.addElement(ClassPathElement.fromPath(root));
        }
        for (AdditionalDependency i : this.getQuarkusBootstrap().getAdditionalApplicationArchives()) {
            if (!i.isHotReloadable()) continue;
            for (Path root : i.getArchivePath()) {
                builder.addElement(ClassPathElement.fromPath(root));
            }
        }
        return builder.build();
    }

    @Override
    public void close() {
        if (this.augmentClassLoader != null) {
            this.augmentClassLoader.close();
        }
        if (this.baseRuntimeClassLoader != null) {
            this.baseRuntimeClassLoader.close();
        }
    }
}

