/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.jbang;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JBangDevModeLauncherImpl
implements Closeable {
    private final CuratedApplication curatedApp;
    private final Closeable runningApp;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Closeable main(String ... args) {
        System.clearProperty("quarkus.dev");
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        URL url = JBangDevModeLauncherImpl.class.getClassLoader().getResource("jbang-dev.dat");
        String jarFilePath = url.getPath().substring(5, url.getPath().indexOf("!"));
        try (DataInputStream contextStream = new DataInputStream(JBangDevModeLauncherImpl.class.getClassLoader().getResourceAsStream("jbang-dev.dat"));){
            Object path;
            String pomContents = contextStream.readUTF();
            Path appClasses = Paths.get(contextStream.readUTF(), new String[0]);
            Path sourceFile = Paths.get(contextStream.readUTF(), new String[0]);
            int depCount = contextStream.readInt();
            HashMap<String, Path> deps = new HashMap<String, Path>();
            for (int i = 0; i < depCount; ++i) {
                String name = contextStream.readUTF();
                path = Paths.get(contextStream.readUTF(), new String[0]);
                deps.put(name, (Path)path);
            }
            Path projectRoot = Files.createTempDirectory("quarkus-jbang", new FileAttribute[0]);
            OutputStream out = Files.newOutputStream(projectRoot.resolve("pom.xml"), new OpenOption[0]);
            path = null;
            try {
                out.write(pomContents.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                path = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (path != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)path).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
            Path targetClasses = projectRoot.resolve("target/classes");
            Files.createDirectories(targetClasses, new FileAttribute[0]);
            try (ZipFile fz = new ZipFile(new File(jarFilePath));){
                Enumeration<? extends ZipEntry> entries = fz.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    Path path2 = targetClasses.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        Files.createDirectories(path2, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    Files.copy(fz.getInputStream(entry), path2, new CopyOption[0]);
                    Files.setLastModifiedTime(path2, entry.getLastModifiedTime());
                }
            }
            Path srcDir = projectRoot.resolve("src/main/java");
            Files.createDirectories(srcDir, new FileAttribute[0]);
            Files.createSymbolicLink(srcDir.resolve(sourceFile.getFileName().toString()), sourceFile, new FileAttribute[0]);
            LocalProject currentProject = LocalProject.loadWorkspace((Path)projectRoot);
            AppArtifact appArtifact = currentProject.getAppArtifact("jar");
            appArtifact.setPath(targetClasses);
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setBaseClassLoader(JBangDevModeLauncherImpl.class.getClassLoader()).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.DEV).setTargetDirectory(targetClasses).setAppArtifact(appArtifact).setManagingProject(new AppArtifact("io.quarkus", "quarkus-bom", "", "pom", JBangDevModeLauncherImpl.getQuarkusVersion())).setForcedDependencies(deps.entrySet().stream().map(s -> {
                AppArtifact artifact;
                String[] parts = ((String)s.getKey()).split(":");
                if (parts.length == 3) {
                    artifact = new AppArtifact(parts[0], parts[1], parts[2]);
                } else if (parts.length == 4) {
                    artifact = new AppArtifact(parts[0], parts[1], null, parts[2], parts[3]);
                } else if (parts.length == 5) {
                    artifact = new AppArtifact(parts[0], parts[1], parts[3], parts[2], parts[4]);
                } else {
                    throw new RuntimeException("Invalid artifact " + s);
                }
                artifact.setPath((Path)s.getValue());
                return new AppDependency(artifact, "compile");
            }).collect(Collectors.toList())).setApplicationRoot(targetClasses).setProjectRoot(projectRoot);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("app-project", currentProject);
            context.put("args", args);
            context.put("app-classes", targetClasses);
            BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setCurrentProject(currentProject));
            MavenArtifactResolver mvnResolver = new MavenArtifactResolver(mvnCtx);
            builder.setMavenArtifactResolver(mvnResolver);
            currentProject.getAppArtifact("jar").setPath(targetClasses);
            CuratedApplication curatedApp = builder.build().bootstrap();
            Object appInstance = curatedApp.runInAugmentClassLoader("io.quarkus.deployment.dev.IDEDevModeMain", context);
            JBangDevModeLauncherImpl jBangDevModeLauncherImpl = new JBangDevModeLauncherImpl(curatedApp, appInstance == null ? null : (appInstance instanceof Closeable ? (Closeable)appInstance : null));
            return jBangDevModeLauncherImpl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JBangDevModeLauncherImpl(CuratedApplication curatedApp, Closeable runningApp) {
        this.curatedApp = curatedApp;
        this.runningApp = runningApp;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.runningApp != null) {
                this.runningApp.close();
            }
        }
        finally {
            if (this.curatedApp != null) {
                this.curatedApp.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getQuarkusVersion() {
        try (InputStream in = JBangDevModeLauncherImpl.class.getClassLoader().getResourceAsStream("quarkus-version.txt");){
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[10];
            while ((r = in.read(buf)) > 0) {
                out.write(buf, 0, r);
            }
            String string = new String(out.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

