/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.devmode.DependenciesFilter;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.resolver.model.WorkspaceModule;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public class IDELauncherImpl
implements Closeable {
    private final CuratedApplication curatedApp;
    private final Closeable runningApp;

    public static Closeable launch(Path projectRoot, Map<String, Object> context) {
        try {
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setBaseClassLoader(IDELauncherImpl.class.getClassLoader()).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.DEV).setTargetDirectory(projectRoot.getParent());
            if (BuildToolHelper.isGradleProject(projectRoot)) {
                QuarkusModel quarkusModel = BuildToolHelper.enableGradleAppModelForDevMode(projectRoot);
                context.put("quarkus-internal.serialized-quarkus-model.path", QuarkusModelHelper.serializeQuarkusModel((QuarkusModel)quarkusModel));
                WorkspaceModule launchingModule = quarkusModel.getWorkspace().getMainModule();
                Path launchingModulePath = QuarkusModelHelper.getClassPath((WorkspaceModule)launchingModule);
                builder.setProjectRoot(launchingModulePath).setApplicationRoot(launchingModulePath).setTargetDirectory(launchingModule.getBuildDir().toPath());
                for (WorkspaceModule additionalModule : quarkusModel.getWorkspace().getAllModules()) {
                    if (additionalModule.getArtifactCoords().equals(launchingModule.getArtifactCoords())) continue;
                    builder.addAdditionalApplicationArchive(new AdditionalDependency(QuarkusModelHelper.toPathsCollection((Collection)additionalModule.getSourceSet().getSourceDirectories()), true, false));
                    builder.addAdditionalApplicationArchive(new AdditionalDependency(additionalModule.getSourceSet().getResourceDirectory().toPath(), true, false));
                }
            } else {
                builder.setApplicationRoot(projectRoot).setProjectRoot(projectRoot);
                LocalProject currentProject = LocalProject.loadWorkspace((Path)projectRoot);
                context.put("app-project", currentProject);
                BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setCurrentProject(currentProject));
                MavenArtifactResolver mvnResolver = new MavenArtifactResolver(mvnCtx);
                builder.setMavenArtifactResolver(mvnResolver);
                DependenciesFilter.filterNotReloadableDependencies(currentProject, mvnResolver).forEach(p -> builder.addLocalArtifact(new AppArtifactKey(p.getGroupId(), p.getArtifactId(), null, "jar")));
            }
            CuratedApplication curatedApp = builder.build().bootstrap();
            Object appInstance = curatedApp.runInAugmentClassLoader("io.quarkus.deployment.dev.IDEDevModeMain", context);
            return new IDELauncherImpl(curatedApp, appInstance == null ? null : (appInstance instanceof Closeable ? (Closeable)appInstance : null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IDELauncherImpl(CuratedApplication curatedApp, Closeable runningApp) {
        this.curatedApp = curatedApp;
        this.runningApp = runningApp;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.runningApp != null) {
                this.runningApp.close();
            }
        }
        finally {
            if (this.curatedApp != null) {
                this.curatedApp.close();
            }
        }
    }
}

