/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.MavenLocalRepositoryManager;
import io.quarkus.bootstrap.resolver.maven.MavenRepoInitializer;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.ServiceLocator;

public class MavenArtifactResolver {
    protected final RepositorySystem repoSystem;
    protected final RepositorySystemSession repoSession;
    protected final List<RemoteRepository> remoteRepos;
    protected final MavenLocalRepositoryManager localRepoManager;
    protected final RemoteRepositoryManager remoteRepoManager;

    public static Builder builder() {
        return new Builder();
    }

    private MavenArtifactResolver(Builder builder) throws AppModelResolverException {
        DefaultRepositorySystemSession newSession;
        this.repoSystem = builder.repoSystem == null ? MavenRepoInitializer.getRepositorySystem(builder.offline == null ? (builder.repoSession == null ? MavenRepoInitializer.getSettings().isOffline() : builder.repoSession.isOffline()) : builder.offline, builder.workspace) : builder.repoSystem;
        DefaultRepositorySystemSession defaultRepositorySystemSession = newSession = builder.repoSession == null ? MavenRepoInitializer.newSession(this.repoSystem) : new DefaultRepositorySystemSession(builder.repoSession);
        if (builder.offline != null) {
            newSession.setOffline(builder.offline.booleanValue());
        }
        MavenLocalRepositoryManager lrm = null;
        if (builder.repoHome != null) {
            if (builder.reTryFailedResolutionsAgainstDefaultLocalRepo) {
                lrm = new MavenLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager((RepositorySystemSession)newSession, new LocalRepository(builder.repoHome.toString())), Paths.get(MavenRepoInitializer.getLocalRepo(MavenRepoInitializer.getSettings()), new String[0]));
                newSession.setLocalRepositoryManager((LocalRepositoryManager)lrm);
            } else {
                newSession.setLocalRepositoryManager(this.repoSystem.newLocalRepositoryManager((RepositorySystemSession)newSession, new LocalRepository(builder.repoHome.toString())));
            }
        }
        this.localRepoManager = lrm;
        if (newSession.getCache() == null) {
            newSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        }
        if (builder.workspace != null) {
            newSession.setWorkspaceReader((WorkspaceReader)builder.workspace);
        }
        this.repoSession = newSession;
        this.remoteRepos = builder.remoteRepos == null ? MavenRepoInitializer.getRemoteRepos(this.repoSystem, this.repoSession) : builder.remoteRepos;
        DefaultRemoteRepositoryManager remoteRepoManager = new DefaultRemoteRepositoryManager();
        remoteRepoManager.initService((ServiceLocator)MavenRepositorySystemUtils.newServiceLocator());
        this.remoteRepoManager = remoteRepoManager;
    }

    public MavenLocalRepositoryManager getLocalRepositoryManager() {
        return this.localRepoManager;
    }

    public RepositorySystem getSystem() {
        return this.repoSystem;
    }

    public RepositorySystemSession getSession() {
        return this.repoSession;
    }

    public List<RemoteRepository> getRepositories() {
        return this.remoteRepos;
    }

    public void addRemoteRepositories(List<RemoteRepository> repos) {
        this.remoteRepos.addAll(repos);
    }

    public ArtifactResult resolve(Artifact artifact) throws AppModelResolverException {
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact(artifact).setRepositories(this.remoteRepos));
        }
        catch (ArtifactResolutionException e) {
            throw new AppModelResolverException("Failed to resolve artifact " + artifact, e);
        }
    }

    public List<ArtifactResult> resolve(List<ArtifactRequest> artifacts) throws AppModelResolverException {
        try {
            return this.repoSystem.resolveArtifacts(this.repoSession, artifacts);
        }
        catch (ArtifactResolutionException e) {
            throw new AppModelResolverException("Failed to resolve artifacts", e);
        }
    }

    public ArtifactDescriptorResult resolveDescriptor(Artifact artifact) throws AppModelResolverException {
        try {
            return this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact(artifact).setRepositories(this.remoteRepos));
        }
        catch (ArtifactDescriptorException e) {
            throw new AppModelResolverException("Failed to read descriptor of " + artifact, e);
        }
    }

    public VersionRangeResult resolveVersionRange(Artifact artifact) throws AppModelResolverException {
        try {
            return this.repoSystem.resolveVersionRange(this.repoSession, new VersionRangeRequest().setArtifact(artifact).setRepositories(this.remoteRepos));
        }
        catch (VersionRangeResolutionException ex) {
            throw new AppModelResolverException("Failed to resolve version range for " + artifact, ex);
        }
    }

    public CollectResult collectDependencies(Artifact artifact) throws AppModelResolverException {
        return this.collectDependencies(artifact, Collections.emptyList());
    }

    public DependencyResult resolveDependencies(Artifact artifact) throws AppModelResolverException {
        return this.resolveDependencies(artifact, Collections.emptyList());
    }

    public CollectResult collectDependencies(Artifact artifact, List<Dependency> deps) throws AppModelResolverException {
        return this.collectDependencies(artifact, deps, Collections.emptyList());
    }

    public CollectResult collectDependencies(Artifact artifact, List<Dependency> deps, List<RemoteRepository> mainRepos) throws AppModelResolverException {
        CollectRequest request = this.newCollectRequest(artifact, mainRepos);
        request.setDependencies(deps);
        try {
            return this.repoSystem.collectDependencies(this.repoSession, request);
        }
        catch (DependencyCollectionException e) {
            throw new AppModelResolverException("Failed to collect dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolveDependencies(Artifact artifact, List<Dependency> deps) throws AppModelResolverException {
        return this.resolveDependencies(artifact, deps, Collections.emptyList());
    }

    public DependencyResult resolveDependencies(Artifact artifact, List<Dependency> deps, List<RemoteRepository> mainRepos) throws AppModelResolverException {
        CollectRequest request = this.newCollectRequest(artifact, mainRepos);
        request.setDependencies(deps);
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(request));
        }
        catch (DependencyResolutionException e) {
            throw new AppModelResolverException("Failed to resolve dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolveDependencies(Artifact artifact, String ... excludedScopes) throws AppModelResolverException {
        ArtifactDescriptorResult descr = this.resolveDescriptor(artifact);
        ArrayList<Dependency> deps = descr.getDependencies();
        if (excludedScopes.length > 0) {
            HashSet<String> excluded = new HashSet<String>(Arrays.asList(excludedScopes));
            deps = new ArrayList<Dependency>(deps.size());
            for (Dependency dep : descr.getDependencies()) {
                if (excluded.contains(dep.getScope())) continue;
                deps.add(dep);
            }
        }
        List<RemoteRepository> requestRepos = this.aggregateRepositories(this.remoteRepos, this.newResolutionRepositories(descr.getRepositories()));
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(new CollectRequest().setRootArtifact(artifact).setDependencies(deps).setManagedDependencies(descr.getManagedDependencies()).setRepositories(requestRepos)));
        }
        catch (DependencyResolutionException e) {
            throw new AppModelResolverException("Failed to resolve dependencies for " + artifact, e);
        }
    }

    public DependencyResult resolveManagedDependencies(Artifact artifact, List<Dependency> deps, List<Dependency> managedDeps, String ... excludedScopes) throws AppModelResolverException {
        return this.resolveManagedDependencies(artifact, deps, managedDeps, Collections.emptyList(), excludedScopes);
    }

    public DependencyResult resolveManagedDependencies(Artifact artifact, List<Dependency> deps, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, String ... excludedScopes) throws AppModelResolverException {
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(this.newCollectManagedRequest(artifact, deps, managedDeps, mainRepos, excludedScopes)));
        }
        catch (DependencyResolutionException e) {
            throw new AppModelResolverException("Failed to resolve dependencies for " + artifact, e);
        }
    }

    public CollectResult collectManagedDependencies(Artifact artifact, List<Dependency> deps, List<Dependency> managedDeps, String ... excludedScopes) throws AppModelResolverException {
        return this.collectManagedDependencies(artifact, deps, managedDeps, Collections.emptyList(), excludedScopes);
    }

    public CollectResult collectManagedDependencies(Artifact artifact, List<Dependency> deps, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, String ... excludedScopes) throws AppModelResolverException {
        try {
            return this.repoSystem.collectDependencies(this.repoSession, this.newCollectManagedRequest(artifact, deps, managedDeps, mainRepos, excludedScopes));
        }
        catch (DependencyCollectionException e) {
            throw new AppModelResolverException("Failed to collect dependencies for " + artifact, e);
        }
    }

    private CollectRequest newCollectManagedRequest(Artifact artifact, List<Dependency> deps, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, String ... excludedScopes) throws AppModelResolverException {
        Collection<String> excluded;
        ArtifactDescriptorResult descr = this.resolveDescriptor(artifact);
        if (excludedScopes.length == 0) {
            excluded = Arrays.asList("test", "provided");
        } else if (excludedScopes.length == 1) {
            excluded = Collections.singleton(excludedScopes[0]);
        } else {
            excluded = Arrays.asList(excludedScopes);
            if (excludedScopes.length > 3) {
                excluded = new HashSet<String>(Arrays.asList(excludedScopes));
            }
        }
        ArrayList<Dependency> originalDeps = new ArrayList<Dependency>(descr.getDependencies().size());
        for (Dependency dep : descr.getDependencies()) {
            if (excluded.contains(dep.getScope())) continue;
            originalDeps.add(dep);
        }
        ArrayList<Dependency> mergedManagedDeps = new ArrayList<Dependency>(managedDeps.size() + descr.getManagedDependencies().size());
        Map<AppArtifactKey, String> managedVersions = Collections.emptyMap();
        if (!managedDeps.isEmpty()) {
            managedVersions = new HashMap(managedDeps.size());
            for (Dependency dep : managedDeps) {
                managedVersions.put(MavenArtifactResolver.getId(dep.getArtifact()), dep.getArtifact().getVersion());
                mergedManagedDeps.add(dep);
            }
        }
        if (!descr.getManagedDependencies().isEmpty()) {
            for (Dependency dep : descr.getManagedDependencies()) {
                AppArtifactKey key = MavenArtifactResolver.getId(dep.getArtifact());
                if (managedVersions.containsKey(key)) continue;
                mergedManagedDeps.add(dep);
            }
        }
        List<RemoteRepository> repos = this.aggregateRepositories(mainRepos, this.remoteRepos);
        return new CollectRequest().setRootArtifact(artifact).setDependencies(this.mergeDeps(deps, originalDeps, managedVersions)).setManagedDependencies(mergedManagedDeps).setRepositories(this.aggregateRepositories(repos, this.newResolutionRepositories(descr.getRepositories())));
    }

    public List<RemoteRepository> newResolutionRepositories(List<RemoteRepository> repos) {
        return repos.isEmpty() ? Collections.emptyList() : this.repoSystem.newResolutionRepositories(this.repoSession, repos);
    }

    public List<RemoteRepository> aggregateRepositories(List<RemoteRepository> dominant, List<RemoteRepository> recessive) {
        return dominant.isEmpty() ? recessive : this.remoteRepoManager.aggregateRepositories(this.repoSession, dominant, recessive, false);
    }

    public void install(Artifact artifact) throws AppModelResolverException {
        try {
            this.repoSystem.install(this.repoSession, new InstallRequest().addArtifact(artifact));
        }
        catch (InstallationException ex) {
            throw new AppModelResolverException("Failed to install " + artifact, ex);
        }
    }

    private CollectRequest newCollectRequest(Artifact artifact, List<RemoteRepository> mainRepos) throws AppModelResolverException {
        return new CollectRequest().setRoot(new Dependency(artifact, "runtime")).setRepositories(this.aggregateRepositories(mainRepos, this.remoteRepos));
    }

    private List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive, Map<AppArtifactKey, String> managedVersions) {
        String managedVersion;
        AppArtifactKey id;
        int initialCapacity = dominant.size() + recessive.size();
        if (initialCapacity == 0) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>(initialCapacity);
        HashSet<AppArtifactKey> ids = new HashSet<AppArtifactKey>(initialCapacity, 1.0f);
        for (Dependency dependency : dominant) {
            id = MavenArtifactResolver.getId(dependency.getArtifact());
            ids.add(id);
            managedVersion = managedVersions.get(id);
            if (managedVersion != null) {
                dependency = dependency.setArtifact(dependency.getArtifact().setVersion(managedVersion));
            }
            result.add(dependency);
        }
        for (Dependency dependency : recessive) {
            id = MavenArtifactResolver.getId(dependency.getArtifact());
            if (ids.contains(id)) continue;
            managedVersion = managedVersions.get(id);
            if (managedVersion != null) {
                dependency = dependency.setArtifact(dependency.getArtifact().setVersion(managedVersion));
            }
            result.add(dependency);
        }
        return result;
    }

    private static AppArtifactKey getId(Artifact a) {
        return new AppArtifactKey(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension());
    }

    public static class Builder {
        private Path repoHome;
        private boolean reTryFailedResolutionsAgainstDefaultLocalRepo;
        private RepositorySystem repoSystem;
        private RepositorySystemSession repoSession;
        private List<RemoteRepository> remoteRepos = null;
        private Boolean offline;
        private LocalWorkspace workspace;

        private Builder() {
        }

        public Builder setReTryFailedResolutionsAgainstDefaultLocalRepo(boolean value) {
            this.reTryFailedResolutionsAgainstDefaultLocalRepo = value;
            return this;
        }

        public Builder setRepoHome(Path home) {
            this.repoHome = home;
            return this;
        }

        public Builder setRepositorySystem(RepositorySystem system) {
            this.repoSystem = system;
            return this;
        }

        public Builder setRepositorySystemSession(RepositorySystemSession session) {
            this.repoSession = session;
            return this;
        }

        public Builder setRemoteRepositories(List<RemoteRepository> repos) {
            this.remoteRepos = repos;
            return this;
        }

        public Builder setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder setWorkspace(LocalWorkspace workspace) {
            this.workspace = workspace;
            return this;
        }

        public MavenArtifactResolver build() throws AppModelResolverException {
            return new MavenArtifactResolver(this);
        }
    }
}

