/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.DirectoryClassPathElement;
import io.quarkus.bootstrap.classloading.JarClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import java.io.Closeable;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.objectweb.asm.ClassVisitor;

public class CuratedApplication
implements Serializable,
Closeable {
    private static final String AUGMENTOR = "io.quarkus.runner.bootstrap.AugmentActionImpl";
    private final Map<AppArtifact, ClassPathElement> augmentationElements = new HashMap<AppArtifact, ClassPathElement>();
    private volatile QuarkusClassLoader augmentClassLoader;
    private volatile QuarkusClassLoader baseRuntimeClassLoader;
    private final QuarkusBootstrap quarkusBootstrap;
    private final CurationResult curationResult;
    final AppModel appModel;

    CuratedApplication(QuarkusBootstrap quarkusBootstrap, CurationResult curationResult) {
        this.quarkusBootstrap = quarkusBootstrap;
        this.curationResult = curationResult;
        this.appModel = curationResult.getAppModel();
    }

    public AppModel getAppModel() {
        return this.appModel;
    }

    public QuarkusBootstrap getQuarkusBootstrap() {
        return this.quarkusBootstrap;
    }

    public boolean hasUpdatedDeps() {
        return this.curationResult.hasUpdatedDeps();
    }

    public List<AppDependency> getUpdatedDeps() {
        return this.curationResult.getUpdatedDependencies();
    }

    public Object runInAugmentClassLoader(String consumerName, Map<String, Object> params) {
        return this.runInCl(consumerName, params, this.getAugmentClassLoader());
    }

    public Object runInBaseRuntimeClassLoader(String consumerName, Map<String, Object> params) {
        return this.runInCl(consumerName, params, this.getBaseRuntimeClassLoader());
    }

    public CurationResult getCurationResult() {
        return this.curationResult;
    }

    public AugmentAction createAugmentor() {
        try {
            Class<?> augmentor = this.getAugmentClassLoader().loadClass(AUGMENTOR);
            return (AugmentAction)augmentor.getConstructor(CuratedApplication.class).newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AugmentAction createAugmentor(String functionName, Map<String, Object> props) {
        try {
            Class<?> augmentor = this.getAugmentClassLoader().loadClass(AUGMENTOR);
            Function function = (Function)this.getAugmentClassLoader().loadClass(functionName).newInstance();
            List res = (List)function.apply(props);
            return (AugmentAction)augmentor.getConstructor(CuratedApplication.class, List.class).newInstance(this, res);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object runInCl(String consumerName, Map<String, Object> params, QuarkusClassLoader cl) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> clazz = cl.loadClass(consumerName);
            BiConsumer biConsumer = (BiConsumer)clazz.newInstance();
            biConsumer.accept(this, params);
            BiConsumer biConsumer2 = biConsumer;
            return biConsumer2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private synchronized ClassPathElement getElement(AppArtifact artifact) {
        if (!artifact.getType().equals("jar")) {
            return ClassPathElement.EMPTY;
        }
        if (this.augmentationElements.containsKey(artifact)) {
            return this.augmentationElements.get(artifact);
        }
        Path path = artifact.getPath();
        ClassPathElement element = Files.isDirectory(path, new LinkOption[0]) ? new DirectoryClassPathElement(path) : new JarClassPathElement(path);
        this.augmentationElements.put(artifact, element);
        return element;
    }

    public synchronized QuarkusClassLoader getAugmentClassLoader() {
        if (this.augmentClassLoader == null) {
            ClassPathElement element;
            AppArtifactKey key;
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Augmentation Class Loader", this.quarkusBootstrap.getBaseClassLoader(), !this.quarkusBootstrap.isIsolateDeployment());
            HashSet<AppArtifact> deploymentArtifacts = new HashSet<AppArtifact>();
            for (AppDependency appDependency : this.appModel.getFullDeploymentDeps()) {
                key = this.getKey(appDependency);
                deploymentArtifacts.add(appDependency.getArtifact());
                element = this.getElement(appDependency.getArtifact());
                builder.addElement(element);
                if (this.appModel.getParentFirstArtifacts().contains(key)) {
                    builder.addParentFirstElement(element);
                    continue;
                }
                if (!this.appModel.getLesserPriorityArtifacts().contains(key)) continue;
                builder.addLesserPriorityElement(element);
            }
            for (AppDependency appDependency : this.appModel.getUserDependencies()) {
                if (deploymentArtifacts.contains(appDependency.getArtifact())) continue;
                key = this.getKey(appDependency);
                element = this.getElement(appDependency.getArtifact());
                if (this.appModel.getParentFirstArtifacts().contains(key)) {
                    builder.addParentFirstElement(element);
                } else if (this.appModel.getLesserPriorityArtifacts().contains(key)) {
                    builder.addLesserPriorityElement(element);
                }
                builder.addElement(element);
            }
            for (Path path : this.quarkusBootstrap.getAdditionalDeploymentArchives()) {
                builder.addElement(ClassPathElement.fromPath(path));
            }
            this.augmentClassLoader = builder.build();
        }
        return this.augmentClassLoader;
    }

    private AppArtifactKey getKey(AppDependency i) {
        return i.getArtifact().getKey();
    }

    public synchronized QuarkusClassLoader getBaseRuntimeClassLoader() {
        if (this.baseRuntimeClassLoader == null) {
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Quarkus Base Runtime ClassLoader", this.quarkusBootstrap.getBaseClassLoader(), false);
            if (this.quarkusBootstrap.getMode() == QuarkusBootstrap.Mode.TEST) {
                for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
                    if (!i.isTestClassRoot()) continue;
                    builder.addElement(ClassPathElement.fromPath(i.getArchivePath()));
                }
                builder.addElement(ClassPathElement.fromPath(this.getQuarkusBootstrap().getApplicationRoot()));
            }
            HashSet<Path> hotReloadPaths = new HashSet<Path>();
            for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
                if (i.isTestClassRoot()) continue;
                if (!i.isHotReloadable()) {
                    builder.addElement(ClassPathElement.fromPath(i.getArchivePath()));
                    continue;
                }
                hotReloadPaths.add(i.getArchivePath());
            }
            builder.setResettableElement(new MemoryClassPathElement(Collections.emptyMap()));
            for (AppDependency dependency : this.appModel.getUserDependencies()) {
                if (hotReloadPaths.contains(dependency.getArtifact().getPath())) continue;
                AppArtifactKey key = this.getKey(dependency);
                ClassPathElement element = this.getElement(dependency.getArtifact());
                if (this.appModel.getParentFirstArtifacts().contains(key)) {
                    builder.addParentFirstElement(element);
                } else if (this.appModel.getLesserPriorityArtifacts().contains(key)) {
                    builder.addLesserPriorityElement(element);
                }
                builder.addElement(element);
            }
            this.baseRuntimeClassLoader = builder.build();
        }
        return this.baseRuntimeClassLoader;
    }

    public QuarkusClassLoader createDeploymentClassLoader() {
        QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Deployment Class Loader", this.getAugmentClassLoader(), false).setAggregateParentResources(true);
        for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
            if (!i.isTestClassRoot()) continue;
            builder.addElement(ClassPathElement.fromPath(i.getArchivePath()));
        }
        builder.addElement(ClassPathElement.fromPath(this.quarkusBootstrap.getApplicationRoot()));
        for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
            if (i.isTestClassRoot()) continue;
            builder.addElement(ClassPathElement.fromPath(i.getArchivePath()));
        }
        return builder.build();
    }

    public QuarkusClassLoader createRuntimeClassLoader(QuarkusClassLoader loader, Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> bytecodeTransformers, ClassLoader deploymentClassLoader, Map<String, byte[]> resources) {
        QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Quarkus Runtime ClassLoader", loader, false).setAggregateParentResources(true);
        builder.setTransformerClassLoader(deploymentClassLoader);
        builder.addElement(ClassPathElement.fromPath(this.getQuarkusBootstrap().getApplicationRoot()));
        builder.addElement(new MemoryClassPathElement(resources));
        for (AdditionalDependency i : this.getQuarkusBootstrap().getAdditionalApplicationArchives()) {
            if (!i.isHotReloadable()) continue;
            builder.addElement(ClassPathElement.fromPath(i.getArchivePath()));
        }
        builder.setBytecodeTransformers(bytecodeTransformers);
        return builder.build();
    }

    @Override
    public void close() {
        if (this.augmentClassLoader != null) {
            this.augmentClassLoader.close();
        }
        if (this.baseRuntimeClassLoader != null) {
            this.baseRuntimeClassLoader.close();
        }
    }
}

