/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.ZipUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.logging.Logger;

public class DeploymentInjectingDependencyVisitor {
    private static final Logger log = Logger.getLogger(DeploymentInjectingDependencyVisitor.class);
    static final String QUARKUS_RUNTIME_ARTIFACT = "quarkus.runtime";
    private static final String QUARKUS_DEPLOYMENT_ARTIFACT = "quarkus.deployment";
    private final MavenArtifactResolver resolver;
    private final List<Dependency> managedDeps;
    private final List<Dependency> runtimeExtensionDeps = new ArrayList<Dependency>();
    private final List<RemoteRepository> mainRepos;
    boolean injectedDeps;
    private List<DependencyNode> runtimeNodes = new ArrayList<DependencyNode>();
    private final AppModel.Builder appBuilder;

    public static Artifact getRuntimeArtifact(DependencyNode dep) {
        return (Artifact)dep.getData().get(QUARKUS_RUNTIME_ARTIFACT);
    }

    public DeploymentInjectingDependencyVisitor(MavenArtifactResolver resolver, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, AppModel.Builder appBuilder) {
        this.resolver = resolver;
        this.managedDeps = managedDeps.isEmpty() ? new ArrayList() : managedDeps;
        this.mainRepos = mainRepos;
        this.appBuilder = appBuilder;
    }

    public boolean isInjectedDeps() {
        return this.injectedDeps;
    }

    public void injectDeploymentDependencies(DependencyNode root) throws BootstrapDependencyProcessingException {
        this.collectRuntimeExtensions(root.getChildren());
        for (DependencyNode rtNode : this.runtimeNodes) {
            this.replaceWith(rtNode, this.collectDependencies((Artifact)rtNode.getData().get(QUARKUS_DEPLOYMENT_ARTIFACT)));
        }
    }

    public void collectRuntimeExtensions(List<DependencyNode> list) {
        if (list.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            this.collectRuntimeExtensions(list.get(i++));
        }
    }

    private void collectRuntimeExtensions(DependencyNode node) {
        block16: {
            Artifact artifact = node.getArtifact();
            if (!artifact.getExtension().equals("jar")) {
                return;
            }
            Path path = this.resolve(artifact);
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.processMetaInfDir(node, path.resolve("META-INF"));
                    break block16;
                }
                try (FileSystem artifactFs = ZipUtils.newFileSystem(path);){
                    this.processMetaInfDir(node, artifactFs.getPath("META-INF", new String[0]));
                }
            }
            catch (Exception t) {
                throw new DeploymentInjectionException("Failed to inject extension deplpyment dependencies", t);
            }
        }
        this.collectRuntimeExtensions(node.getChildren());
    }

    private void processMetaInfDir(DependencyNode node, Path metaInfDir) throws BootstrapDependencyProcessingException {
        if (!Files.exists(metaInfDir, new LinkOption[0])) {
            return;
        }
        Path p = metaInfDir.resolve("quarkus-extension.properties");
        if (!Files.exists(p, new LinkOption[0])) {
            return;
        }
        this.processPlatformArtifact(node, p);
    }

    private void processPlatformArtifact(DependencyNode node, Path descriptor) throws BootstrapDependencyProcessingException {
        Properties rtProps = this.resolveDescriptor(descriptor);
        if (rtProps == null) {
            return;
        }
        String value = rtProps.getProperty("deployment-artifact");
        this.appBuilder.handleExtensionProperties(rtProps, node.getArtifact().toString());
        if (value == null) {
            return;
        }
        Artifact deploymentArtifact = DeploymentInjectingDependencyVisitor.toArtifact(value);
        if (deploymentArtifact.getVersion() == null || deploymentArtifact.getVersion().isEmpty()) {
            deploymentArtifact = deploymentArtifact.setVersion(node.getArtifact().getVersion());
        }
        node.setData((Object)QUARKUS_DEPLOYMENT_ARTIFACT, (Object)deploymentArtifact);
        this.runtimeNodes.add(node);
        Dependency dependency = new Dependency(node.getArtifact(), "compile");
        this.runtimeExtensionDeps.add(dependency);
        this.managedDeps.add(new Dependency(deploymentArtifact, "compile"));
    }

    public List<Dependency> getRuntimeExtensionDeps() {
        return this.runtimeExtensionDeps;
    }

    private void replaceWith(DependencyNode originalNode, DependencyNode newNode) throws BootstrapDependencyProcessingException {
        List children = newNode.getChildren();
        if (children.isEmpty()) {
            throw new BootstrapDependencyProcessingException("No dependencies collected for Quarkus extension deployment artifact " + newNode.getArtifact() + " while at least the corresponding runtime artifact " + originalNode.getArtifact() + " is expected");
        }
        log.debugf("Injecting deployment dependency %s", (Object)newNode);
        originalNode.setData((Object)QUARKUS_RUNTIME_ARTIFACT, (Object)originalNode.getArtifact());
        originalNode.setArtifact(newNode.getArtifact());
        originalNode.getDependency().setArtifact(newNode.getArtifact());
        originalNode.setChildren(children);
        this.injectedDeps = true;
    }

    private DependencyNode collectDependencies(Artifact artifact) throws BootstrapDependencyProcessingException {
        try {
            return this.managedDeps.isEmpty() ? this.resolver.collectDependencies(artifact, Collections.emptyList(), this.mainRepos).getRoot() : this.resolver.collectManagedDependencies(artifact, Collections.emptyList(), this.managedDeps, this.mainRepos, "test").getRoot();
        }
        catch (AppModelResolverException e) {
            throw new DeploymentInjectionException(e);
        }
    }

    private Path resolve(Artifact artifact) {
        File file = artifact.getFile();
        if (file != null) {
            return file.toPath();
        }
        try {
            return this.resolver.resolve(artifact).getArtifact().getFile().toPath();
        }
        catch (AppModelResolverException e) {
            throw new DeploymentInjectionException(e);
        }
    }

    private Properties resolveDescriptor(Path path) throws BootstrapDependencyProcessingException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        catch (IOException e) {
            throw new BootstrapDependencyProcessingException("Failed to load " + path, e);
        }
        return rtProps;
    }

    public static Artifact toArtifact(String str) {
        return DeploymentInjectingDependencyVisitor.toArtifact(str, 0);
    }

    public static Artifact toArtifact(String str, int offset) {
        String groupId = null;
        String artifactId = null;
        String classifier = "";
        String type = "jar";
        String version = null;
        int colon = str.indexOf(58, offset);
        int length = str.length();
        if (colon < offset + 1 || colon == length - 1) {
            DeploymentInjectingDependencyVisitor.illegalDependencyFormat(str);
        }
        groupId = str.substring(offset, colon);
        offset = colon + 1;
        if ((colon = str.indexOf(58, offset)) < 0) {
            artifactId = str.substring(offset, length);
        } else {
            if (colon == length - 1) {
                DeploymentInjectingDependencyVisitor.illegalDependencyFormat(str);
            }
            artifactId = str.substring(offset, colon);
            offset = colon + 1;
            if ((colon = str.indexOf(58, offset)) < 0) {
                version = str.substring(offset, length);
            } else {
                if (colon == length - 1) {
                    DeploymentInjectingDependencyVisitor.illegalDependencyFormat(str);
                }
                type = str.substring(offset, colon);
                offset = colon + 1;
                if ((colon = str.indexOf(58, offset)) < 0) {
                    version = str.substring(offset, length);
                } else {
                    if (colon == length - 1) {
                        DeploymentInjectingDependencyVisitor.illegalDependencyFormat(str);
                    }
                    classifier = type;
                    type = str.substring(offset, colon);
                    version = str.substring(colon + 1);
                }
            }
        }
        return new DefaultArtifact(groupId, artifactId, classifier, type, version);
    }

    private static void illegalDependencyFormat(String str) {
        throw new IllegalArgumentException("Bad artifact coordinates " + str + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
    }
}

