/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.TsArtifact;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;

public class TsDependency {
    protected final TsArtifact artifact;
    protected String scope;
    protected boolean optional;
    protected List<TsArtifact> excluded = Collections.emptyList();

    public TsDependency(TsArtifact artifact) {
        this(artifact, null, false);
    }

    public TsDependency(TsArtifact artifact, String scope) {
        this(artifact, scope, false);
    }

    public TsDependency(TsArtifact artifact, boolean optional) {
        this(artifact, null, optional);
    }

    public TsDependency(TsArtifact artifact, String scope, boolean optional) {
        this.artifact = artifact;
        this.scope = scope;
        this.optional = optional;
    }

    public TsDependency exclude(String artifactId) {
        return this.exclude(TsArtifact.ga(artifactId));
    }

    public TsDependency exclude(String groupId, String artifactId) {
        return this.exclude(TsArtifact.ga(groupId, artifactId));
    }

    public TsDependency exclude(TsArtifact artifact) {
        if (this.excluded.isEmpty()) {
            this.excluded = new ArrayList<TsArtifact>();
        }
        this.excluded.add(artifact);
        return this;
    }

    public TsDependency exclude(TsArtifact ... artifacts) {
        for (TsArtifact artifact : artifacts) {
            this.exclude(artifact);
        }
        return this;
    }

    public Dependency toPomDependency() {
        Dependency dep = new Dependency();
        dep.setGroupId(this.artifact.groupId);
        dep.setArtifactId(this.artifact.artifactId);
        String updateClassifier = this.artifact.classifier;
        if (updateClassifier != null && !updateClassifier.isEmpty()) {
            dep.setClassifier(updateClassifier);
        }
        dep.setType(this.artifact.type);
        dep.setVersion(this.artifact.version);
        if (this.scope != null) {
            dep.setScope(this.scope);
        }
        if (this.optional) {
            dep.setOptional(this.optional);
        }
        if (!this.excluded.isEmpty()) {
            for (TsArtifact excluded : this.excluded) {
                Exclusion exclusion = new Exclusion();
                exclusion.setGroupId(excluded.groupId);
                exclusion.setArtifactId(excluded.artifactId);
                dep.addExclusion(exclusion);
            }
        }
        return dep;
    }
}

