/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloader;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.util.IoUtils;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ClassLoadingResourceUrlTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"paths"})
    public void testUrlReturnedFromClassLoaderDirectory(String testPath) throws Exception {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).add((Asset)new StringAsset("a"), "a.txt")).add((Asset)new StringAsset("b"), "b/b.txt");
        Path path = Files.createTempDirectory(testPath, new FileAttribute[0]);
        try {
            ((ExplodedExporter)jar.as(ExplodedExporter.class)).exportExploded(path.toFile(), "tmp");
            QuarkusClassLoader cl = QuarkusClassLoader.builder((String)"test", (ClassLoader)this.getClass().getClassLoader(), (boolean)false).addElement(ClassPathElement.fromPath((Path)path.resolve("tmp"), (boolean)true)).build();
            URL res = cl.getResource("a.txt");
            Assertions.assertNotNull((Object)res);
            Assertions.assertNull((Object)res.getQuery());
            res = cl.getResource("a.txt/");
            Assertions.assertNull((Object)res);
            res = cl.getResource("b");
            Assertions.assertNotNull((Object)res);
            Assertions.assertFalse((boolean)res.toExternalForm().endsWith("/"));
            res = cl.getResource("b/");
            Assertions.assertNotNull((Object)res);
            Assertions.assertTrue((boolean)res.toExternalForm().endsWith("/"));
        }
        finally {
            IoUtils.recursiveDelete((Path)path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"paths"})
    public void testResourceAsStreamForDirectory(String testPath) throws Exception {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).add((Asset)new StringAsset("a"), "a.txt")).add((Asset)new StringAsset("b"), "b/b.txt");
        Path tmpDir = Files.createTempDirectory(testPath, new FileAttribute[0]);
        try {
            ((ExplodedExporter)jar.as(ExplodedExporter.class)).exportExploded(tmpDir.toFile(), "tmpcltest");
            QuarkusClassLoader cl = QuarkusClassLoader.builder((String)"test", (ClassLoader)this.getClass().getClassLoader(), (boolean)false).addElement(ClassPathElement.fromPath((Path)tmpDir.resolve("tmpcltest"), (boolean)true)).build();
            try (InputStream is = cl.getResourceAsStream("b/");){
                Assertions.assertNotNull((Object)is, (String)"InputStream is null for a directory resource");
            }
            is = cl.getResourceAsStream("b");
            try {
                Assertions.assertNotNull((Object)is, (String)"InputStream is null for a directory resource");
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        finally {
            IoUtils.recursiveDelete((Path)tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"paths"})
    public void testUrlReturnedFromClassLoaderJarFile(String testPath) throws Exception {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).add((Asset)new StringAsset("a"), "a.txt")).add((Asset)new StringAsset("b"), "b/b.txt");
        Path path = Files.createTempFile(testPath, "quarkus-test.jar", new FileAttribute[0]);
        try {
            ((ZipExporter)jar.as(ZipExporter.class)).exportTo(path.toFile(), true);
            QuarkusClassLoader cl = QuarkusClassLoader.builder((String)"test", (ClassLoader)this.getClass().getClassLoader(), (boolean)false).addElement(ClassPathElement.fromPath((Path)path, (boolean)true)).build();
            URL res = cl.getResource("a.txt");
            Assertions.assertNotNull((Object)res);
            Assertions.assertNull((Object)res.getQuery());
            res = cl.getResource("a.txt/");
            Assertions.assertNull((Object)res);
            res = cl.getResource("b");
            Assertions.assertNotNull((Object)res);
            Assertions.assertFalse((boolean)res.toExternalForm().endsWith("/"));
            res = cl.getResource("b/");
            Assertions.assertNotNull((Object)res);
            Assertions.assertTrue((boolean)res.toExternalForm().endsWith("/"));
        }
        finally {
            IoUtils.recursiveDelete((Path)path);
        }
    }

    @Test
    public void testMemoryUrlConnections() throws Exception {
        long start = System.currentTimeMillis();
        Thread.sleep(2L);
        QuarkusClassLoader cl = QuarkusClassLoader.builder((String)"test", (ClassLoader)this.getClass().getClassLoader(), (boolean)false).addElement((ClassPathElement)new MemoryClassPathElement(Collections.singletonMap("a.txt", "hello".getBytes(StandardCharsets.UTF_8)), true)).build();
        URL res = cl.getResource("a.txt");
        Assertions.assertNotNull((Object)res);
        URLConnection urlConnection = res.openConnection();
        Assertions.assertEquals((int)5, (int)urlConnection.getContentLength());
        Assertions.assertTrue((urlConnection.getLastModified() > start ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"hello", (Object)new String(urlConnection.getInputStream().readAllBytes(), StandardCharsets.UTF_8));
    }

    public static Iterable<Object[]> paths() {
        if (OS.WINDOWS.isCurrentOs()) {
            return List.of(new Object[]{"test"});
        }
        return List.of(new Object[]{"test"}, new Object[]{"dir?with?question?mark"});
    }
}

