/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.TsDependency;
import io.quarkus.bootstrap.resolver.TsQuarkusExt;
import io.quarkus.bootstrap.resolver.TsRepoBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;

public class TsArtifact {
    public static final String DEFAULT_GROUP_ID = "io.quarkus.bootstrap.test";
    public static final String DEFAULT_VERSION = "1";
    public static final String TYPE_JAR = "jar";
    public static final String TYPE_POM = "pom";
    public static final String TYPE_TXT = "txt";
    public static final String EMPTY = "";
    private static final String MODEL_VERSION = "4.0.0";
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;
    protected final String version;
    private List<TsDependency> deps = Collections.emptyList();
    private List<TsQuarkusExt> extDeps = Collections.emptyList();
    private List<TsDependency> managedDeps = Collections.emptyList();
    protected ContentProvider content;
    protected Properties pomProps;
    protected List<Profile> pomProfiles = List.of();
    private boolean installed;

    public static TsArtifact ga(String artifactId) {
        return TsArtifact.ga(DEFAULT_GROUP_ID, artifactId);
    }

    public static TsArtifact ga(String groupId, String artifactId) {
        return new TsArtifact(groupId, artifactId, null);
    }

    public static TsArtifact jar(String artifactId) {
        return TsArtifact.jar(artifactId, DEFAULT_VERSION);
    }

    public static TsArtifact jar(String artifactId, String version) {
        return new TsArtifact(DEFAULT_GROUP_ID, artifactId, EMPTY, TYPE_JAR, version);
    }

    public static TsArtifact jar(String groupId, String artifactId, String version) {
        return new TsArtifact(groupId, artifactId, EMPTY, TYPE_JAR, version);
    }

    public static TsArtifact pom(String artifactId) {
        return new TsArtifact(DEFAULT_GROUP_ID, artifactId, EMPTY, TYPE_POM, DEFAULT_VERSION);
    }

    public static TsArtifact pom(String artifactId, String version) {
        return new TsArtifact(DEFAULT_GROUP_ID, artifactId, EMPTY, TYPE_POM, version);
    }

    public static TsArtifact pom(String groupId, String artifactId, String version) {
        return new TsArtifact(groupId, artifactId, EMPTY, TYPE_POM, version);
    }

    public TsArtifact(String artifactId) {
        this(artifactId, DEFAULT_VERSION);
    }

    public TsArtifact(String artifactId, String version) {
        this(DEFAULT_GROUP_ID, artifactId, EMPTY, TYPE_TXT, version);
    }

    public TsArtifact(String groupId, String artifactId, String version) {
        this(groupId, artifactId, EMPTY, TYPE_TXT, version);
    }

    public TsArtifact(String groupId, String artifactId, String classifier, String type, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.type = type;
        this.version = version;
    }

    public ArtifactKey getKey() {
        return new GACT(this.groupId, this.artifactId);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public TsArtifact setContent(ContentProvider content) {
        this.content = content;
        return this;
    }

    public TsArtifact addDependency(TsArtifact dep) {
        return this.addDependency(new TsDependency(dep));
    }

    public TsArtifact addDependency(TsArtifact dep, TsArtifact ... excludes) {
        return this.addDependency(new TsDependency(dep).exclude(excludes));
    }

    public TsArtifact addDependency(TsQuarkusExt dep) {
        return this.addDependency(dep, false);
    }

    public TsArtifact addDependency(TsQuarkusExt dep, String scope) {
        return this.addDependency(dep, scope, false);
    }

    public TsArtifact addDependency(TsQuarkusExt dep, boolean optional) {
        return this.addDependency(dep, () -> new TsDependency(dep.getRuntime(), optional));
    }

    public TsArtifact addDependency(TsQuarkusExt dep, String scope, boolean optional) {
        return this.addDependency(dep, () -> new TsDependency(dep.getRuntime(), scope, optional));
    }

    public TsArtifact addDependency(TsQuarkusExt dep, TsArtifact ... excludes) {
        return this.addDependency(dep, () -> new TsDependency(dep.getRuntime(), false).exclude(excludes));
    }

    private TsArtifact addDependency(TsQuarkusExt dep, Supplier<TsDependency> dependencyFactory) {
        if (this.extDeps.isEmpty()) {
            this.extDeps = new ArrayList<TsQuarkusExt>(1);
        }
        this.extDeps.add(dep);
        return this.addDependency(dependencyFactory.get());
    }

    public TsArtifact addDependency(TsDependency dep) {
        if (this.deps.isEmpty()) {
            this.deps = new ArrayList<TsDependency>();
        }
        this.deps.add(dep);
        return this;
    }

    public TsArtifact addManagedDependency(TsArtifact a) {
        return this.addManagedDependency(new TsDependency(a));
    }

    public TsArtifact addManagedDependency(TsDependency dep) {
        if (this.managedDeps.isEmpty()) {
            this.managedDeps = new ArrayList<TsDependency>();
        }
        this.managedDeps.add(dep);
        return this;
    }

    public TsArtifact addProfile(Profile profile) {
        if (this.pomProfiles.isEmpty()) {
            this.pomProfiles = new ArrayList<Profile>(1);
        }
        this.pomProfiles.add(profile);
        return this;
    }

    public String getArtifactFileName() {
        if (this.artifactId == null) {
            throw new IllegalArgumentException("artifactId is missing");
        }
        if (this.version == null) {
            throw new IllegalArgumentException("version is missing");
        }
        if (this.type == null) {
            throw new IllegalArgumentException("type is missing");
        }
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.artifactId).append('-').append(this.version);
        if (this.classifier != null && !this.classifier.isEmpty()) {
            fileName.append('-').append(this.classifier);
        }
        fileName.append('.').append(this.type);
        return fileName.toString();
    }

    public TsArtifact toPomArtifact() {
        return new TsArtifact(this.groupId, this.artifactId, EMPTY, TYPE_POM, this.version);
    }

    public Model getPomModel() {
        Model model = new Model();
        model.setModelVersion(MODEL_VERSION);
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setPackaging(this.type);
        model.setVersion(this.version);
        if (this.pomProps != null) {
            model.setProperties(this.pomProps);
        }
        if (!this.deps.isEmpty()) {
            for (TsDependency dep : this.deps) {
                model.addDependency(dep.toPomDependency());
            }
        }
        if (!this.managedDeps.isEmpty()) {
            DependencyManagement dm = new DependencyManagement();
            model.setDependencyManagement(dm);
            for (TsDependency dep : this.managedDeps) {
                dm.addDependency(dep.toPomDependency());
            }
        }
        if (!this.pomProfiles.isEmpty()) {
            model.setProfiles(this.pomProfiles);
        }
        return model;
    }

    public ArtifactCoords toArtifact() {
        return ArtifactCoords.of((String)this.groupId, (String)this.artifactId, (String)this.classifier, (String)this.type, (String)this.version);
    }

    public void install(TsRepoBuilder repoBuilder) {
        if (this.installed) {
            return;
        }
        this.installed = true;
        if (!this.extDeps.isEmpty()) {
            for (TsQuarkusExt ext : this.extDeps) {
                ext.install(repoBuilder);
            }
        }
        if (!this.deps.isEmpty()) {
            for (TsDependency dep : this.deps) {
                if (dep.artifact.getVersion() == null) continue;
                dep.artifact.install(repoBuilder);
            }
        }
        try {
            repoBuilder.install(this, this.content == null ? null : this.content.getPath(repoBuilder.workDir));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to install " + this, e);
        }
    }

    public void setPomProperty(String name, String value) {
        if (this.pomProps == null) {
            this.pomProps = new Properties();
        }
        this.pomProps.setProperty(name, value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.classifier).append(':').append(this.type).append(':').append(this.version);
        return buf.toString();
    }

    public static interface ContentProvider {
        public Path getPath(Path var1) throws IOException;
    }
}

