/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.IncubatingApplicationModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;

public class BootstrapAppModelFactory {
    private static final String QUARKUS = "quarkus";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String APP_MODEL_DAT = "app-model.dat";
    public static final String CREATOR_APP_GROUP_ID = "creator.app.groupId";
    public static final String CREATOR_APP_ARTIFACT_ID = "creator.app.artifactId";
    public static final String CREATOR_APP_CLASSIFIER = "creator.app.classifier";
    public static final String CREATOR_APP_TYPE = "creator.app.type";
    public static final String CREATOR_APP_VERSION = "creator.app.version";
    private static final Logger log = Logger.getLogger(BootstrapAppModelFactory.class);
    private ArtifactCoords managingProject;
    private Path projectRoot;
    private List<Path> appCp = new ArrayList<Path>(0);
    private Boolean localProjectsDiscovery;
    private Boolean offline;
    private boolean enableClasspathCache;
    private boolean test;
    private boolean devMode;
    private AppModelResolver bootstrapAppModelResolver;
    private ResolvedDependency appArtifact;
    private MavenArtifactResolver mavenArtifactResolver;
    private BootstrapMavenContext mvnContext;
    Set<ArtifactKey> reloadableModules = Set.of();
    private Collection<Dependency> forcedDependencies = List.of();

    public static BootstrapAppModelFactory newInstance() {
        return new BootstrapAppModelFactory();
    }

    private BootstrapAppModelFactory() {
    }

    public BootstrapAppModelFactory setTest(boolean test) {
        this.test = test;
        return this;
    }

    public BootstrapAppModelFactory setDevMode(boolean devMode) {
        this.devMode = devMode;
        return this;
    }

    public BootstrapAppModelFactory setLocalArtifacts(Set<ArtifactKey> localArtifacts) {
        this.reloadableModules = new HashSet<ArtifactKey>(localArtifacts);
        return this;
    }

    public BootstrapAppModelFactory setProjectRoot(Path projectRoot) {
        this.projectRoot = projectRoot;
        return this;
    }

    public BootstrapAppModelFactory addToClassPath(Path path) {
        this.appCp.add(path);
        return this;
    }

    public BootstrapAppModelFactory setLocalProjectsDiscovery(Boolean localProjectsDiscovery) {
        this.localProjectsDiscovery = localProjectsDiscovery;
        return this;
    }

    public BootstrapAppModelFactory setOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }

    public BootstrapAppModelFactory setEnableClasspathCache(boolean enable) {
        this.enableClasspathCache = enable;
        return this;
    }

    public BootstrapAppModelFactory setBootstrapAppModelResolver(AppModelResolver bootstrapAppModelResolver) {
        this.bootstrapAppModelResolver = bootstrapAppModelResolver;
        return this;
    }

    public BootstrapAppModelFactory setAppArtifact(ResolvedDependency appArtifact) {
        this.appArtifact = appArtifact;
        return this;
    }

    public BootstrapAppModelFactory setForcedDependencies(Collection<Dependency> forcedDependencies) {
        this.forcedDependencies = forcedDependencies;
        return this;
    }

    public AppModelResolver getAppModelResolver() {
        if (this.bootstrapAppModelResolver != null) {
            return this.bootstrapAppModelResolver;
        }
        try {
            if (this.projectRoot != null && !Files.isDirectory(this.projectRoot, new LinkOption[0])) {
                MavenArtifactResolver mvn;
                if (this.mavenArtifactResolver == null) {
                    BootstrapMavenContext mvnCtx = this.createBootstrapMavenContext();
                    if (this.managingProject == null) {
                        this.managingProject = mvnCtx.getCurrentProjectArtifact("pom");
                    }
                    mvn = new MavenArtifactResolver(mvnCtx);
                } else {
                    mvn = this.mavenArtifactResolver;
                }
                this.bootstrapAppModelResolver = this.initAppModelResolver(mvn);
                return this.bootstrapAppModelResolver;
            }
            MavenArtifactResolver mvn = this.mavenArtifactResolver;
            if (mvn == null) {
                mvn = new MavenArtifactResolver(this.createBootstrapMavenContext());
            }
            this.bootstrapAppModelResolver = this.initAppModelResolver(mvn);
            return this.bootstrapAppModelResolver;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create application model resolver for " + this.projectRoot, e);
        }
    }

    private BootstrapAppModelResolver initAppModelResolver(MavenArtifactResolver artifactResolver) {
        BootstrapAppModelResolver appModelResolver = new BootstrapAppModelResolver(artifactResolver).setTest(this.test).setDevMode(this.devMode);
        LocalProject project = artifactResolver.getMavenContext().getCurrentProject();
        if (project != null) {
            Properties modelProps = project.getModelBuildingResult() == null ? project.getRawModel().getProperties() : project.getModelBuildingResult().getEffectiveModel().getProperties();
            appModelResolver.setIncubatingModelResolver(IncubatingApplicationModelResolver.isIncubatingEnabled((Properties)modelProps) || this.devMode && !IncubatingApplicationModelResolver.isIncubatingModelResolverProperty((Properties)modelProps, (String)"false"));
        }
        return appModelResolver;
    }

    private BootstrapMavenContext createBootstrapMavenContext() throws AppModelResolverException {
        Path projectPom;
        if (this.mvnContext != null) {
            return this.mvnContext;
        }
        if (this.mavenArtifactResolver != null) {
            this.mvnContext = this.mavenArtifactResolver.getMavenContext();
            if (this.mvnContext != null) {
                return this.mvnContext;
            }
        }
        BootstrapMavenContextConfig config = BootstrapMavenContext.config();
        if (this.offline != null) {
            config.setOffline(this.offline.booleanValue());
        }
        if ((projectPom = config.getPomForDirOrNull(this.projectRoot)) != null) {
            config.setCurrentProject(projectPom.toString());
        }
        config.setWorkspaceDiscovery(this.isWorkspaceDiscoveryEnabled());
        this.mvnContext = new BootstrapMavenContext(config);
        return this.mvnContext;
    }

    public CurationResult resolveAppModel() throws BootstrapException {
        CurationResult result = this.loadFromSystemProperty();
        if (result != null) {
            return result;
        }
        result = this.createAppModelForJarOrNull(this.projectRoot);
        if (result != null) {
            return result;
        }
        return this.resolveAppModelForWorkspace();
    }

    private CurationResult resolveAppModelForWorkspace() throws BootstrapException {
        ResolvedDependency appArtifact = this.appArtifact;
        try {
            LocalProject localProject = null;
            if (appArtifact == null) {
                if (this.projectRoot == null) {
                    throw new IllegalArgumentException("Neither the application artifact nor the project root path has been provided");
                }
                LocalProject localProject2 = localProject = this.enableClasspathCache ? this.loadWorkspace() : LocalProject.load((Path)this.projectRoot, (boolean)false);
                if (localProject == null) {
                    log.warn((Object)"Unable to locate the maven project on the filesystem");
                    throw new BootstrapException("Failed to determine the Maven artifact associated with the application " + this.projectRoot);
                }
                appArtifact = localProject.getAppArtifact();
            }
            Path cachedCpPath = null;
            LocalWorkspace workspace = null;
            if (this.enableClasspathCache) {
                if (localProject == null) {
                    localProject = this.loadWorkspace();
                }
                workspace = localProject.getWorkspace();
                cachedCpPath = this.resolveCachedCpPath(localProject);
                if (Files.exists(cachedCpPath, new LinkOption[0]) && workspace.getLastModified() < Files.getLastModifiedTime(cachedCpPath, new LinkOption[0]).toMillis()) {
                    try {
                        ApplicationModel appModel = BootstrapUtils.readAppModelWithWorkspaceId((Path)cachedCpPath, (int)workspace.getId());
                        if (appModel != null) {
                            return new CurationResult(appModel);
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to read deployment classpath cache from " + cachedCpPath + " for " + appArtifact), (Throwable)e);
                    }
                }
            }
            CurationResult curationResult = new CurationResult(this.getAppModelResolver().resolveManagedModel((ArtifactCoords)appArtifact, this.forcedDependencies, this.managingProject, this.reloadableModules));
            if (cachedCpPath != null) {
                Files.createDirectories(cachedCpPath.getParent(), new FileAttribute[0]);
                try {
                    BootstrapUtils.writeAppModelWithWorkspaceId((ApplicationModel)curationResult.getApplicationModel(), (int)workspace.getId(), (Path)cachedCpPath);
                }
                catch (IOException e) {
                    log.warn((Object)"Failed to write classpath cache", (Throwable)e);
                }
            }
            return curationResult;
        }
        catch (Exception e) {
            throw new BootstrapException("Failed to create the application model for " + appArtifact, e);
        }
    }

    private CurationResult loadFromSystemProperty() {
        String serializedModel;
        String string = serializedModel = this.test ? System.getProperty("quarkus-internal-test.serialized-app-model.path") : System.getProperty("quarkus-internal.serialized-app-model.path");
        if (serializedModel != null) {
            Path p = Paths.get(serializedModel, new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                CurationResult curationResult;
                block11: {
                    InputStream existing = Files.newInputStream(p, new OpenOption[0]);
                    try {
                        curationResult = new CurationResult((ApplicationModel)new ObjectInputStream(existing).readObject());
                        if (existing == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (existing != null) {
                                try {
                                    existing.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException | ClassNotFoundException e) {
                            log.error((Object)"Failed to load serialized app mode", (Throwable)e);
                            IoUtils.recursiveDelete((Path)p);
                        }
                    }
                    existing.close();
                }
                return curationResult;
            } else {
                log.error((Object)("Failed to locate serialized application model at " + serializedModel));
            }
        }
        return null;
    }

    private boolean isWorkspaceDiscoveryEnabled() {
        return this.localProjectsDiscovery == null ? this.projectRoot != null && (this.test || this.devMode) : this.localProjectsDiscovery;
    }

    private LocalProject loadWorkspace() throws AppModelResolverException {
        if (this.projectRoot == null || !Files.isDirectory(this.projectRoot, new LinkOption[0])) {
            return null;
        }
        LocalProject project = this.createBootstrapMavenContext().getCurrentProject();
        if (project == null) {
            return null;
        }
        if (project.getDir().equals(this.projectRoot)) {
            return project;
        }
        for (LocalProject p : project.getWorkspace().getProjects().values()) {
            if (!p.getDir().equals(this.projectRoot)) continue;
            return p;
        }
        log.warnf("Expected project directory %s does not match current project directory %s", (Object)this.projectRoot, (Object)project.getDir());
        return project;
    }

    private CurationResult createAppModelForJarOrNull(Path appArtifactPath) {
        if (this.projectRoot != null && (!Files.isDirectory(this.projectRoot, new LinkOption[0]) || this.projectRoot.getFileSystem().getClass().getName().contains("Zip"))) {
            ApplicationModel appModel;
            AppModelResolver modelResolver = this.getAppModelResolver();
            ResolvedDependency appArtifact = this.appArtifact;
            try {
                if (appArtifact == null) {
                    appArtifact = ModelUtils.resolveAppArtifact((Path)appArtifactPath);
                }
                modelResolver.relink((ArtifactCoords)appArtifact, appArtifactPath);
                appModel = modelResolver.resolveManagedModel((ArtifactCoords)appArtifact, List.of(), this.managingProject, this.reloadableModules);
            }
            catch (AppModelResolverException | IOException e) {
                throw new RuntimeException("Failed to resolve initial application dependencies", e);
            }
            return new CurationResult(appModel);
        }
        return null;
    }

    private Path resolveCachedCpPath(LocalProject project) {
        if (this.devMode) {
            return BootstrapUtils.resolveSerializedAppModelPath((Path)project.getOutputDir());
        }
        if (this.test) {
            return BootstrapUtils.getSerializedTestAppModelPath((Path)project.getOutputDir());
        }
        return project.getOutputDir().resolve(QUARKUS).resolve(BOOTSTRAP).resolve(APP_MODEL_DAT);
    }

    public BootstrapAppModelFactory setMavenArtifactResolver(MavenArtifactResolver mavenArtifactResolver) {
        this.mavenArtifactResolver = mavenArtifactResolver;
        return this;
    }

    public BootstrapAppModelFactory setManagingProject(ArtifactCoords managingProject) {
        this.managingProject = managingProject;
        return this;
    }
}

