/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloader;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.util.IoUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class MultiReleaseJarTestCase {
    Path jarPath;

    @BeforeEach
    void setUp(@TempDir Path tempDirectory) throws IOException {
        this.jarPath = tempDirectory.resolve("test.jar");
        try (OutputStream out = Files.newOutputStream(this.jarPath, new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(out);){
            JarEntry entry = new JarEntry("META-INF/MANIFEST.MF");
            jos.putNextEntry(entry);
            jos.write("Multi-Release: true\n".getBytes());
            jos.closeEntry();
            entry = new JarEntry("foo.txt");
            jos.putNextEntry(entry);
            jos.write("Original".getBytes());
            jos.closeEntry();
            entry = new JarEntry("META-INF/versions/9/foo.txt");
            jos.putNextEntry(entry);
            jos.write("MultiRelease".getBytes());
            jos.closeEntry();
        }
    }

    @Test
    public void shouldLoadMultiReleaseJarOnJDK9Plus() throws IOException {
        try (QuarkusClassLoader cl = QuarkusClassLoader.builder((String)"test", (ClassLoader)this.getClass().getClassLoader(), (boolean)false).addNormalPriorityElement(ClassPathElement.fromPath((Path)this.jarPath, (boolean)true)).build();){
            URL resource = cl.getResource("foo.txt");
            Assertions.assertNotNull((Object)resource, (String)"foo.txt was not found in generated JAR");
            Assertions.assertTrue((boolean)resource.toString().contains("META-INF/versions/9"));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream is = cl.getResourceAsStream("foo.txt");){
                IoUtils.copy((OutputStream)baos, (InputStream)is);
            }
            Assertions.assertEquals((Object)"MultiRelease", (Object)baos.toString());
        }
    }
}

