/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.ResolverSetupCleanup;
import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.TsDependency;
import io.quarkus.bootstrap.resolver.TsQuarkusExt;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class CollectDependenciesBase
extends ResolverSetupCleanup {
    protected TsArtifact root;
    protected List<Dependency> expectedResult = List.of();
    protected List<Dependency> deploymentDeps = List.of();

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.root = new TsArtifact("root");
        this.setupDependencies();
    }

    protected abstract void setupDependencies() throws Exception;

    @Test
    public void testCollectedDependencies() throws Exception {
        List<Dependency> expected;
        this.install(this.root);
        if (this.deploymentDeps.isEmpty()) {
            expected = this.expectedResult;
        } else {
            expected = new ArrayList<Dependency>(this.expectedResult.size() + this.deploymentDeps.size());
            expected.addAll(this.expectedResult);
            expected.addAll(this.deploymentDeps);
        }
        Collection buildDeps = this.getTestResolver().resolveModel(this.root.toArtifact()).getDependencies();
        Assertions.assertThat(CollectDependenciesBase.stripResolvedPaths(buildDeps)).containsExactlyInAnyOrderElementsOf(expected);
        this.assertBuildDependencies(buildDeps);
    }

    protected void assertBuildDependencies(Collection<ResolvedDependency> buildDeps) {
    }

    private static List<Dependency> stripResolvedPaths(Collection<ResolvedDependency> deps) {
        ArrayList<Dependency> result = new ArrayList<Dependency>(deps.size());
        for (ResolvedDependency dep : deps) {
            result.add((Dependency)new ArtifactDependency((Dependency)dep));
        }
        return result;
    }

    protected BootstrapAppModelResolver getTestResolver() throws Exception {
        return this.resolver;
    }

    protected Path getInstallDir(TsArtifact artifact) {
        return this.getInstallDir().resolve(artifact.getGroupId().replace('.', '/')).resolve(artifact.getArtifactId()).resolve(artifact.getVersion());
    }

    protected TsArtifact install(TsArtifact dep, boolean collected) {
        return this.install(dep, collected ? "compile" : null);
    }

    protected TsArtifact install(TsArtifact dep, String collectedInScope) {
        return this.install(dep, null, collectedInScope, false);
    }

    protected TsArtifact install(TsArtifact dep, String collectedInScope, boolean optional) {
        return this.install(dep, null, collectedInScope, optional);
    }

    protected TsArtifact install(TsArtifact dep, Path p, boolean collected) {
        return this.install(dep, p, collected ? "compile" : null, false);
    }

    protected TsArtifact install(TsArtifact dep, Path p, String collectedInScope, boolean optional) {
        this.install(dep, p);
        if (collectedInScope != null) {
            this.addCollectedDep(dep, collectedInScope, optional, new int[0]);
        }
        return dep;
    }

    @Override
    protected TsQuarkusExt install(TsQuarkusExt ext) {
        this.install(ext, true);
        return ext;
    }

    protected void install(TsQuarkusExt ext, boolean collected) {
        ext.install(this.repo);
        if (collected) {
            this.addCollectedDep(ext.getRuntime(), "compile", false, 16);
            this.addCollectedDeploymentDep(ext.getDeployment());
        }
    }

    protected void installAsDep(TsQuarkusExt ext) {
        ext.install(this.repo);
        this.root.addDependency(ext);
        this.addCollectedDep(ext.getRuntime(), "compile", false, 146);
        this.addCollectedDeploymentDep(ext.getDeployment());
    }

    protected void installAsDep(TsArtifact dep, int ... flags) {
        this.installAsDep(dep, true, flags);
    }

    protected void installAsDep(TsArtifact dep, boolean collected, int ... flags) {
        this.installAsDep(dep, null, collected, flags);
    }

    protected void installAsDep(TsArtifact dep, Path p, boolean collected, int ... flags) {
        this.installAsDep(new TsDependency(dep), p, collected, flags);
    }

    protected void installAsDep(TsDependency dep) {
        this.installAsDep(dep, null);
    }

    protected void installAsDep(TsDependency dep, Path p) {
        this.installAsDep(dep, p, true, new int[0]);
    }

    protected void installAsDep(TsDependency dep, boolean collected) {
        this.installAsDep(dep, null, collected, new int[0]);
    }

    protected void installAsDep(TsDependency dep, Path p, boolean collected, int ... flags) {
        TsArtifact artifact = dep.artifact;
        this.install(artifact, p);
        this.root.addDependency(dep);
        if (!collected) {
            return;
        }
        int allFlags = 2;
        for (int f : flags) {
            allFlags |= f;
        }
        this.addCollectedDep(artifact, dep.scope == null ? "compile" : dep.scope, dep.optional, allFlags);
    }

    protected void addCollectedDep(TsArtifact artifact, int ... flags) {
        this.addCollectedDep(artifact, "compile", false, flags);
    }

    protected void addCollectedDep(TsArtifact artifact, String scope, boolean optional, int ... flags) {
        int allFlags = 12;
        if (optional) {
            allFlags |= 1;
        }
        for (int f : flags) {
            allFlags |= f;
        }
        if (this.expectedResult.isEmpty()) {
            this.expectedResult = new ArrayList<Dependency>();
        }
        this.expectedResult.add((Dependency)new ArtifactDependency(artifact.toArtifact(), scope, new int[]{allFlags}));
    }

    protected void addCollectedDeploymentDep(TsArtifact ext) {
        if (this.deploymentDeps.isEmpty()) {
            this.deploymentDeps = new ArrayList<Dependency>();
        }
        this.deploymentDeps.add((Dependency)new ArtifactDependency(ext.toArtifact(), "compile", new int[]{8}));
    }

    protected void addManagedDep(TsQuarkusExt ext) {
        this.addManagedDep(ext.runtime);
        this.addManagedDep(ext.deployment);
    }

    protected void addManagedDep(TsArtifact dep) {
        this.root.addManagedDependency(new TsDependency(dep));
    }

    protected void addDep(TsArtifact dep) {
        this.root.addDependency(dep);
    }

    protected void setPomProperty(String name, String value) {
        this.root.setPomProperty(name, value);
    }
}

