/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.test;

import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.CollectDependenciesBase;
import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.TsQuarkusExt;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.Collection;
import org.assertj.core.api.Assertions;

public class ConditionalDependenciesDevModelTestCase
extends CollectDependenciesBase {
    @Override
    protected QuarkusBootstrap.Mode getBootstrapMode() {
        return QuarkusBootstrap.Mode.DEV;
    }

    @Override
    protected void setupDependencies() {
        TsArtifact excludedLib = TsArtifact.jar("excluded-lib");
        this.install(excludedLib, false);
        TsQuarkusExt extA = new TsQuarkusExt("ext-a");
        extA.getRuntime().addDependency(excludedLib);
        this.install(extA, false);
        this.addCollectedDeploymentDep(extA.getDeployment());
        this.installAsDep(extA.getRuntime(), 146);
        TsQuarkusExt extB = new TsQuarkusExt("ext-b");
        extB.setDescriptorProp("excluded-artifacts", "io.quarkus.bootstrap.test:excluded-lib");
        this.install(extB, false);
        this.addCollectedDep(extB.getRuntime(), 16);
        this.addCollectedDeploymentDep(extB.getDeployment());
        TsQuarkusExt extC = new TsQuarkusExt("ext-c");
        extC.setDependencyCondition(extB);
        this.install(extC, false);
        this.addCollectedDep(extC.getRuntime(), 16);
        this.addCollectedDeploymentDep(extC.getDeployment());
        TsQuarkusExt extD = new TsQuarkusExt("ext-d");
        this.install(extD, false);
        this.installAsDep(extD.getRuntime(), 146);
        this.addCollectedDeploymentDep(extD.getDeployment());
        TsArtifact libE = TsArtifact.jar("lib-e");
        this.install(libE, true);
        TsArtifact libEBuildTIme = TsArtifact.jar("lib-e-build-time");
        this.install(libEBuildTIme);
        this.addCollectedDeploymentDep(libEBuildTIme);
        TsQuarkusExt extE = new TsQuarkusExt("ext-e");
        extE.setDependencyCondition(extD);
        extE.getRuntime().addDependency(libE);
        extE.getDeployment().addDependency(libEBuildTIme);
        this.install(extE, false);
        this.addCollectedDep(extE.getRuntime(), 16);
        this.addCollectedDeploymentDep(extE.getDeployment());
        TsQuarkusExt extF = new TsQuarkusExt("ext-f");
        extF.setConditionalDeps(extC, extE);
        this.install(extF, false);
        this.installAsDep(extF.getRuntime(), 146);
        this.addCollectedDeploymentDep(extF.getDeployment());
        TsQuarkusExt extH = new TsQuarkusExt("ext-h");
        this.install(extH, false);
        this.addCollectedDep(extH.getRuntime(), 28);
        this.addCollectedDeploymentDep(extH.getDeployment());
        TsArtifact devOnlyLib = TsArtifact.jar("dev-only-lib");
        devOnlyLib.addDependency(extH);
        this.install(devOnlyLib, false);
        this.addCollectedDep(devOnlyLib, 12);
        TsQuarkusExt extG = new TsQuarkusExt("ext-g");
        extG.setConditionalDevDeps(extB.getRuntime(), devOnlyLib);
        this.install(extG, false);
        this.installAsDep(extG.getRuntime(), 146);
        this.addCollectedDeploymentDep(extG.getDeployment());
    }

    @Override
    protected void assertBuildDependencies(Collection<ResolvedDependency> buildDeps) {
        if (BootstrapAppModelResolver.isLegacyModelResolver(null)) {
            return;
        }
        block32: for (ResolvedDependency d : buildDeps) {
            switch (d.getArtifactId()) {
                case "ext-a": 
                case "ext-b": 
                case "ext-c": 
                case "ext-d": 
                case "ext-h": 
                case "lib-e": 
                case "lib-e-build-time": {
                    Assertions.assertThat((Collection)d.getDependencies()).isEmpty();
                    continue block32;
                }
                case "ext-a-deployment": 
                case "ext-b-deployment": 
                case "ext-c-deployment": 
                case "ext-d-deployment": 
                case "ext-h-deployment": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)d.getArtifactId().substring(0, d.getArtifactId().length() - "-deployment".length()), (String)"1")});
                    continue block32;
                }
                case "ext-e": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"lib-e", (String)"1")});
                    continue block32;
                }
                case "ext-e-deployment": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-e", (String)"1"), ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"lib-e-build-time", (String)"1")});
                    continue block32;
                }
                case "ext-f": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-c", (String)"1"), ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-e", (String)"1")});
                    continue block32;
                }
                case "ext-f-deployment": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-f", (String)"1"), ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-c-deployment", (String)"1"), ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-e-deployment", (String)"1")});
                    continue block32;
                }
                case "ext-g": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-b", (String)"1"), ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"dev-only-lib", (String)"1")});
                    continue block32;
                }
                case "ext-g-deployment": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-g", (String)"1"), ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-b-deployment", (String)"1")});
                    continue block32;
                }
                case "dev-only-lib": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-h", (String)"1")});
                    continue block32;
                }
            }
            throw new RuntimeException("unexpected dependency " + d.toCompactCoords());
        }
    }
}

