/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.test;

import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.CollectDependenciesBase;
import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.TsQuarkusExt;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;

public class ConditionalDependenciesRuntimeOnlyProdModelTestCase
extends CollectDependenciesBase {
    private static final boolean runtimeOnly = true;

    @Override
    protected BootstrapAppModelResolver newAppModelResolver(LocalProject currentProject) throws Exception {
        BootstrapAppModelResolver resolver = super.newAppModelResolver(currentProject);
        resolver.setRuntimeModelOnly(true);
        return resolver;
    }

    @Override
    protected void setupDependencies() {
        TsQuarkusExt extA = new TsQuarkusExt("ext-a");
        this.install(extA, false);
        this.installAsDep(extA.getRuntime(), 146);
        TsQuarkusExt extB = new TsQuarkusExt("ext-b");
        this.install(extB, false);
        TsQuarkusExt extC = new TsQuarkusExt("ext-c");
        extC.setDependencyCondition(extB);
        this.install(extC, false);
        TsQuarkusExt extD = new TsQuarkusExt("ext-d");
        this.install(extD, false);
        this.installAsDep(extD.getRuntime(), 146);
        TsArtifact libE = TsArtifact.jar("lib-e");
        this.install(libE, true);
        TsArtifact libEBuildTIme = TsArtifact.jar("lib-e-build-time");
        this.install(libEBuildTIme);
        TsQuarkusExt extE = new TsQuarkusExt("ext-e");
        extE.setDependencyCondition(extD);
        extE.getRuntime().addDependency(libE);
        extE.getDeployment().addDependency(libEBuildTIme);
        this.install(extE, false);
        this.addCollectedDep(extE.getRuntime(), 16);
        TsQuarkusExt extF = new TsQuarkusExt("ext-f");
        extF.setConditionalDeps(extC, extE);
        this.install(extF, false);
        this.installAsDep(extF.getRuntime(), 146);
    }
}

