/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.test;

import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.CollectDependenciesBase;
import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.TsQuarkusExt;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.Collection;
import org.assertj.core.api.Assertions;

public class DevUiStyleConditionalDevModeDependenciesTestCase
extends CollectDependenciesBase {
    @Override
    protected QuarkusBootstrap.Mode getBootstrapMode() {
        return QuarkusBootstrap.Mode.DEV;
    }

    @Override
    protected void setupDependencies() {
        TsArtifact extLibDev = TsArtifact.jar("ext-lib-dev");
        TsQuarkusExt extA = new TsQuarkusExt("ext-a");
        extA.setConditionalDevDeps(extLibDev);
        extLibDev.addDependency(extA.getRuntime());
        this.install(extA, false);
        this.installAsDep(extA.getRuntime(), 146);
        this.install(extLibDev, true);
        this.addCollectedDeploymentDep(extA.getDeployment());
    }

    @Override
    protected void assertBuildDependencies(Collection<ResolvedDependency> buildDeps) {
        if (BootstrapAppModelResolver.isLegacyModelResolver(null)) {
            return;
        }
        block10: for (ResolvedDependency d : buildDeps) {
            switch (d.getArtifactId()) {
                case "ext-a": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-lib-dev", (String)"1")});
                    continue block10;
                }
                case "ext-a-deployment": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)d.getArtifactId().substring(0, d.getArtifactId().length() - "-deployment".length()), (String)"1")});
                    continue block10;
                }
                case "ext-lib-dev": {
                    Assertions.assertThat((Collection)d.getDependencies()).containsExactlyInAnyOrder((Object[])new ArtifactCoords[]{ArtifactCoords.jar((String)"io.quarkus.bootstrap.test", (String)"ext-a", (String)"1")});
                    continue block10;
                }
            }
            throw new RuntimeException("unexpected dependency " + d.toCompactCoords());
        }
    }
}

