/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloader;

import io.quarkus.bootstrap.classloader.ClassToLoad;
import io.quarkus.bootstrap.classloader.InterruptClass;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.DirectoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.util.IoUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassLoadingInterruptTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassLoaderWhenThreadInterrupted() throws Exception {
        JavaArchive jar = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ClassToLoad.class, InterruptClass.class});
        Path path = Files.createTempDirectory("test", new FileAttribute[0]);
        try {
            ((ExplodedExporter)jar.as(ExplodedExporter.class)).exportExploded(path.toFile(), "tmp");
            QuarkusClassLoader cl = QuarkusClassLoader.builder((String)"test", (ClassLoader)this.getClass().getClassLoader(), (boolean)false).addElement((ClassPathElement)new DirectoryClassPathElement(path.resolve("tmp"), true)).build();
            Class<?> c = cl.loadClass(InterruptClass.class.getName());
            Assertions.assertNotEquals(c, InterruptClass.class);
            Runnable runnable = (Runnable)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            runnable.run();
        }
        finally {
            IoUtils.recursiveDelete((Path)path);
        }
    }
}

