/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.paths.OpenPathTree;
import java.io.IOException;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.Manifest;

public class FilteredClassPathElement
implements ClassPathElement {
    final ClassPathElement delegate;
    final Set<String> removed;

    public FilteredClassPathElement(ClassPathElement delegate, Collection<String> removed) {
        this.delegate = delegate;
        this.removed = new HashSet<String>(removed);
    }

    @Override
    public ArtifactKey getDependencyKey() {
        return this.delegate.getDependencyKey();
    }

    @Override
    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    @Override
    public <T> T apply(Function<OpenPathTree, T> func) {
        return this.delegate.apply(func);
    }

    @Override
    public Path getRoot() {
        return this.delegate.getRoot();
    }

    @Override
    public ClassPathResource getResource(String name) {
        if (this.removed.contains(name)) {
            return null;
        }
        return this.delegate.getResource(name);
    }

    @Override
    public Set<String> getProvidedResources() {
        HashSet<String> ret = new HashSet<String>(this.delegate.getProvidedResources());
        ret.removeAll(this.removed);
        return ret;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return this.delegate.getProtectionDomain();
    }

    @Override
    public Manifest getManifest() {
        return this.delegate.getManifest();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

