/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import io.quarkus.bootstrap.BootstrapGradleException;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.model.ArtifactCoords;
import io.quarkus.bootstrap.resolver.model.Dependency;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.resolver.model.WorkspaceModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.gradle.api.GradleException;

public class QuarkusModelHelper {
    public static final String SERIALIZED_QUARKUS_MODEL = "quarkus-internal.serialized-quarkus-model.path";
    public static final String[] DEVMODE_REQUIRED_TASKS = new String[]{"classes"};
    public static final String[] TEST_REQUIRED_TASKS = new String[]{"classes", "testClasses"};

    private QuarkusModelHelper() {
    }

    public static void exportModel(QuarkusModel model) throws AppModelResolverException, IOException {
        Path serializedModel = QuarkusModelHelper.serializeAppModel(model);
        System.setProperty("quarkus-internal.serialized-app-model.path", serializedModel.toString());
    }

    public static Path serializeAppModel(QuarkusModel model) throws AppModelResolverException, IOException {
        Path serializedModel = File.createTempFile("quarkus-app-model", ".dat").toPath();
        ArtifactCoords artifactCoords = model.getWorkspace().getMainModule().getArtifactCoords();
        AppArtifact appArtifact = new AppArtifact(artifactCoords.getGroupId(), artifactCoords.getArtifactId(), artifactCoords.getVersion());
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(QuarkusModelHelper.convert(model, appArtifact));
        }
        return serializedModel;
    }

    public static Path serializeQuarkusModel(QuarkusModel model) throws IOException {
        Path serializedModel = File.createTempFile("quarkus-model", ".dat").toPath();
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(serializedModel, new OpenOption[0]));){
            out.writeObject(model);
        }
        return serializedModel;
    }

    /*
     * Exception decompiling
     */
    public static QuarkusModel deserializeQuarkusModel(Path modelPath) throws BootstrapGradleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path getClassPath(WorkspaceModule model) throws BootstrapGradleException {
        Optional<Path> classDir = model.getSourceSet().getSourceDirectories().stream().filter(File::exists).map(File::toPath).findFirst();
        if (!classDir.isPresent()) {
            throw new BootstrapGradleException("Failed to locate class directory");
        }
        return classDir.get();
    }

    public static AppModel convert(QuarkusModel model, AppArtifact appArtifact) throws AppModelResolverException {
        AppModel.Builder appBuilder = new AppModel.Builder();
        ArrayList userDeps = new ArrayList();
        HashMap<AppArtifactKey, AppDependency> versionMap = new HashMap<AppArtifactKey, AppDependency>();
        model.getAppDependencies().stream().map(QuarkusModelHelper::toAppDependency).forEach(appDependency -> {
            userDeps.add(appDependency);
            versionMap.put(appDependency.getArtifact().getKey(), (AppDependency)appDependency);
        });
        ArrayList<AppDependency> deploymentDeps = new ArrayList<AppDependency>();
        for (Dependency extensionDependency : model.getExtensionDependencies()) {
            AppDependency appDep = QuarkusModelHelper.toAppDependency(extensionDependency);
            for (Path artifactPath : appDep.getArtifact().getPaths()) {
                if (!Files.exists(artifactPath, new LinkOption[0]) || !extensionDependency.getType().equals("jar")) continue;
                if (Files.isDirectory(artifactPath, new LinkOption[0])) {
                    QuarkusModelHelper.processQuarkusDir(appDep.getArtifact(), artifactPath.resolve("META-INF"), appBuilder);
                    continue;
                }
                try {
                    FileSystem artifactFs = FileSystems.newFileSystem(artifactPath, QuarkusModelHelper.class.getClassLoader());
                    Throwable throwable = null;
                    try {
                        QuarkusModelHelper.processQuarkusDir(appDep.getArtifact(), artifactFs.getPath("META-INF", new String[0]), appBuilder);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (artifactFs == null) continue;
                        if (throwable != null) {
                            try {
                                artifactFs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        artifactFs.close();
                    }
                }
                catch (IOException e) {
                    throw new AppModelResolverException("Failed to process " + artifactPath, (Throwable)e);
                }
            }
            if (userDeps.contains(appDep)) continue;
            AppDependency deploymentDep = QuarkusModelHelper.alignVersion(appDep, versionMap);
            deploymentDeps.add(deploymentDep);
        }
        ArrayList<AppDependency> fullDeploymentDeps = new ArrayList<AppDependency>(userDeps);
        fullDeploymentDeps.addAll(deploymentDeps);
        if (!appArtifact.isResolved()) {
            PathsCollection.Builder paths = PathsCollection.builder();
            WorkspaceModule module = model.getWorkspace().getMainModule();
            module.getSourceSet().getSourceDirectories().stream().filter(File::exists).map(File::toPath).forEach(arg_0 -> ((PathsCollection.Builder)paths).add(arg_0));
            if (module.getSourceSet().getResourceDirectory().exists()) {
                paths.add(module.getSourceSet().getResourceDirectory().toPath());
            }
            appArtifact.setPaths(paths.build());
        }
        appBuilder.addRuntimeDeps(userDeps).addFullDeploymentDeps(fullDeploymentDeps).addDeploymentDeps(deploymentDeps).setAppArtifact(appArtifact);
        return appBuilder.build();
    }

    public static AppDependency toAppDependency(Dependency dependency) {
        AppArtifact artifact = new AppArtifact(dependency.getGroupId(), dependency.getName(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
        artifact.setPaths(QuarkusModelHelper.toPathsCollection(dependency.getPaths()));
        return new AppDependency(artifact, "runtime");
    }

    public static PathsCollection toPathsCollection(Collection<File> files) {
        PathsCollection.Builder paths = PathsCollection.builder();
        for (File f : files) {
            paths.add(f.toPath());
        }
        return paths.build();
    }

    public static Properties resolveDescriptor(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        catch (IOException e) {
            throw new GradleException("Failed to load extension description " + path, e);
        }
        return rtProps;
    }

    private static void processQuarkusDir(AppArtifact a, Path quarkusDir, AppModel.Builder appBuilder) {
        if (!Files.exists(quarkusDir, new LinkOption[0])) {
            return;
        }
        Path quarkusDescr = quarkusDir.resolve("quarkus-extension.properties");
        if (!Files.exists(quarkusDescr, new LinkOption[0])) {
            return;
        }
        Properties extProps = QuarkusModelHelper.resolveDescriptor(quarkusDescr);
        if (extProps == null) {
            return;
        }
        appBuilder.handleExtensionProperties(extProps, a.toString());
    }

    static AppDependency alignVersion(AppDependency dependency, Map<AppArtifactKey, AppDependency> versionMap) {
        AppArtifactKey appKey = new AppArtifactKey(dependency.getArtifact().getGroupId(), dependency.getArtifact().getArtifactId());
        if (versionMap.containsKey(appKey)) {
            return versionMap.get(appKey);
        }
        return dependency;
    }
}

