/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.ManagedExecutorImpl;
import org.gradle.internal.concurrent.ManagedScheduledExecutor;
import org.gradle.internal.concurrent.ManagedScheduledExecutorImpl;
import org.gradle.internal.concurrent.ManagedThreadPoolExecutor;
import org.gradle.internal.concurrent.ManagedThreadPoolExecutorImpl;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.ThreadFactoryImpl;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class DefaultExecutorFactory
implements ExecutorFactory,
Stoppable {
    private final Set<ManagedExecutor> executors = new CopyOnWriteArraySet<ManagedExecutor>();
    @Nullable
    private final ClassLoader threadFactoryContextClassloader;

    public DefaultExecutorFactory() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public DefaultExecutorFactory(@Nullable ClassLoader threadFactoryContextClassloader) {
        this.threadFactoryContextClassloader = threadFactoryContextClassloader;
    }

    @Override
    public void stop() {
        try {
            CompositeStoppable.stoppable(this.executors).stop();
        }
        finally {
            this.executors.clear();
        }
    }

    @Override
    public ManagedExecutor create(String displayName) {
        TrackedManagedExecutor executor = new TrackedManagedExecutor(this.createExecutor(displayName), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    protected ExecutorService createExecutor(String displayName) {
        return Executors.newCachedThreadPool(this.newThreadFactory(displayName));
    }

    @Override
    public ManagedExecutor create(String displayName, int fixedSize) {
        TrackedManagedExecutor executor = new TrackedManagedExecutor(this.createExecutor(displayName, fixedSize), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    @Override
    public ManagedThreadPoolExecutor createThreadPool(String displayName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit) {
        ThreadPoolExecutor executorService = DefaultExecutorFactory.createThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, this.newThreadFactory(displayName));
        TrackedThreadPoolManagedExecutor executor = new TrackedThreadPoolManagedExecutor(executorService, new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    private static ThreadPoolExecutor createThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    protected ExecutorService createExecutor(String displayName, int fixedSize) {
        return Executors.newFixedThreadPool(fixedSize, this.newThreadFactory(displayName));
    }

    @Override
    public ManagedScheduledExecutor createScheduled(String displayName, int fixedSize) {
        TrackedScheduledManagedExecutor executor = new TrackedScheduledManagedExecutor(this.createScheduledExecutor(displayName, fixedSize), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    private ScheduledExecutorService createScheduledExecutor(String displayName, int fixedSize) {
        return new ScheduledThreadPoolExecutor(fixedSize, this.newThreadFactory(displayName));
    }

    private ThreadFactory newThreadFactory(String displayName) {
        return new ThreadFactoryImpl(displayName, this.threadFactoryContextClassloader);
    }

    private class TrackedThreadPoolManagedExecutor
    extends ManagedThreadPoolExecutorImpl {
        public TrackedThreadPoolManagedExecutor(ThreadPoolExecutor delegate, ExecutorPolicy executorPolicy) {
            super(delegate, executorPolicy);
        }

        @Override
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            try {
                super.stop(timeoutValue, timeoutUnits);
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }

    private class TrackedScheduledManagedExecutor
    extends ManagedScheduledExecutorImpl {
        TrackedScheduledManagedExecutor(ScheduledExecutorService executor, ExecutorPolicy executorPolicy) {
            super(executor, executorPolicy);
        }

        @Override
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            try {
                super.stop(timeoutValue, timeoutUnits);
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }

    private class TrackedManagedExecutor
    extends ManagedExecutorImpl {
        TrackedManagedExecutor(ExecutorService executor, ExecutorPolicy executorPolicy) {
            super(executor, executorPolicy);
        }

        @Override
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            try {
                super.stop(timeoutValue, timeoutUnits);
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }
}

