/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.gradle.api.specs.Spec;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class TransformedClassPath
implements ClassPath {
    public static final String INSTRUMENTED_MARKER_FILE_NAME = ".gradle-instrumented.marker";
    public static final String INSTRUMENTED_JAR_DIR_NAME = "instrumented";
    public static final String ORIGINAL_JAR_DIR_NAME = "original";
    private final ClassPath originalClassPath;
    private final ImmutableMap<File, File> transforms;

    private TransformedClassPath(ClassPath originalClassPath, Map<File, File> transforms) {
        assert (!(originalClassPath instanceof TransformedClassPath));
        this.originalClassPath = originalClassPath;
        this.transforms = ImmutableMap.copyOf(transforms);
    }

    @Override
    public boolean isEmpty() {
        return this.originalClassPath.isEmpty();
    }

    @Override
    public List<URI> getAsURIs() {
        return this.originalClassPath.getAsURIs();
    }

    @Override
    public List<File> getAsFiles() {
        return this.originalClassPath.getAsFiles();
    }

    public List<File> getAsTransformedFiles() {
        ArrayList<File> originals = new ArrayList<File>(this.originalClassPath.getAsFiles());
        ListIterator<File> iter = originals.listIterator();
        while (iter.hasNext()) {
            File original = (File)iter.next();
            iter.set(this.transforms.getOrDefault(original, original));
        }
        return originals;
    }

    @Override
    public List<URL> getAsURLs() {
        return this.originalClassPath.getAsURLs();
    }

    @Override
    public URL[] getAsURLArray() {
        return this.originalClassPath.getAsURLArray();
    }

    TransformedClassPath prepend(DefaultClassPath classPath) {
        return new TransformedClassPath(classPath, ImmutableMap.<File, File>of()).plusWithTransforms(this);
    }

    private TransformedClassPath plusWithTransforms(TransformedClassPath classPath) {
        ClassPath mergedOriginals = this.originalClassPath.plus(classPath.originalClassPath);
        ImmutableMap.Builder<File, File> mergedTransforms = ImmutableMap.builderWithExpectedSize(this.transforms.size() + classPath.transforms.size());
        ImmutableSet<File> thisClassPathFiles = ImmutableSet.copyOf(this.originalClassPath.getAsFiles());
        mergedTransforms.putAll(this.transforms);
        for (Map.Entry appendedTransform : classPath.transforms.entrySet()) {
            if (thisClassPathFiles.contains(appendedTransform.getKey())) continue;
            mergedTransforms.put(appendedTransform);
        }
        return new TransformedClassPath(mergedOriginals, mergedTransforms.buildOrThrow());
    }

    @Override
    public TransformedClassPath plus(Collection<File> classPath) {
        return new TransformedClassPath(this.originalClassPath.plus(classPath), this.transforms);
    }

    @Override
    public TransformedClassPath plus(ClassPath classPath) {
        if (classPath instanceof TransformedClassPath) {
            return this.plusWithTransforms((TransformedClassPath)classPath);
        }
        return new TransformedClassPath(this.originalClassPath.plus(classPath), this.transforms);
    }

    @Override
    public TransformedClassPath removeIf(Spec<? super File> filter) {
        ClassPath filteredClassPath = this.originalClassPath.removeIf(filter);
        ImmutableSet<File> remainingOriginals = ImmutableSet.copyOf(filteredClassPath.getAsFiles());
        ImmutableMap.Builder remainingTransforms = ImmutableMap.builderWithExpectedSize(Math.min(remainingOriginals.size(), this.transforms.size()));
        for (Map.Entry remainingEntry : this.transforms.entrySet()) {
            if (!remainingOriginals.contains(remainingEntry.getKey())) continue;
            remainingTransforms.put(remainingEntry);
        }
        return new TransformedClassPath(filteredClassPath, remainingTransforms.build());
    }

    @Nullable
    public File findTransformedJarFor(File originalClassPathEntry) {
        return this.transforms.get(originalClassPathEntry);
    }

    public int hashCode() {
        return this.originalClassPath.hashCode() + this.transforms.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransformedClassPath other = (TransformedClassPath)obj;
        return this.originalClassPath.equals(other.originalClassPath) && this.transforms.equals(other.transforms);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (File original : this.originalClassPath.getAsFiles()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(original);
            File transformed = this.findTransformedJarFor(original);
            if (transformed != null) {
                builder.append("->").append(transformed);
            }
            first = false;
        }
        builder.append("]");
        return builder.toString();
    }

    public static TransformedClassPath fromInstrumentingArtifactTransformOutput(ClassPath classPath) {
        Preconditions.checkArgument(!(classPath instanceof TransformedClassPath), "Cannot build the TransformedClassPath out of TransformedClassPath %s", (Object)classPath);
        return TransformedClassPath.fromInstrumentingArtifactTransformOutputWithExpectedSize(classPath, TransformedClassPath.computeResultSizeOfInstrumentingArtifactTransformOutput(classPath));
    }

    public static ClassPath handleInstrumentingArtifactTransform(ClassPath classPath) {
        if (classPath.isEmpty() || classPath instanceof TransformedClassPath) {
            return classPath;
        }
        int resultSize = TransformedClassPath.computeResultSizeOfInstrumentingArtifactTransformOutput(classPath);
        if (resultSize == classPath.getAsFiles().size()) {
            return classPath;
        }
        return TransformedClassPath.fromInstrumentingArtifactTransformOutputWithExpectedSize(classPath, resultSize);
    }

    private static int computeResultSizeOfInstrumentingArtifactTransformOutput(ClassPath classPath) {
        int resultSize = 0;
        for (int i = 0; i < classPath.getAsFiles().size(); ++i) {
            File inputFile = classPath.getAsFiles().get(i);
            if (TransformedClassPath.isInstrumentedMarkerFile(inputFile)) {
                i += 2;
            }
            ++resultSize;
        }
        return resultSize;
    }

    private static TransformedClassPath fromInstrumentingArtifactTransformOutputWithExpectedSize(ClassPath classPath, int resultSize) {
        List<File> inputFiles = classPath.getAsFiles();
        Builder result = TransformedClassPath.builderWithExactSize(resultSize);
        for (int i = 0; i < inputFiles.size(); ++i) {
            File inputFile = inputFiles.get(i);
            if (TransformedClassPath.isInstrumentedMarkerFile(inputFile)) {
                Preconditions.checkArgument(i + 2 < inputFiles.size(), "Missing the instrumented or original JAR for classpath %s", inputFiles);
                File instrumentedJar = inputFiles.get(i + 1);
                File originalJar = inputFiles.get(i + 2);
                Preconditions.checkArgument(TransformedClassPath.areInstrumentedAndOriginalJarValid(instrumentedJar, originalJar), "Instrumented JAR %s doesn't match original JAR %s", (Object)instrumentedJar.getAbsolutePath(), (Object)originalJar.getAbsolutePath());
                result.add(originalJar, instrumentedJar);
                i += 2;
                continue;
            }
            result.addUntransformed(inputFile);
        }
        return result.build();
    }

    private static boolean areInstrumentedAndOriginalJarValid(File instrumentedJar, File originalJar) {
        return instrumentedJar.getParentFile() != null && instrumentedJar.getParentFile().getName().equals(INSTRUMENTED_JAR_DIR_NAME) && !originalJar.equals(instrumentedJar) && instrumentedJar.getName().equals(originalJar.getName());
    }

    private static boolean isInstrumentedMarkerFile(File classPathEntry) {
        return classPathEntry.getName().equals(INSTRUMENTED_MARKER_FILE_NAME);
    }

    public static Builder builderWithExactSize(int size) {
        return new Builder(size);
    }

    public static class Builder {
        private final DefaultClassPath.Builder originals;
        private final ImmutableMap.Builder<File, File> transforms;

        private Builder(int exactSize) {
            this.originals = DefaultClassPath.builderWithExactSize(exactSize);
            this.transforms = ImmutableMap.builderWithExpectedSize(exactSize);
        }

        public Builder add(File original, File transformed) {
            this.originals.add(original);
            if (!original.equals(transformed)) {
                this.transforms.put(original, transformed);
            }
            return this;
        }

        public Builder addUntransformed(File original) {
            this.originals.add(original);
            return this;
        }

        public TransformedClassPath build() {
            ImmutableMap<File, File> transformedMap = this.transforms.build();
            return new TransformedClassPath(this.originals.build(), transformedMap);
        }
    }
}

