/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.AppArtifactKey;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;

@Mojo(name="extension-descriptor", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class ExtensionDescriptorMojo
extends AbstractMojo {
    private static final String GROUP_ID = "group-id";
    private static final String ARTIFACT_ID = "artifact-id";
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.groupId}:${project.artifactId}-deployment:${project.version}")
    private String deployment;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}/META-INF/quarkus-extension.yaml")
    private File extensionFile;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter
    List<String> excludedArtifacts;
    @Parameter
    List<String> parentFirstArtifacts;
    @Parameter
    List<String> lesserPriorityArtifacts;
    @Parameter(required=false, defaultValue="${skipExtensionValidation}")
    private boolean skipExtensionValidation;

    public void execute() throws MojoExecutionException {
        ObjectNode extObject;
        String val;
        if (!this.skipExtensionValidation) {
            this.validateExtensionDeps();
        }
        Properties props = new Properties();
        props.setProperty("deployment-artifact", this.deployment);
        Path output = this.outputDirectory.toPath().resolve("META-INF");
        if (this.parentFirstArtifacts != null && !this.parentFirstArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.parentFirstArtifacts);
            props.put("parent-first-artifacts", val);
        }
        if (this.excludedArtifacts != null && !this.excludedArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.excludedArtifacts);
            props.put("excluded-artifacts", val);
        }
        if (this.lesserPriorityArtifacts != null && !this.lesserPriorityArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.lesserPriorityArtifacts);
            props.put("lesser-priority-artifacts", val);
        }
        try {
            Files.createDirectories(output, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(output.resolve("quarkus-extension.properties"), new OpenOption[0]);){
                props.store(writer, "Generated by extension-descriptor");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist extension descriptor " + output.resolve("quarkus-extension.properties"), (Exception)e);
        }
        if (this.extensionFile == null) {
            this.extensionFile = new File(this.outputDirectory, "META-INF" + File.separator + "quarkus-extension.yaml");
        }
        if (!this.extensionFile.exists()) {
            this.extensionFile = new File(this.extensionFile.getParent(), "quarkus-extension.json");
        }
        ObjectMapper mapper = null;
        if (this.extensionFile.exists()) {
            mapper = this.getMapper(this.extensionFile.toString().endsWith(".yaml"));
            try {
                extObject = this.processPlatformArtifact(this.extensionFile.toPath(), mapper);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse " + this.extensionFile, (Exception)e);
            }
        } else {
            mapper = this.getMapper(true);
            extObject = this.getMapper(true).createObjectNode();
        }
        this.transformLegacyToNew(output, extObject, mapper);
        if (extObject.get("groupId") == null) {
            extObject.put(GROUP_ID, this.project.getGroupId());
        }
        if (extObject.get("artifactId") == null) {
            extObject.put(ARTIFACT_ID, this.project.getArtifactId());
        }
        if (extObject.get("version") == null) {
            extObject.put("version", this.project.getVersion());
        }
        if (extObject.get("name") == null) {
            if (this.project.getName() != null) {
                extObject.put("name", this.project.getName());
            } else {
                JsonNode node = extObject.get(ARTIFACT_ID);
                String defaultName = node.asText();
                int i = 0;
                if (defaultName.startsWith("quarkus-")) {
                    i = "quarkus-".length();
                }
                StringBuilder buf = new StringBuilder();
                boolean startWord = true;
                while (i < defaultName.length()) {
                    char c;
                    if ((c = defaultName.charAt(i++)) == '-') {
                        if (startWord) continue;
                        buf.append(' ');
                        startWord = true;
                        continue;
                    }
                    if (startWord) {
                        buf.append(Character.toUpperCase(c));
                        startWord = false;
                        continue;
                    }
                    buf.append(c);
                }
                defaultName = buf.toString();
                this.getLog().warn((CharSequence)("Extension name has not been provided for " + extObject.get(GROUP_ID).asText("") + ":" + extObject.get(ARTIFACT_ID).asText("") + "! Using '" + defaultName + "' as the default one."));
                extObject.put("name", defaultName);
            }
        }
        if (!extObject.has("description") && this.project.getDescription() != null) {
            extObject.put("description", this.project.getDescription());
        }
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        try (BufferedWriter bw = Files.newBufferedWriter(output.resolve("quarkus-extension.yaml"), new OpenOption[0]);){
            bw.write(this.getMapper(true).writer((PrettyPrinter)prettyPrinter).writeValueAsString((Object)extObject));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist " + output.resolve("quarkus-extension.yaml"), (Exception)e);
        }
    }

    private void validateExtensionDeps() throws MojoExecutionException {
        CollectResult collectedDeploymentDeps;
        DependencyResult resolvedDeps;
        AppArtifactCoords deploymentCoords = AppArtifactCoords.fromString((String)this.deployment);
        AppArtifactKey rootDeploymentGact = deploymentCoords.getKey();
        final Node rootDeployment = new Node(null, rootDeploymentGact, 2);
        Artifact artifact = this.project.getArtifact();
        Node rootRuntime = rootDeployment.newChild(new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType()), 1);
        final HashMap<AppArtifactKey, Node> expectedExtensionDeps = new HashMap<AppArtifactKey, Node>();
        expectedExtensionDeps.put(rootDeploymentGact, rootDeployment);
        expectedExtensionDeps.put(rootRuntime.gact, rootRuntime);
        try {
            resolvedDeps = this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(this.newCollectRequest(new DefaultArtifact(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getClassifier(), this.project.getArtifact().getArtifactHandler().getExtension(), this.project.getArtifact().getVersion()))));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve dependencies of " + this.project.getArtifact(), e);
        }
        final AtomicInteger extDepsTotal = new AtomicInteger(2);
        resolvedDeps.getRoot().accept(new DependencyVisitor(){
            Node currentNode;
            int currentNodeId;
            {
                this.currentNode = rootDeployment;
                this.currentNodeId = rootDeployment.id;
            }

            public boolean visitEnter(DependencyNode node) {
                block28: {
                    ++this.currentNodeId;
                    org.eclipse.aether.artifact.Artifact a = node.getArtifact();
                    File f = a.getFile();
                    if (ExtensionDescriptorMojo.this.isAnalyzable(f)) {
                        try (FileSystem fs = FileSystems.newFileSystem(f.toPath(), (ClassLoader)null);){
                            Path extDescr = fs.getPath("META-INF/quarkus-extension.properties", new String[0]);
                            if (!Files.exists(extDescr, new LinkOption[0])) break block28;
                            Properties props = new Properties();
                            try (BufferedReader reader = Files.newBufferedReader(extDescr);){
                                props.load(reader);
                            }
                            String deploymentStr = props.getProperty("deployment-artifact");
                            if (deploymentStr == null) {
                                throw new IllegalStateException("Quarkus extension runtime artifact " + a + " is missing " + "deployment-artifact" + " property in its " + "META-INF/quarkus-extension.properties");
                            }
                            this.currentNode = this.currentNode.newChild(AppArtifactCoords.fromString((String)deploymentStr).getKey(), this.currentNodeId);
                            expectedExtensionDeps.put(this.currentNode.gact, this.currentNode);
                            extDepsTotal.incrementAndGet();
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Failed to read " + f, e);
                        }
                    }
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                if (this.currentNodeId == this.currentNode.id && this.currentNode.parent != null) {
                    this.currentNode = this.currentNode.parent;
                }
                --this.currentNodeId;
                return true;
            }
        });
        try {
            collectedDeploymentDeps = this.repoSystem.collectDependencies(this.repoSession, this.newCollectRequest(new DefaultArtifact(deploymentCoords.getGroupId(), deploymentCoords.getArtifactId(), deploymentCoords.getClassifier(), deploymentCoords.getType(), deploymentCoords.getVersion())));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to collect dependencies of deployment artifact " + deploymentCoords, e);
        }
        collectedDeploymentDeps.getRoot().accept(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode dep) {
                org.eclipse.aether.artifact.Artifact artifact = dep.getArtifact();
                if (artifact == null) {
                    return true;
                }
                Node node = (Node)expectedExtensionDeps.get(new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension()));
                if (node != null && !node.included) {
                    node.included = true;
                    extDepsTotal.decrementAndGet();
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        });
        if (extDepsTotal.intValue() != 0) {
            Log log = this.getLog();
            log.error((CharSequence)"Quarkus Extension Dependency Verification Error");
            log.error((CharSequence)("Deployment artifact " + deploymentCoords + " was found to be missing dependencies on Quarkus extension artifacts marked with '-' below:"));
            List<AppArtifactKey> missing = rootDeployment.collectMissing(log);
            StringBuilder buf = new StringBuilder();
            buf.append("Deployment artifact ");
            buf.append(deploymentCoords);
            buf.append(" is missing the following dependencies from its configuration: ");
            Iterator<AppArtifactKey> i = missing.iterator();
            buf.append(i.next());
            while (i.hasNext()) {
                buf.append(", ").append(i.next());
            }
            throw new MojoExecutionException(buf.toString());
        }
    }

    private CollectRequest newCollectRequest(DefaultArtifact projectArtifact) throws MojoExecutionException {
        ArtifactDescriptorResult projectDescr;
        try {
            projectDescr = this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact((org.eclipse.aether.artifact.Artifact)projectArtifact).setRepositories(this.repos));
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoExecutionException("Failed to read descriptor of " + projectArtifact, (Exception)((Object)e));
        }
        CollectRequest request = new CollectRequest().setRootArtifact((org.eclipse.aether.artifact.Artifact)projectArtifact).setRepositories(this.repos).setManagedDependencies(projectDescr.getManagedDependencies());
        for (Dependency dep : projectDescr.getDependencies()) {
            if ("test".equals(dep.getScope()) || "provided".equals(dep.getScope()) || dep.isOptional()) continue;
            request.addDependency(dep);
        }
        return request;
    }

    private boolean isAnalyzable(File f) {
        return f != null && f.getName().endsWith(".jar") && f.exists() && !f.isDirectory();
    }

    private void transformLegacyToNew(Path output, ObjectNode extObject, ObjectMapper mapper) throws MojoExecutionException {
        JsonNode mvalue;
        ObjectNode metadata = null;
        if (extObject.get("groupId") != null) {
            extObject.set(GROUP_ID, extObject.get("groupId"));
            extObject.remove("groupId");
        }
        if (extObject.get("artifactId") != null) {
            extObject.set(ARTIFACT_ID, extObject.get("artifactId"));
            extObject.remove("artifactId");
        }
        metadata = (mvalue = extObject.get("metadata")) != null && mvalue.isObject() ? (ObjectNode)mvalue : mapper.createObjectNode();
        if (extObject.get("labels") != null) {
            metadata.set("keywords", extObject.get("labels"));
            extObject.remove("labels");
        }
        if (extObject.get("guide") != null) {
            metadata.set("guide", extObject.get("guide"));
            extObject.remove("guide");
        }
        if (extObject.get("shortName") != null) {
            metadata.set("short-name", extObject.get("shortName"));
            extObject.remove("shortName");
        }
        extObject.set("metadata", (JsonNode)metadata);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectNode processPlatformArtifact(Path descriptor, ObjectMapper mapper) throws IOException {
        try (InputStream is = Files.newInputStream(descriptor, new OpenOption[0]);){
            ObjectNode objectNode = (ObjectNode)mapper.readValue(is, ObjectNode.class);
            return objectNode;
        }
        catch (IOException io) {
            throw new IOException("Failed to parse " + descriptor, io);
        }
    }

    private ObjectMapper getMapper(boolean yaml) {
        if (yaml) {
            YAMLFactory yf = new YAMLFactory();
            return new ObjectMapper((JsonFactory)yf).setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
        }
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS}).setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
    }

    private static class Node {
        final Node parent;
        final AppArtifactKey gact;
        final int id;
        boolean included;
        List<Node> children = new ArrayList<Node>(0);

        Node(Node parent, AppArtifactKey gact, int id) {
            this.parent = parent;
            this.gact = gact;
            this.id = id;
        }

        Node newChild(AppArtifactKey gact, int id) {
            Node child = new Node(this, gact, id);
            this.children.add(child);
            return child;
        }

        List<AppArtifactKey> collectMissing(Log log) {
            ArrayList<AppArtifactKey> missing = new ArrayList<AppArtifactKey>();
            this.collectMissing(log, 0, missing);
            return missing;
        }

        private void collectMissing(Log log, int depth, List<AppArtifactKey> missing) {
            StringBuilder buf = new StringBuilder();
            if (this.included) {
                buf.append('+');
            } else {
                buf.append('-');
                missing.add(this.gact);
            }
            buf.append(' ');
            for (int i = 0; i < depth; ++i) {
                buf.append("    ");
            }
            buf.append(this.gact);
            log.error((CharSequence)buf.toString());
            for (Node child : this.children) {
                child.collectMissing(log, depth + 1, missing);
            }
        }
    }
}

