/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class AbstractTreeMojo
extends AbstractMojo {
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repos;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AppArtifact appArtifact = new AppArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        try {
            BootstrapAppModelResolver modelResolver = new BootstrapAppModelResolver(MavenArtifactResolver.builder().setRepositorySystem(this.repoSystem).setRepositorySystemSession(this.repoSession).setRemoteRepositories(this.repos).build());
            this.setupResolver(modelResolver);
            modelResolver.setBuildTreeLogger(s -> this.getLog().info((CharSequence)s));
            modelResolver.resolveModel(appArtifact);
        }
        catch (AppModelResolverException e) {
            throw new MojoExecutionException("Failed to resolve application model " + appArtifact + " dependencies", (Exception)((Object)e));
        }
    }

    protected void setupResolver(BootstrapAppModelResolver modelResolver) {
    }
}

