/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="extension-descriptor", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ExtensionDescriptorMojo
extends AbstractMojo {
    private static final String GROUP_ID = "group-id";
    private static final String ARTIFACT_ID = "artifact-id";
    private static DefaultPrettyPrinter prettyPrinter = null;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.groupId}:${project.artifactId}-deployment:${project.version}")
    private String deployment;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}/META-INF/quarkus-extension.yaml")
    private File extensionFile;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter
    List<String> excludedArtifacts;
    @Parameter
    List<String> parentFirstArtifacts;

    public void execute() throws MojoExecutionException {
        ObjectNode extObject;
        String val;
        prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        Properties props = new Properties();
        props.setProperty("deployment-artifact", this.deployment);
        Path output = this.outputDirectory.toPath().resolve("META-INF");
        if (this.parentFirstArtifacts != null && !this.parentFirstArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.parentFirstArtifacts);
            props.put("parent-first-artifacts", val);
        }
        if (this.excludedArtifacts != null && !this.excludedArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.excludedArtifacts);
            props.put("excluded-artifacts", val);
        }
        try {
            Files.createDirectories(output, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(output.resolve("quarkus-extension.properties"), new OpenOption[0]);){
                props.store(writer, "Generated by extension-descriptor");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist extension descriptor " + output.resolve("quarkus-extension.properties"), (Exception)e);
        }
        if (this.extensionFile == null) {
            this.extensionFile = new File(this.outputDirectory, "META-INF" + File.separator + "quarkus-extension.yaml");
        }
        if (!this.extensionFile.exists()) {
            this.extensionFile = new File(this.extensionFile.getParent(), "quarkus-extension.json");
        }
        ObjectMapper mapper = null;
        if (this.extensionFile.exists()) {
            mapper = this.getMapper(this.extensionFile.toString().endsWith(".yaml"));
            try {
                extObject = this.processPlatformArtifact(this.extensionFile.toPath(), mapper);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse " + this.extensionFile, (Exception)e);
            }
        } else {
            mapper = this.getMapper(true);
            extObject = this.getMapper(true).createObjectNode();
        }
        this.transformLegacyToNew(output, extObject, mapper);
        if (extObject.get("groupId") == null) {
            extObject.put(GROUP_ID, this.project.getGroupId());
        }
        if (extObject.get("artifactId") == null) {
            extObject.put(ARTIFACT_ID, this.project.getArtifactId());
        }
        if (extObject.get("version") == null) {
            extObject.put("version", this.project.getVersion());
        }
        if (extObject.get("name") == null) {
            if (this.project.getName() != null) {
                extObject.put("name", this.project.getName());
            } else {
                JsonNode node = extObject.get(ARTIFACT_ID);
                String defaultName = node.asText();
                int i = 0;
                if (defaultName.startsWith("quarkus-")) {
                    i = "quarkus-".length();
                }
                StringBuilder buf = new StringBuilder();
                boolean startWord = true;
                while (i < defaultName.length()) {
                    char c;
                    if ((c = defaultName.charAt(i++)) == '-') {
                        if (startWord) continue;
                        buf.append(' ');
                        startWord = true;
                        continue;
                    }
                    if (startWord) {
                        buf.append(Character.toUpperCase(c));
                        startWord = false;
                        continue;
                    }
                    buf.append(c);
                }
                defaultName = buf.toString();
                this.getLog().warn((CharSequence)("Extension name has not been provided for " + extObject.get(GROUP_ID).asText("") + ":" + extObject.get(ARTIFACT_ID).asText("") + "! Using '" + defaultName + "' as the default one."));
                extObject.put("name", defaultName);
            }
        }
        if (!extObject.has("description") && this.project.getDescription() != null) {
            extObject.put("description", this.project.getDescription());
        }
        try (BufferedWriter bw = Files.newBufferedWriter(output.resolve("quarkus-extension.yaml"), new OpenOption[0]);){
            bw.write(this.getMapper(true).writer((PrettyPrinter)prettyPrinter).writeValueAsString((Object)extObject));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist " + output.resolve("quarkus-extension.yaml"), (Exception)e);
        }
    }

    private void transformLegacyToNew(Path output, ObjectNode extObject, ObjectMapper mapper) throws MojoExecutionException {
        JsonNode mvalue;
        ObjectNode metadata = null;
        if (extObject.get("groupId") != null) {
            extObject.set(GROUP_ID, extObject.get("groupId"));
            extObject.remove("groupId");
        }
        if (extObject.get("artifactId") != null) {
            extObject.set(ARTIFACT_ID, extObject.get("artifactId"));
            extObject.remove("artifactId");
        }
        metadata = (mvalue = extObject.get("metadata")) != null && mvalue.isObject() ? (ObjectNode)mvalue : mapper.createObjectNode();
        if (extObject.get("labels") != null) {
            metadata.set("keywords", extObject.get("labels"));
            extObject.remove("labels");
        }
        if (extObject.get("guide") != null) {
            metadata.set("guide", extObject.get("guide"));
            extObject.remove("guide");
        }
        if (extObject.get("shortName") != null) {
            metadata.set("short-name", extObject.get("shortName"));
            extObject.remove("shortName");
        }
        extObject.set("metadata", (JsonNode)metadata);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectNode processPlatformArtifact(Path descriptor, ObjectMapper mapper) throws IOException {
        try (InputStream is = Files.newInputStream(descriptor, new OpenOption[0]);){
            ObjectNode objectNode = (ObjectNode)mapper.readValue(is, ObjectNode.class);
            return objectNode;
        }
        catch (IOException io) {
            throw new IOException("Failed to parse " + descriptor, io);
        }
    }

    private ObjectMapper getMapper(boolean yaml) {
        if (yaml) {
            YAMLFactory yf = new YAMLFactory();
            return new ObjectMapper((JsonFactory)yf).setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
        }
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS}).setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
    }
}

