/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapWagonConfigurator;
import io.quarkus.bootstrap.resolver.maven.BootstrapWagonProvider;
import io.quarkus.bootstrap.resolver.maven.MavenModelBuilder;
import io.quarkus.bootstrap.resolver.maven.SettingsDecrypterImpl;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.cli.transfer.BatchModeMavenTransferListener;
import org.apache.maven.cli.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.FileProfileActivator;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.jboss.logging.Logger;

public class BootstrapMavenContext {
    private static final Logger log = Logger.getLogger(BootstrapMavenContext.class);
    private static final String BASEDIR = "basedir";
    private static final String DEFAULT_REMOTE_REPO_ID = "central";
    private static final String DEFAULT_REMOTE_REPO_URL = "https://repo.maven.apache.org/maven2";
    private static final String MAVEN_DOT_HOME = "maven.home";
    private static final String MAVEN_HOME = "MAVEN_HOME";
    private static final String MAVEN_PROJECTBASEDIR = "MAVEN_PROJECTBASEDIR";
    private static final String MAVEN_SETTINGS = "maven.settings";
    private static final String SETTINGS_XML = "settings.xml";
    private static final String userHome = PropertyUtils.getUserHome();
    private static final File userMavenConfigurationHome = new File(userHome, ".m2");
    private boolean artifactTransferLogging;
    private BootstrapMavenOptions cliOptions;
    private File userSettings;
    private File globalSettings;
    private Boolean offline;
    private LocalWorkspace workspace;
    private LocalProject currentProject;
    private Settings settings;
    private List<org.apache.maven.model.Profile> activeSettingsProfiles;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;
    private RemoteRepositoryManager remoteRepoManager;
    private String localRepo;
    private Path currentPom;
    private Boolean currentProjectExists;
    private DefaultServiceLocator serviceLocator;
    private String alternatePomName;
    private Path rootProjectDir;

    public static BootstrapMavenContextConfig<?> config() {
        return new BootstrapMavenContextConfig();
    }

    public BootstrapMavenContext() throws BootstrapMavenException {
        this(new BootstrapMavenContextConfig());
    }

    public BootstrapMavenContext(BootstrapMavenContextConfig<?> config) throws BootstrapMavenException {
        this.alternatePomName = config.alternatePomName;
        this.artifactTransferLogging = config.artifactTransferLogging;
        this.localRepo = config.localRepo;
        this.offline = config.offline;
        this.repoSystem = config.repoSystem;
        this.repoSession = config.repoSession;
        this.remoteRepos = config.remoteRepos;
        this.remoteRepoManager = config.remoteRepoManager;
        this.cliOptions = config.cliOptions;
        this.rootProjectDir = config.rootProjectDir;
        if (config.currentProject != null) {
            this.currentProject = config.currentProject;
            this.currentPom = this.currentProject.getRawModel().getPomFile().toPath();
            this.workspace = config.currentProject.getWorkspace();
        } else if (config.workspaceDiscovery) {
            this.currentProject = this.resolveCurrentProject();
            this.workspace = this.currentProject == null ? null : this.currentProject.getWorkspace();
        }
        this.userSettings = config.userSettings;
    }

    public AppArtifact getCurrentProjectArtifact(String extension) throws BootstrapMavenException {
        if (this.currentProject != null) {
            return this.currentProject.getAppArtifact(extension);
        }
        Model model = this.loadCurrentProjectModel();
        if (model == null) {
            return null;
        }
        return new AppArtifact(ModelUtils.getGroupId(model), model.getArtifactId(), "", extension, ModelUtils.getVersion(model));
    }

    public LocalProject getCurrentProject() {
        return this.currentProject;
    }

    public LocalWorkspace getWorkspace() {
        return this.workspace;
    }

    public BootstrapMavenOptions getCliOptions() {
        return this.cliOptions == null ? (this.cliOptions = BootstrapMavenOptions.newInstance()) : this.cliOptions;
    }

    public File getUserSettings() {
        return this.userSettings == null ? (this.userSettings = this.resolveSettingsFile(this.getCliOptions().getOptionValue("s"), () -> {
            String quarkusMavenSettings = this.getProperty(MAVEN_SETTINGS);
            return quarkusMavenSettings == null ? new File(userMavenConfigurationHome, SETTINGS_XML) : new File(quarkusMavenSettings);
        })) : this.userSettings;
    }

    private String getProperty(String name) {
        String value = PropertyUtils.getProperty((String)name);
        if (value != null) {
            return value;
        }
        Properties props = this.getCliOptions().getSystemProperties();
        return props == null ? null : props.getProperty(name);
    }

    public File getGlobalSettings() {
        return this.globalSettings == null ? (this.globalSettings = this.resolveSettingsFile(this.getCliOptions().getOptionValue("gs"), () -> {
            String mavenHome = this.getProperty(MAVEN_DOT_HOME);
            if (mavenHome == null && (mavenHome = System.getenv(MAVEN_HOME)) == null) {
                mavenHome = "";
            }
            return new File(mavenHome, "conf/settings.xml");
        })) : this.globalSettings;
    }

    public boolean isOffline() throws BootstrapMavenException {
        return this.offline == null ? (this.offline = Boolean.valueOf(this.getCliOptions().hasOption("o") || this.getEffectiveSettings().isOffline())) : this.offline;
    }

    public RepositorySystem getRepositorySystem() throws BootstrapMavenException {
        return this.repoSystem == null ? (this.repoSystem = this.newRepositorySystem()) : this.repoSystem;
    }

    public RepositorySystemSession getRepositorySystemSession() throws BootstrapMavenException {
        return this.repoSession == null ? (this.repoSession = this.newRepositorySystemSession()) : this.repoSession;
    }

    public List<RemoteRepository> getRemoteRepositories() throws BootstrapMavenException {
        return this.remoteRepos == null ? (this.remoteRepos = this.resolveRemoteRepos()) : this.remoteRepos;
    }

    public Settings getEffectiveSettings() throws BootstrapMavenException {
        Settings effectiveSettings;
        if (this.settings != null) {
            return this.settings;
        }
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest().setSystemProperties(System.getProperties()).setUserSettingsFile(this.getUserSettings()).setGlobalSettingsFile(this.getGlobalSettings());
        Properties cmdLineProps = this.getCliOptions().getSystemProperties();
        if (cmdLineProps != null) {
            settingsRequest.setUserProperties(cmdLineProps);
        }
        try {
            SettingsBuildingResult result = new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)settingsRequest);
            List problems = result.getProblems();
            if (!problems.isEmpty()) {
                for (SettingsProblem problem : problems) {
                    switch (problem.getSeverity()) {
                        case ERROR: 
                        case FATAL: {
                            throw new BootstrapMavenException("Settings problem encountered at " + problem.getLocation(), problem.getException());
                        }
                    }
                    log.warn((Object)("Settings problem encountered at " + problem.getLocation()), (Throwable)problem.getException());
                }
            }
            effectiveSettings = result.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new BootstrapMavenException("Failed to initialize Maven repository settings", e);
        }
        this.settings = effectiveSettings;
        return this.settings;
    }

    public String getLocalRepo() throws BootstrapMavenException {
        return this.localRepo == null ? (this.localRepo = this.resolveLocalRepo(this.getEffectiveSettings())) : this.localRepo;
    }

    private LocalProject resolveCurrentProject() throws BootstrapMavenException {
        try {
            return LocalProject.loadWorkspace(this);
        }
        catch (Exception e) {
            throw new BootstrapMavenException("Failed to load current project at " + this.getCurrentProjectPomOrNull(), e);
        }
    }

    private String resolveLocalRepo(Settings settings) {
        String localRepo = System.getenv("QUARKUS_LOCAL_REPO");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = this.getProperty("maven.repo.local");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = settings.getLocalRepository();
        return localRepo == null ? new File(userMavenConfigurationHome, "repository").getAbsolutePath() : localRepo;
    }

    private File resolveSettingsFile(String settingsArg, Supplier<File> supplier) {
        File userSettings;
        if (settingsArg != null) {
            userSettings = new File(settingsArg);
            if (userSettings.exists()) {
                return userSettings;
            }
            if (userSettings.isAbsolute()) {
                return null;
            }
            String alternatePomDir = this.getCliOptions().getOptionValue("f");
            if (alternatePomDir != null) {
                File tmp = new File(alternatePomDir);
                if (tmp.isAbsolute()) {
                    alternatePomDir = null;
                } else {
                    if (!tmp.isDirectory()) {
                        tmp = tmp.getParentFile();
                    }
                    alternatePomDir = tmp.toString();
                }
            }
            if ((userSettings = this.resolveSettingsFile(settingsArg, alternatePomDir, System.getenv(MAVEN_PROJECTBASEDIR))) != null) {
                return userSettings;
            }
            userSettings = this.resolveSettingsFile(settingsArg, alternatePomDir, PropertyUtils.getProperty((String)BASEDIR));
            if (userSettings != null) {
                return userSettings;
            }
            userSettings = new File(PropertyUtils.getUserHome(), settingsArg);
            if (userSettings.exists()) {
                return userSettings;
            }
        }
        return (userSettings = supplier.get()).exists() ? userSettings : null;
    }

    private File resolveSettingsFile(String settingsArg, String alternatePomDir, String projectBaseDir) {
        File userSettings;
        if (projectBaseDir == null) {
            return null;
        }
        if (alternatePomDir != null && projectBaseDir.endsWith(alternatePomDir) && (userSettings = new File(projectBaseDir.substring(0, projectBaseDir.length() - alternatePomDir.length()), settingsArg)).exists()) {
            return userSettings;
        }
        userSettings = new File(projectBaseDir, settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        return null;
    }

    private DefaultRepositorySystemSession newRepositorySystemSession() throws BootstrapMavenException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        Settings settings = this.getEffectiveSettings();
        List mirrors = settings.getMirrors();
        if (mirrors != null && !mirrors.isEmpty()) {
            DefaultMirrorSelector ms = new DefaultMirrorSelector();
            for (Mirror m : mirrors) {
                ms.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
            }
            session.setMirrorSelector((MirrorSelector)ms);
        }
        String localRepoPath = this.getLocalRepo();
        session.setLocalRepositoryManager(this.getRepositorySystem().newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepoPath)));
        session.setOffline(this.isOffline());
        BootstrapMavenOptions mvnArgs = this.getCliOptions();
        if (!mvnArgs.isEmpty()) {
            if (mvnArgs.hasOption("nsu")) {
                session.setUpdatePolicy("never");
            } else if (mvnArgs.hasOption("U")) {
                session.setUpdatePolicy("always");
            }
            if (mvnArgs.hasOption("C")) {
                session.setChecksumPolicy("fail");
            } else if (mvnArgs.hasOption("c")) {
                session.setChecksumPolicy("warn");
            }
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(settings.getProxies());
        decrypt.setServers(settings.getServers());
        SettingsDecryptionResult decrypted = new SettingsDecrypterImpl().decrypt((SettingsDecryptionRequest)decrypt);
        if (!decrypted.getProblems().isEmpty() && log.isDebugEnabled()) {
            for (SettingsProblem p : decrypted.getProblems()) {
                log.debug((Object)p.getMessage(), (Throwable)p.getException());
            }
        }
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy p : decrypted.getProxies()) {
            if (!p.isActive()) continue;
            proxySelector.add(BootstrapMavenContext.toAetherProxy(p), p.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        LinkedHashMap<String, Object> configProps = new LinkedHashMap<String, Object>(session.getConfigProperties());
        configProps.put("aether.connector.userAgent", BootstrapMavenContext.getUserAgent());
        configProps.put("aether.interactive", settings.isInteractiveMode());
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("aether.connector.wagon.config." + server.getId(), config);
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector((AuthenticationSelector)authSelector);
        session.setConfigProperties(configProps);
        if (session.getCache() == null) {
            session.setCache((RepositoryCache)new DefaultRepositoryCache());
        }
        if (this.workspace != null) {
            session.setWorkspaceReader((WorkspaceReader)this.workspace);
        }
        if (session.getTransferListener() == null && this.artifactTransferLogging) {
            Object transferListener = mvnArgs.hasOption("ntp") ? new QuietMavenTransferListener() : (mvnArgs.hasOption("B") ? new BatchModeMavenTransferListener(System.out) : new ConsoleMavenTransferListener(System.out, true));
            session.setTransferListener((TransferListener)transferListener);
        }
        return session;
    }

    private List<RemoteRepository> resolveRemoteRepos() throws BootstrapMavenException {
        ArrayList<RemoteRepository> rawRepos = new ArrayList<RemoteRepository>();
        this.getActiveSettingsProfiles().forEach(p -> BootstrapMavenContext.addProfileRepos(p, rawRepos));
        if (rawRepos.isEmpty() || !BootstrapMavenContext.includesDefaultRepo(rawRepos)) {
            rawRepos.add(BootstrapMavenContext.newDefaultRepository());
        }
        List<RemoteRepository> repos = this.getRepositorySystem().newResolutionRepositories(this.getRepositorySystemSession(), rawRepos);
        return this.workspace == null ? repos : this.resolveCurrentProjectRepos(repos);
    }

    public static RemoteRepository newDefaultRepository() {
        return new RemoteRepository.Builder(DEFAULT_REMOTE_REPO_ID, "default", DEFAULT_REMOTE_REPO_URL).setReleasePolicy(new RepositoryPolicy(true, "daily", "warn")).setSnapshotPolicy(new RepositoryPolicy(false, "daily", "warn")).build();
    }

    private Model loadCurrentProjectModel() throws BootstrapMavenException {
        Path pom = this.getCurrentProjectPomOrNull();
        if (pom == null) {
            return null;
        }
        try {
            return ModelUtils.readModel(pom);
        }
        catch (IOException e) {
            throw new BootstrapMavenException("Failed to parse " + pom, e);
        }
    }

    private List<RemoteRepository> resolveCurrentProjectRepos(List<RemoteRepository> repos) throws BootstrapMavenException {
        List rawRepos;
        Model model = this.loadCurrentProjectModel();
        if (model == null) {
            return repos;
        }
        DefaultArtifact projectArtifact = new DefaultArtifact(ModelUtils.getGroupId(model), model.getArtifactId(), "", "pom", ModelUtils.getVersion(model));
        try {
            rawRepos = this.getRepositorySystem().readArtifactDescriptor(this.getRepositorySystemSession(), new ArtifactDescriptorRequest().setArtifact((Artifact)projectArtifact).setRepositories(repos)).getRepositories();
        }
        catch (ArtifactDescriptorException e) {
            throw new BootstrapMavenException("Failed to read artifact descriptor for " + projectArtifact, e);
        }
        return this.getRepositorySystem().newResolutionRepositories(this.getRepositorySystemSession(), rawRepos);
    }

    public List<org.apache.maven.model.Profile> getActiveSettingsProfiles() throws BootstrapMavenException {
        if (this.activeSettingsProfiles != null) {
            return this.activeSettingsProfiles;
        }
        Settings settings = this.getEffectiveSettings();
        int profilesTotal = settings.getProfiles().size();
        if (profilesTotal == 0) {
            return Collections.emptyList();
        }
        ArrayList<org.apache.maven.model.Profile> modelProfiles = new ArrayList<org.apache.maven.model.Profile>(profilesTotal);
        for (Profile profile : settings.getProfiles()) {
            modelProfiles.add(SettingsUtils.convertFromSettingsProfile((Profile)profile));
        }
        BootstrapMavenOptions mvnArgs = this.getCliOptions();
        List activeProfiles = mvnArgs.getActiveProfileIds();
        List<String> inactiveProfiles = mvnArgs.getInactiveProfileIds();
        Path currentPom = this.getCurrentProjectPomOrNull();
        DefaultProfileActivationContext context = new DefaultProfileActivationContext().setActiveProfileIds(activeProfiles).setInactiveProfileIds(inactiveProfiles).setSystemProperties(System.getProperties()).setProjectDirectory(currentPom == null ? this.getCurrentProjectBaseDir().toFile() : currentPom.getParent().toFile());
        DefaultProfileSelector profileSelector = new DefaultProfileSelector().addProfileActivator((ProfileActivator)new PropertyProfileActivator()).addProfileActivator((ProfileActivator)new JdkVersionProfileActivator()).addProfileActivator((ProfileActivator)new OperatingSystemProfileActivator()).addProfileActivator((ProfileActivator)new FileProfileActivator().setPathTranslator((PathTranslator)new DefaultPathTranslator()));
        modelProfiles = profileSelector.getActiveProfiles(modelProfiles, (ProfileActivationContext)context, new ModelProblemCollector(){

            public void add(ModelProblemCollectorRequest req) {
                log.error((Object)("Failed to activate a Maven profile: " + req.getMessage()));
            }
        });
        activeProfiles = settings.getActiveProfiles();
        if (!activeProfiles.isEmpty()) {
            for (String profileName : activeProfiles) {
                Profile profile = BootstrapMavenContext.getProfile(profileName, settings);
                if (profile == null) continue;
                modelProfiles.add(SettingsUtils.convertFromSettingsProfile((Profile)profile));
            }
        }
        this.activeSettingsProfiles = modelProfiles;
        return this.activeSettingsProfiles;
    }

    private static Profile getProfile(String name, Settings settings) throws BootstrapMavenException {
        Profile profile = (Profile)settings.getProfilesAsMap().get(name);
        if (profile == null) {
            BootstrapMavenContext.unrecognizedProfile(name, true);
        }
        return profile;
    }

    private static void unrecognizedProfile(String name, boolean activate) {
        StringBuilder buf = new StringBuilder();
        buf.append("The requested Maven profile \"").append(name).append("\" could not be ");
        if (!activate) {
            buf.append("de");
        }
        buf.append("activated because it does not exist.");
        log.warn((Object)buf.toString());
    }

    private static boolean includesDefaultRepo(List<RemoteRepository> repositories) {
        for (ArtifactRepository artifactRepository : repositories) {
            if (!artifactRepository.getId().equals(DEFAULT_REMOTE_REPO_ID)) continue;
            return true;
        }
        return false;
    }

    private static void addProfileRepos(org.apache.maven.model.Profile profile, List<RemoteRepository> all) {
        List repositories = profile.getRepositories();
        for (Repository repo : repositories) {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            org.apache.maven.model.RepositoryPolicy policy = repo.getReleases();
            if (policy != null) {
                repoBuilder.setReleasePolicy(BootstrapMavenContext.toAetherRepoPolicy(policy));
            }
            if ((policy = repo.getSnapshots()) != null) {
                repoBuilder.setSnapshotPolicy(BootstrapMavenContext.toAetherRepoPolicy(policy));
            }
            all.add(repoBuilder.build());
        }
    }

    private static RepositoryPolicy toAetherRepoPolicy(org.apache.maven.model.RepositoryPolicy modelPolicy) {
        return new RepositoryPolicy(modelPolicy.isEnabled(), StringUtils.isEmpty((CharSequence)modelPolicy.getUpdatePolicy()) ? "daily" : modelPolicy.getUpdatePolicy(), StringUtils.isEmpty((CharSequence)modelPolicy.getChecksumPolicy()) ? "warn" : modelPolicy.getChecksumPolicy());
    }

    private static Proxy toAetherProxy(org.apache.maven.settings.Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        Authentication auth = null;
        if (proxy.getUsername() != null) {
            auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
    }

    private RepositorySystem newRepositorySystem() throws BootstrapMavenException {
        DefaultServiceLocator locator = this.getServiceLocator();
        if (!this.isOffline()) {
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
            locator.setServices(WagonConfigurator.class, (Object[])new WagonConfigurator[]{new BootstrapWagonConfigurator()});
            locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new BootstrapWagonProvider()});
        }
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new MavenModelBuilder(this.workspace, this.getCliOptions(), this.workspace == null ? Collections.emptyList() : this.getActiveSettingsProfiles())});
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                log.error((Object)("Failed to initialize " + impl.getName() + " as a service implementing " + type.getName()), exception);
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        if (this.remoteRepoManager != null) {
            return this.remoteRepoManager;
        }
        DefaultRemoteRepositoryManager remoteRepoManager = new DefaultRemoteRepositoryManager();
        remoteRepoManager.initService((ServiceLocator)this.getServiceLocator());
        this.remoteRepoManager = remoteRepoManager;
        return this.remoteRepoManager;
    }

    private DefaultServiceLocator getServiceLocator() {
        return this.serviceLocator == null ? (this.serviceLocator = MavenRepositorySystemUtils.newServiceLocator()) : this.serviceLocator;
    }

    private static String getUserAgent() {
        return "Apache-Maven/" + BootstrapMavenContext.getMavenVersion() + " (Java " + PropertyUtils.getProperty((String)"java.version") + "; " + PropertyUtils.getProperty((String)"os.name") + " " + PropertyUtils.getProperty((String)"os.version") + ")";
    }

    private static String getMavenVersion() {
        String mvnVersion = PropertyUtils.getProperty((String)"maven.version");
        if (mvnVersion != null) {
            return mvnVersion;
        }
        Properties props = new Properties();
        try (InputStream is = BootstrapMavenContext.class.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to read Maven version", (Throwable)e);
        }
        return props.getProperty("version", "unknown-version");
    }

    public boolean isCurrentProjectExists() {
        return this.currentProjectExists == null ? (this.currentProjectExists = Boolean.valueOf(this.getCurrentProjectPomOrNull() != null)) : this.currentProjectExists;
    }

    public Path getCurrentProjectPomOrNull() {
        if (this.currentPom != null || this.currentProjectExists != null && !this.currentProjectExists.booleanValue()) {
            return this.currentPom;
        }
        Path pom = this.resolveCurrentPom();
        this.currentProjectExists = pom != null;
        this.currentPom = this.currentProjectExists != false ? pom : null;
        return this.currentPom;
    }

    private Path resolveCurrentPom() {
        String basedirProp;
        String cliPomName;
        Path alternatePom = null;
        if (this.alternatePomName != null && (alternatePom = Paths.get(this.alternatePomName, new String[0])).isAbsolute()) {
            return BootstrapMavenContext.pomXmlOrNull(alternatePom);
        }
        if (alternatePom == null && (cliPomName = this.getCliOptions().getOptionValue("f")) != null) {
            alternatePom = Paths.get(cliPomName, new String[0]);
        }
        if ((basedirProp = PropertyUtils.getProperty((String)BASEDIR)) != null) {
            return BootstrapMavenContext.getPomForDirOrNull(Paths.get(basedirProp, new String[0]), alternatePom);
        }
        if (alternatePom != null && alternatePom.isAbsolute()) {
            return BootstrapMavenContext.pomXmlOrNull(alternatePom);
        }
        Path basedir = Paths.get("", new String[0]).normalize().toAbsolutePath();
        if (alternatePom != null) {
            return BootstrapMavenContext.pomXmlOrNull(basedir.resolve(alternatePom));
        }
        Path pom = basedir.resolve("pom.xml");
        return Files.exists(pom, new LinkOption[0]) ? pom : null;
    }

    static Path getPomForDirOrNull(Path basedir, Path alternatePom) {
        if (alternatePom != null && alternatePom.isAbsolute() && alternatePom.getParent().equals(basedir)) {
            return alternatePom;
        }
        Path pom = basedir.resolve("pom.xml");
        if (Files.exists(pom, new LinkOption[0])) {
            return pom;
        }
        if (alternatePom != null && !alternatePom.isAbsolute() && alternatePom.getNameCount() == 1 && Files.exists(pom = basedir.resolve(alternatePom), new LinkOption[0])) {
            return pom;
        }
        return null;
    }

    private static Path pomXmlOrNull(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path = path.resolve("pom.xml");
        }
        return Files.exists(path, new LinkOption[0]) ? path : null;
    }

    public Path getCurrentProjectBaseDir() {
        if (this.currentProject != null) {
            return this.currentProject.getDir();
        }
        String basedirProp = PropertyUtils.getProperty((String)BASEDIR);
        return basedirProp == null ? Paths.get("", new String[0]).normalize().toAbsolutePath() : Paths.get(basedirProp, new String[0]);
    }

    public Path getRootProjectBaseDir() {
        return this.rootProjectDir;
    }
}

