/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.util.PropertyUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ModelUtils {
    private static Pattern unresolvedVersionPattern;
    private static final String STATE_ARTIFACT_INITIAL_VERSION = "1";

    private static Pattern getUnresolvedVersionPattern() {
        return unresolvedVersionPattern == null ? (unresolvedVersionPattern = Pattern.compile(Pattern.quote("${") + "(revision|sha1|changelist)" + Pattern.quote("}"))) : unresolvedVersionPattern;
    }

    public static AppArtifact getStateArtifact(AppArtifact appArtifact) {
        return new AppArtifact(appArtifact.getGroupId() + ".quarkus.curate", appArtifact.getArtifactId(), "", "pom", STATE_ARTIFACT_INITIAL_VERSION);
    }

    public static List<AppDependency> getUpdateCandidates(List<Dependency> deps, List<AppDependency> appDeps, Set<String> groupIds) {
        LinkedHashMap<AppArtifactKey, AppDependency> appDepMap = new LinkedHashMap<AppArtifactKey, AppDependency>(appDeps.size());
        for (AppDependency appDep : appDeps) {
            AppArtifact appArt = appDep.getArtifact();
            appDepMap.put(new AppArtifactKey(appArt.getGroupId(), appArt.getArtifactId(), appArt.getClassifier()), appDep);
        }
        ArrayList<AppDependency> updateCandidates = new ArrayList<AppDependency>(deps.size());
        for (Dependency dep : deps) {
            AppDependency appDep;
            if (!groupIds.contains(dep.getGroupId()) || "test".equals(dep.getScope()) || (appDep = (AppDependency)appDepMap.remove(new AppArtifactKey(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier()))) == null) continue;
            updateCandidates.add(appDep);
        }
        for (AppDependency appDep : appDepMap.values()) {
            if (!groupIds.contains(appDep.getArtifact().getGroupId())) continue;
            updateCandidates.add(appDep);
        }
        return updateCandidates;
    }

    public static AppArtifact resolveAppArtifact(Path appJar) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(appJar, (ClassLoader)null);){
            Path metaInfMaven = fs.getPath("META-INF", "maven");
            if (Files.exists(metaInfMaven, new LinkOption[0])) {
                try (DirectoryStream<Path> groupIds = Files.newDirectoryStream(metaInfMaven);){
                    for (Path groupIdPath : groupIds) {
                        if (!Files.isDirectory(groupIdPath, new LinkOption[0])) continue;
                        DirectoryStream<Path> artifactIds = Files.newDirectoryStream(groupIdPath);
                        try {
                            for (Path artifactIdPath : artifactIds) {
                                if (!Files.isDirectory(artifactIdPath, new LinkOption[0])) continue;
                                Path propsPath = artifactIdPath.resolve("pom.properties");
                                if (!Files.exists(propsPath, new LinkOption[0])) continue;
                                Properties props = ModelUtils.loadPomProps(appJar, artifactIdPath);
                                AppArtifact appArtifact = new AppArtifact(props.getProperty("groupId"), props.getProperty("artifactId"), props.getProperty("version"));
                                appArtifact.setPath(appJar);
                                AppArtifact appArtifact2 = appArtifact;
                                return appArtifact2;
                            }
                        }
                        finally {
                            if (artifactIds == null) continue;
                            artifactIds.close();
                        }
                    }
                }
            }
            AppArtifact appArtifact = new AppArtifact("unknown", "unknown", "1.0-SNAPSHOT");
            appArtifact.setPath(appJar);
            AppArtifact appArtifact3 = appArtifact;
            return appArtifact3;
        }
    }

    public static Model readAppModel(Path appJar, AppArtifact appArtifact) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(appJar, (ClassLoader)null);){
            Path pomXml = fs.getPath("META-INF", "maven", appArtifact.getGroupId(), appArtifact.getArtifactId(), "pom.xml");
            if (!Files.exists(pomXml, new LinkOption[0])) {
                throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
            }
            Model model = ModelUtils.readModel(pomXml);
            return model;
        }
    }

    static Model readAppModel(Path appJar) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(appJar, (ClassLoader)null);){
            Path metaInfMaven = fs.getPath("META-INF", "maven");
            if (Files.exists(metaInfMaven, new LinkOption[0])) {
                try (DirectoryStream<Path> groupIds = Files.newDirectoryStream(metaInfMaven);){
                    for (Path groupIdPath : groupIds) {
                        if (!Files.isDirectory(groupIdPath, new LinkOption[0])) continue;
                        DirectoryStream<Path> artifactIds = Files.newDirectoryStream(groupIdPath);
                        try {
                            for (Path artifactIdPath : artifactIds) {
                                if (!Files.isDirectory(artifactIdPath, new LinkOption[0])) continue;
                                Path pomXml = artifactIdPath.resolve("pom.xml");
                                if (!Files.exists(pomXml, new LinkOption[0])) continue;
                                Model model = ModelUtils.readModel(pomXml);
                                return model;
                            }
                        }
                        finally {
                            if (artifactIds == null) continue;
                            artifactIds.close();
                        }
                    }
                }
            }
            throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.xml in " + appJar);
        }
    }

    public static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId != null) {
            return groupId;
        }
        Parent parent = model.getParent();
        if (parent != null && (groupId = parent.getGroupId()) != null) {
            return groupId;
        }
        throw new IllegalStateException("Failed to determine groupId for project model");
    }

    public static String getRawVersion(Model model) {
        String version = model.getVersion();
        if (version != null) {
            return version;
        }
        Parent parent = model.getParent();
        if (parent != null && (version = parent.getVersion()) != null) {
            return version;
        }
        throw new IllegalStateException("Failed to determine version for project model");
    }

    public static String getVersion(Model model) {
        String rawVersion = ModelUtils.getRawVersion(model);
        return ModelUtils.isUnresolvedVersion(rawVersion) ? ModelUtils.resolveVersion(rawVersion, model) : rawVersion;
    }

    public static boolean isUnresolvedVersion(String version) {
        return ModelUtils.getUnresolvedVersionPattern().matcher(version).find();
    }

    public static String resolveVersion(String rawVersion, Model rawModel) {
        HashMap<String, String> props = new HashMap<String, String>();
        ModelUtils.putAll(props, rawModel.getProperties());
        ModelUtils.putAll(props, System.getProperties());
        Matcher matcher = ModelUtils.getUnresolvedVersionPattern().matcher(rawVersion);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String resolved = (String)props.get(matcher.group(1));
            if (resolved == null) {
                return null;
            }
            matcher.appendReplacement(sb, resolved);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static void putAll(Map<String, String> map, Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            map.put(e.getKey().toString(), e.getValue().toString());
        }
    }

    public static Model applySystemProperties(Model model) {
        Properties props = model.getProperties();
        for (Map.Entry<Object, Object> prop : model.getProperties().entrySet()) {
            String systemValue = PropertyUtils.getProperty((String)prop.getKey().toString());
            if (systemValue == null) continue;
            props.put(prop.getKey(), systemValue);
        }
        return model;
    }

    private static Properties loadPomProps(Path appJar, Path artifactIdPath) throws IOException {
        Path propsPath = artifactIdPath.resolve("pom.properties");
        if (!Files.exists(propsPath, new LinkOption[0])) {
            throw new IOException("Failed to located META-INF/maven/<groupId>/<artifactId>/pom.properties in " + appJar);
        }
        Properties props = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(propsPath);){
            props.load(reader);
        }
        return props;
    }

    public static Model readModel(Path pomXml) throws IOException {
        return ModelUtils.readModel(Files.newInputStream(pomXml, new OpenOption[0]));
    }

    public static Model readModel(InputStream stream) throws IOException {
        Model model;
        block8: {
            InputStream is = stream;
            try {
                model = new MavenXpp3Reader().read(stream);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new IOException("Failed to parse POM", e);
                }
            }
            is.close();
        }
        return model;
    }

    public static void persistModel(Path pomFile, Model model) throws IOException {
        MavenXpp3Writer xpp3Writer = new MavenXpp3Writer();
        try (BufferedWriter pomFileWriter = Files.newBufferedWriter(pomFile, new OpenOption[0]);){
            xpp3Writer.write((Writer)pomFileWriter, model);
        }
    }
}

