/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.util.IoUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public class MavenLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepositoryManager delegate;
    private final Path secondaryRepo;
    private final Path originalRepo;

    public MavenLocalRepositoryManager(LocalRepositoryManager delegate, Path secondaryRepo) {
        this.delegate = delegate;
        this.secondaryRepo = secondaryRepo;
        this.originalRepo = delegate.getRepository().getBasedir().toPath();
    }

    public LocalRepository getRepository() {
        return this.delegate.getRepository();
    }

    public String getPathForLocalArtifact(Artifact artifact) {
        return this.delegate.getPathForLocalArtifact(artifact);
    }

    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.delegate.getPathForRemoteArtifact(artifact, repository, context);
    }

    public String getPathForLocalMetadata(Metadata metadata) {
        return this.delegate.getPathForLocalMetadata(metadata);
    }

    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.delegate.getPathForRemoteMetadata(metadata, repository, context);
    }

    public void relink(String groupId, String artifactId, String classifier, String type, String version, Path p) {
        Path creatorRepoPath = this.getLocalPath(this.originalRepo, groupId, artifactId, classifier, type, version);
        try {
            IoUtils.copy((Path)p, (Path)creatorRepoPath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copy " + p + " to a staging repo", e);
        }
    }

    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        LocalArtifactResult result = this.delegate.find(session, request);
        if (result.isAvailable()) {
            return result;
        }
        Artifact artifact = request.getArtifact();
        Path secondaryLocation = this.getLocalPath(this.secondaryRepo, artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion());
        if (!Files.exists(secondaryLocation, new LinkOption[0])) {
            return result;
        }
        result.setFile(secondaryLocation.toFile());
        artifact.setFile(result.getFile());
        result.setAvailable(true);
        return result;
    }

    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        this.delegate.add(session, request);
    }

    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        LocalMetadataResult result = this.delegate.find(session, request);
        if (result.getFile() != null && result.getFile().exists()) {
            return result;
        }
        Metadata metadata = request.getMetadata();
        Path userRepoPath = this.getMetadataPath(this.secondaryRepo, metadata.getGroupId(), metadata.getArtifactId(), metadata.getType(), metadata.getVersion());
        if (!Files.exists(userRepoPath, new LinkOption[0])) {
            return result;
        }
        result.setFile(userRepoPath.toFile());
        metadata.setFile(result.getFile());
        return result;
    }

    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        this.delegate.add(session, request);
    }

    private Path getMetadataPath(Path repoHome, String groupId, String artifactId, String type, String version) {
        String[] groupParts;
        Path p = repoHome;
        for (String part : groupParts = groupId.split("\\.")) {
            p = p.resolve(part);
        }
        if (artifactId != null) {
            p = p.resolve(artifactId);
        }
        if (version != null) {
            p = p.resolve(version);
        }
        return p.resolve("maven-metadata-local.xml");
    }

    private Path getLocalPath(Path repoHome, String groupId, String artifactId, String classifier, String type, String version) {
        String[] groupParts;
        Path p = repoHome;
        for (String part : groupParts = groupId.split("\\.")) {
            p = p.resolve(part);
        }
        StringBuilder fileName = new StringBuilder();
        fileName.append(artifactId).append('-').append(version);
        if (classifier != null && !classifier.isEmpty()) {
            fileName.append('-').append(classifier);
        }
        fileName.append('.').append(type);
        return p.resolve(artifactId).resolve(version).resolve(fileName.toString());
    }
}

