/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import java.util.Objects;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

final class DeploymentDependencySelector
implements DependencySelector {
    private final DependencySelector delegate;

    static DependencySelector ensureDeploymentDependencySelector(DependencySelector original) {
        return original.getClass() == DeploymentDependencySelector.class ? original : new DeploymentDependencySelector(original);
    }

    DeploymentDependencySelector(DependencySelector delegate) {
        this.delegate = delegate;
    }

    public boolean selectDependency(Dependency dependency) {
        return !dependency.isOptional() && this.delegate.selectDependency(dependency);
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        DependencySelector newDelegate = this.delegate.deriveChildSelector(context);
        return newDelegate == null ? null : DeploymentDependencySelector.ensureDeploymentDependencySelector(newDelegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentDependencySelector other = (DeploymentDependencySelector)obj;
        return Objects.equals(this.delegate, other.delegate);
    }
}

