/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersion;
import io.quarkus.bootstrap.resolver.maven.BootstrapArtifactVersionConstraint;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.DeploymentDependencySelector;
import io.quarkus.bootstrap.resolver.maven.DeploymentInjectionException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.util.DependencyNodeUtils;
import io.quarkus.bootstrap.workspace.ProcessedSources;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.jboss.logging.Logger;

public class DeploymentInjectingDependencyVisitor {
    private static final Logger log = Logger.getLogger(DeploymentInjectingDependencyVisitor.class);
    private static final String QUARKUS_RUNTIME_ARTIFACT = "quarkus.runtime";
    private static final String QUARKUS_EXTENSION_DEPENDENCY = "quarkus.ext";
    private static final Artifact[] NO_ARTIFACTS = new Artifact[0];
    private final MavenArtifactResolver resolver;
    private final List<Dependency> managedDeps;
    private final List<RemoteRepository> mainRepos;
    private final ApplicationModelBuilder appBuilder;
    private final boolean preferWorkspacePaths;
    private final boolean collectReloadableModules;
    private boolean collectingTopExtensionRuntimeNodes = true;
    private boolean collectingDirectDeps = true;
    private final List<ExtensionDependency> topExtensionDeps = new ArrayList<ExtensionDependency>();
    private ExtensionDependency lastVisitedRuntimeExtNode;
    private final Map<ArtifactKey, ExtensionInfo> allExtensions = new HashMap<ArtifactKey, ExtensionInfo>();
    private List<ConditionalDependency> conditionalDepsToProcess = new ArrayList<ConditionalDependency>();
    private final Deque<Collection<Exclusion>> exclusionStack = new ArrayDeque<Collection<Exclusion>>();
    public final Set<ArtifactKey> allRuntimeDeps = new HashSet<ArtifactKey>();

    public static Artifact getRuntimeArtifact(DependencyNode dep) {
        return (Artifact)dep.getData().get(QUARKUS_RUNTIME_ARTIFACT);
    }

    public DeploymentInjectingDependencyVisitor(MavenArtifactResolver resolver, List<Dependency> managedDeps, List<RemoteRepository> mainRepos, ApplicationModelBuilder appBuilder, boolean preferWorkspacePaths, boolean collectReloadableModules) throws BootstrapDependencyProcessingException {
        this.preferWorkspacePaths = preferWorkspacePaths;
        this.collectReloadableModules = collectReloadableModules;
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(resolver.getSession());
        session.setDependencySelector(DeploymentDependencySelector.ensureDeploymentDependencySelector(session.getDependencySelector()));
        try {
            this.resolver = new MavenArtifactResolver(new BootstrapMavenContext((BootstrapMavenContextConfig<?>)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)((BootstrapMavenContextConfig)BootstrapMavenContext.config().setRepositorySystem(resolver.getSystem())).setRepositorySystemSession((RepositorySystemSession)session)).setRemoteRepositories(resolver.getRepositories())).setRemoteRepositoryManager(resolver.getRemoteRepositoryManager())).setCurrentProject(resolver.getMavenContext().getCurrentProject())).setWorkspaceDiscovery(false)));
        }
        catch (BootstrapMavenException e) {
            throw new BootstrapDependencyProcessingException("Failed to initialize deployment dependencies resolver", (Throwable)((Object)e));
        }
        this.managedDeps = managedDeps.isEmpty() ? new ArrayList() : managedDeps;
        this.mainRepos = mainRepos;
        this.appBuilder = appBuilder;
    }

    public boolean isInjectedDeps() {
        return !this.topExtensionDeps.isEmpty();
    }

    public void injectDeploymentDependencies(DependencyNode root) throws BootstrapDependencyProcessingException {
        this.visitRuntimeDependencies(root.getChildren());
        List<ConditionalDependency> activatedConditionalDeps = Collections.emptyList();
        if (!this.conditionalDepsToProcess.isEmpty()) {
            activatedConditionalDeps = new ArrayList<ConditionalDependency>();
            List<ConditionalDependency> unsatisfiedConditionalDeps = new ArrayList<ConditionalDependency>();
            while (!this.conditionalDepsToProcess.isEmpty()) {
                ArrayList<ConditionalDependency> tmp = unsatisfiedConditionalDeps;
                unsatisfiedConditionalDeps = this.conditionalDepsToProcess;
                this.conditionalDepsToProcess = tmp;
                int totalConditionsToProcess = unsatisfiedConditionalDeps.size();
                Iterator<ConditionalDependency> i = unsatisfiedConditionalDeps.iterator();
                while (i.hasNext()) {
                    ConditionalDependency cd = i.next();
                    boolean satisfied = cd.isSatisfied();
                    if (!satisfied) continue;
                    i.remove();
                    cd.activate();
                    activatedConditionalDeps.add(cd);
                }
                if (totalConditionsToProcess == unsatisfiedConditionalDeps.size()) break;
                this.conditionalDepsToProcess.addAll(unsatisfiedConditionalDeps);
                unsatisfiedConditionalDeps.clear();
            }
        }
        for (ExtensionDependency extDep : this.topExtensionDeps) {
            this.injectDeploymentDependencies(extDep);
        }
        if (!activatedConditionalDeps.isEmpty()) {
            for (ConditionalDependency cd : activatedConditionalDeps) {
                this.injectDeploymentDependencies(cd.getExtensionDependency());
            }
        }
    }

    private boolean isRuntimeArtifact(ArtifactKey key) {
        return this.allRuntimeDeps.contains(key);
    }

    private void visitRuntimeDependencies(List<DependencyNode> list) {
        int i = 0;
        while (i < list.size()) {
            this.visitRuntimeDependency(list.get(i++));
        }
    }

    private void visitRuntimeDependency(DependencyNode node) {
        Artifact artifact;
        boolean add;
        boolean prevCollectingDirectDeps = this.collectingDirectDeps;
        boolean prevCollectingTopExtRtNodes = this.collectingTopExtensionRuntimeNodes;
        ExtensionDependency prevLastVisitedRtExtNode = this.lastVisitedRuntimeExtNode;
        boolean popExclusions = !node.getDependency().getExclusions().isEmpty();
        if (popExclusions) {
            this.exclusionStack.addLast(node.getDependency().getExclusions());
        }
        if (add = this.allRuntimeDeps.add((ArtifactKey)DeploymentInjectingDependencyVisitor.getKey(artifact = node.getArtifact()))) {
            artifact = this.resolve(artifact);
        }
        try {
            ExtensionDependency extDep = this.getExtensionDependencyOrNull(node, artifact);
            if (add) {
                WorkspaceModule module = null;
                if (this.resolver.getProjectModuleResolver() != null) {
                    module = this.resolver.getProjectModuleResolver().getProjectModule(artifact.getGroupId(), artifact.getArtifactId());
                }
                ResolvedDependencyBuilder newRtDep = (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)DeploymentInjectingDependencyVisitor.toAppArtifact(artifact, module, this.preferWorkspacePaths && extDep == null && this.collectingTopExtensionRuntimeNodes).setRuntimeCp()).setDeploymentCp()).setOptional(node.getDependency().isOptional())).setScope(node.getDependency().getScope())).setDirect(this.collectingDirectDeps);
                if (module != null) {
                    ((ResolvedDependencyBuilder)newRtDep.setWorkspaceModule()).setReloadable();
                    if (this.collectReloadableModules) {
                        this.appBuilder.addReloadableWorkspaceModule((ArtifactKey)new GACT(artifact.getGroupId(), artifact.getArtifactId()));
                    }
                }
                if (extDep != null) {
                    newRtDep.setRuntimeExtensionArtifact();
                }
                this.appBuilder.addDependency(newRtDep.build());
            }
            this.collectingDirectDeps = false;
            if (extDep != null) {
                extDep.info.ensureActivated();
                this.visitExtensionDependency(extDep);
            }
            this.visitRuntimeDependencies(node.getChildren());
        }
        catch (DeploymentInjectionException e) {
            throw e;
        }
        catch (Exception t) {
            throw new DeploymentInjectionException("Failed to inject extension deployment dependencies", t);
        }
        if (popExclusions) {
            this.exclusionStack.pollLast();
        }
        this.collectingDirectDeps = prevCollectingDirectDeps;
        this.collectingTopExtensionRuntimeNodes = prevCollectingTopExtRtNodes;
        this.lastVisitedRuntimeExtNode = prevLastVisitedRtExtNode;
    }

    private ExtensionDependency getExtensionDependencyOrNull(DependencyNode node, Artifact artifact) throws BootstrapDependencyProcessingException {
        ExtensionDependency extDep = ExtensionDependency.get(node);
        if (extDep != null) {
            return extDep;
        }
        ExtensionInfo extInfo = this.getExtensionInfoOrNull(artifact);
        if (extInfo != null) {
            Collection<Exclusion> exclusions;
            if (!this.exclusionStack.isEmpty()) {
                if (this.exclusionStack.size() == 1) {
                    exclusions = this.exclusionStack.peekLast();
                } else {
                    exclusions = new ArrayList<Exclusion>();
                    for (Collection<Exclusion> set : this.exclusionStack) {
                        exclusions.addAll(set);
                    }
                }
            } else {
                exclusions = Collections.emptyList();
            }
            return new ExtensionDependency(extInfo, node, exclusions);
        }
        return null;
    }

    private void visitExtensionDependency(ExtensionDependency extDep) throws BootstrapDependencyProcessingException {
        this.managedDeps.add(new Dependency(extDep.info.deploymentArtifact, "compile"));
        this.collectConditionalDependencies(extDep);
        if (this.collectingTopExtensionRuntimeNodes) {
            this.collectingTopExtensionRuntimeNodes = false;
            this.topExtensionDeps.add(extDep);
        }
        if (this.lastVisitedRuntimeExtNode != null) {
            this.lastVisitedRuntimeExtNode.addExtensionDependency(extDep);
        }
        this.lastVisitedRuntimeExtNode = extDep;
    }

    private void collectConditionalDependencies(ExtensionDependency dependent) throws BootstrapDependencyProcessingException {
        if (dependent.info.conditionalDeps.length == 0 || dependent.conditionalDepsQueued) {
            return;
        }
        dependent.conditionalDepsQueued = true;
        ExclusionDependencySelector selector = dependent.exclusions == null ? null : new ExclusionDependencySelector(dependent.exclusions);
        for (Artifact conditionalArtifact : dependent.info.conditionalDeps) {
            if (selector != null && !selector.selectDependency(new Dependency(conditionalArtifact, "runtime"))) continue;
            ExtensionInfo conditionalInfo = this.getExtensionInfoOrNull(conditionalArtifact);
            ConditionalDependency conditionalDep = new ConditionalDependency(conditionalInfo, dependent);
            this.conditionalDepsToProcess.add(conditionalDep);
            this.collectConditionalDependencies(conditionalDep.getExtensionDependency());
        }
    }

    private ExtensionInfo getExtensionInfoOrNull(Artifact artifact) throws BootstrapDependencyProcessingException {
        if (!artifact.getExtension().equals("jar")) {
            return null;
        }
        GACT extKey = DeploymentInjectingDependencyVisitor.getKey(artifact);
        ExtensionInfo ext = this.allExtensions.get(extKey);
        if (ext != null) {
            return ext;
        }
        Path path = (artifact = this.resolve(artifact)).getFile().toPath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            ext = this.createExtensionInfoOrNull(artifact, path.resolve("META-INF/quarkus-extension.properties"));
        } else {
            try (FileSystem artifactFs = ZipUtils.newFileSystem((Path)path);){
                ext = this.createExtensionInfoOrNull(artifact, artifactFs.getPath("META-INF/quarkus-extension.properties", new String[0]));
            }
            catch (IOException e) {
                throw new DeploymentInjectionException("Failed to read " + path, e);
            }
        }
        this.allExtensions.put((ArtifactKey)extKey, ext);
        return ext;
    }

    private ExtensionInfo createExtensionInfoOrNull(Artifact artifact, Path descriptor) throws BootstrapDependencyProcessingException {
        Properties rtProps = DeploymentInjectingDependencyVisitor.readDescriptor(descriptor);
        if (rtProps == null) {
            return null;
        }
        return new ExtensionInfo(artifact, rtProps);
    }

    private void injectDeploymentDependencies(ExtensionDependency extDep) throws BootstrapDependencyProcessingException {
        List deploymentDeps;
        log.debugf("Injecting deployment dependency %s", (Object)extDep.info.deploymentArtifact);
        DependencyNode deploymentNode = this.collectDependencies(extDep.info.deploymentArtifact, extDep.exclusions);
        if (this.resolver.getProjectModuleResolver() != null) {
            this.clearReloadable(deploymentNode);
        }
        if (!this.replaceDirectDepBranch(extDep, deploymentDeps = deploymentNode.getChildren())) {
            throw new BootstrapDependencyProcessingException("Quarkus extension deployment artifact " + deploymentNode.getArtifact() + " does not appear to depend on the corresponding runtime artifact " + extDep.info.runtimeArtifact);
        }
        DependencyNode runtimeNode = extDep.runtimeNode;
        runtimeNode.setData((Object)QUARKUS_RUNTIME_ARTIFACT, (Object)runtimeNode.getArtifact());
        runtimeNode.setArtifact(deploymentNode.getArtifact());
        runtimeNode.getDependency().setArtifact(deploymentNode.getArtifact());
        runtimeNode.setChildren(deploymentDeps);
    }

    private void clearReloadable(DependencyNode node) {
        for (DependencyNode child : node.getChildren()) {
            this.clearReloadable(child);
        }
        io.quarkus.maven.dependency.Dependency dep = this.appBuilder.getDependency((ArtifactKey)DeploymentInjectingDependencyVisitor.getKey(node.getArtifact()));
        if (dep != null && dep.isWorkspacetModule()) {
            ((ArtifactDependency)dep).clearFlag(64);
        }
    }

    private boolean replaceDirectDepBranch(ExtensionDependency extDep, List<DependencyNode> deploymentDeps) throws BootstrapDependencyProcessingException {
        int i = 0;
        DefaultDependencyNode inserted = null;
        while (i < deploymentDeps.size()) {
            Artifact a = deploymentDeps.get(i).getArtifact();
            if (a == null) continue;
            if (DeploymentInjectingDependencyVisitor.isSameKey(extDep.info.runtimeArtifact, a)) {
                inserted = new DefaultDependencyNode(extDep.runtimeNode);
                inserted.setChildren(extDep.runtimeNode.getChildren());
                deploymentDeps.set(i, (DependencyNode)inserted);
                break;
            }
            ++i;
        }
        if (inserted == null) {
            return false;
        }
        if (extDep.runtimeExtensionDeps != null) {
            for (ExtensionDependency dep : extDep.runtimeExtensionDeps) {
                for (DependencyNode deploymentDep : deploymentDeps) {
                    if (deploymentDep != inserted && this.replaceRuntimeBranch(dep, deploymentDep.getChildren())) break;
                }
            }
        }
        return true;
    }

    private boolean replaceRuntimeBranch(ExtensionDependency extNode, List<DependencyNode> deploymentNodes) throws BootstrapDependencyProcessingException {
        if (this.replaceDirectDepBranch(extNode, deploymentNodes)) {
            return true;
        }
        for (DependencyNode deploymentNode : deploymentNodes) {
            if (!this.replaceRuntimeBranch(extNode, deploymentNode.getChildren())) continue;
            return true;
        }
        return false;
    }

    private DependencyNode collectDependencies(Artifact artifact, Collection<Exclusion> exclusions) throws BootstrapDependencyProcessingException {
        try {
            return this.managedDeps.isEmpty() ? this.resolver.collectDependencies(artifact, Collections.emptyList(), this.mainRepos, exclusions).getRoot() : this.resolver.collectManagedDependencies(artifact, Collections.emptyList(), this.managedDeps, this.mainRepos, exclusions, "test", "provided").getRoot();
        }
        catch (AppModelResolverException e) {
            throw new DeploymentInjectionException(e);
        }
    }

    private Artifact resolve(Artifact artifact) {
        if (artifact.getFile() != null) {
            return artifact;
        }
        try {
            return this.resolver.resolve(artifact).getArtifact();
        }
        catch (AppModelResolverException e) {
            throw new DeploymentInjectionException(e);
        }
    }

    private static Properties readDescriptor(Path path) throws BootstrapDependencyProcessingException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        Properties rtProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            rtProps.load(reader);
        }
        catch (IOException e) {
            throw new BootstrapDependencyProcessingException("Failed to load " + path, e);
        }
        return rtProps;
    }

    private static boolean isSameKey(Artifact a1, Artifact a2) {
        return a2.getArtifactId().equals(a1.getArtifactId()) && a2.getGroupId().equals(a1.getGroupId()) && a2.getClassifier().equals(a1.getClassifier()) && a2.getExtension().equals(a1.getExtension());
    }

    public static GACT getKey(Artifact a) {
        return new GACT(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension());
    }

    public static ResolvedDependencyBuilder toAppArtifact(Artifact artifact, WorkspaceModule module, boolean preferWorkspacePaths) {
        return ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setWorkspaceModule(module).setGroupId(artifact.getGroupId())).setArtifactId(artifact.getArtifactId())).setClassifier(artifact.getClassifier())).setType(artifact.getExtension())).setVersion(artifact.getVersion())).setResolvedPaths(DeploymentInjectingDependencyVisitor.getResolvedPaths(artifact, module, preferWorkspacePaths));
    }

    public static PathCollection getResolvedPaths(Artifact artifact, WorkspaceModule module, boolean preferWorkspacePaths) {
        if (preferWorkspacePaths && module != null) {
            PathList.Builder pathBuilder = PathList.builder();
            if ("tests".equals(artifact.getClassifier())) {
                DeploymentInjectingDependencyVisitor.collectResolvedPaths(pathBuilder, module.getTestSources());
                DeploymentInjectingDependencyVisitor.collectResolvedPaths(pathBuilder, module.getTestResources());
            } else {
                DeploymentInjectingDependencyVisitor.collectResolvedPaths(pathBuilder, module.getMainSources());
                DeploymentInjectingDependencyVisitor.collectResolvedPaths(pathBuilder, module.getMainResources());
            }
            if (!pathBuilder.isEmpty()) {
                return pathBuilder.build();
            }
        }
        return artifact.getFile() == null ? PathList.empty() : PathList.of((Path[])new Path[]{artifact.getFile().toPath()});
    }

    private static void collectResolvedPaths(PathList.Builder pathBuilder, Collection<ProcessedSources> srcs) {
        for (ProcessedSources src : srcs) {
            Path p;
            if (!src.getDestinationDir().exists() || pathBuilder.contains(p = src.getDestinationDir().toPath())) continue;
            pathBuilder.add(p);
        }
    }

    private static String toGactv(Artifact a) {
        return a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getClassifier() + ":" + a.getExtension() + ":" + a.getVersion();
    }

    private class ConditionalDependency {
        final ExtensionInfo info;
        final ExtensionDependency dependent;
        private ExtensionDependency dependency;
        private boolean activated;

        private ConditionalDependency(ExtensionInfo info, ExtensionDependency dependent) {
            this.info = Objects.requireNonNull(info, "Extension info is null");
            this.dependent = dependent;
        }

        ExtensionDependency getExtensionDependency() {
            if (this.dependency == null) {
                DefaultDependencyNode rtNode = new DefaultDependencyNode(new Dependency(this.info.runtimeArtifact, "runtime"));
                rtNode.setVersion((Version)new BootstrapArtifactVersion(this.info.runtimeArtifact.getVersion()));
                rtNode.setVersionConstraint((VersionConstraint)new BootstrapArtifactVersionConstraint(new BootstrapArtifactVersion(this.info.runtimeArtifact.getVersion())));
                this.dependency = new ExtensionDependency(this.info, (DependencyNode)rtNode, this.dependent.exclusions);
            }
            return this.dependency;
        }

        void activate() throws BootstrapDependencyProcessingException {
            if (this.activated) {
                return;
            }
            this.activated = true;
            DeploymentInjectingDependencyVisitor.this.collectingTopExtensionRuntimeNodes = false;
            ExtensionDependency extDep = this.getExtensionDependency();
            DependencyNode originalNode = DeploymentInjectingDependencyVisitor.this.collectDependencies(this.info.runtimeArtifact, extDep.exclusions);
            DefaultDependencyNode rtNode = (DefaultDependencyNode)extDep.runtimeNode;
            rtNode.setRepositories(originalNode.getRepositories());
            List currentChildren = rtNode.getChildren();
            if (currentChildren == null || currentChildren.isEmpty()) {
                rtNode.setChildren(originalNode.getChildren());
            } else {
                currentChildren.addAll(originalNode.getChildren());
            }
            DeploymentInjectingDependencyVisitor.this.visitRuntimeDependency((DependencyNode)rtNode);
            this.dependent.runtimeNode.getChildren().add(rtNode);
        }

        boolean isSatisfied() throws BootstrapDependencyProcessingException {
            if (this.info.dependencyCondition == null) {
                return true;
            }
            for (ArtifactKey key : this.info.dependencyCondition) {
                if (DeploymentInjectingDependencyVisitor.this.isRuntimeArtifact(key)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExtensionDependency {
        final ExtensionInfo info;
        final DependencyNode runtimeNode;
        final Collection<Exclusion> exclusions;
        boolean conditionalDepsQueued;
        private List<ExtensionDependency> runtimeExtensionDeps;

        static ExtensionDependency get(DependencyNode node) {
            return (ExtensionDependency)node.getData().get(DeploymentInjectingDependencyVisitor.QUARKUS_EXTENSION_DEPENDENCY);
        }

        ExtensionDependency(ExtensionInfo info, DependencyNode node, Collection<Exclusion> exclusions) {
            this.runtimeNode = node;
            this.info = info;
            this.exclusions = exclusions;
            Map data = node.getData();
            if (data.isEmpty()) {
                node.setData((Object)DeploymentInjectingDependencyVisitor.QUARKUS_EXTENSION_DEPENDENCY, (Object)this);
            } else if (data.put(DeploymentInjectingDependencyVisitor.QUARKUS_EXTENSION_DEPENDENCY, this) != null) {
                throw new IllegalStateException("Dependency node " + node + " has already been associated with an extension dependency");
            }
        }

        void addExtensionDependency(ExtensionDependency dep) {
            if (this.runtimeExtensionDeps == null) {
                this.runtimeExtensionDeps = new ArrayList<ExtensionDependency>();
            }
            this.runtimeExtensionDeps.add(dep);
        }
    }

    private class ExtensionInfo {
        final Artifact runtimeArtifact;
        final Properties props;
        final Artifact deploymentArtifact;
        final Artifact[] conditionalDeps;
        final ArtifactKey[] dependencyCondition;
        boolean activated;

        ExtensionInfo(Artifact runtimeArtifact, Properties props) throws BootstrapDependencyProcessingException {
            this.runtimeArtifact = runtimeArtifact;
            this.props = props;
            String value = props.getProperty("deployment-artifact");
            if (value == null) {
                throw new BootstrapDependencyProcessingException("Extension descriptor from " + runtimeArtifact + " does not include deployment-artifact");
            }
            Artifact deploymentArtifact = DependencyNodeUtils.toArtifact(value);
            if (deploymentArtifact.getVersion() == null || deploymentArtifact.getVersion().isEmpty()) {
                deploymentArtifact = deploymentArtifact.setVersion(runtimeArtifact.getVersion());
            }
            this.deploymentArtifact = deploymentArtifact;
            value = props.getProperty("conditional-dependencies");
            if (value != null) {
                String[] deps = BootstrapUtils.splitByWhitespace((String)value);
                this.conditionalDeps = new Artifact[deps.length];
                for (int i = 0; i < deps.length; ++i) {
                    try {
                        this.conditionalDeps[i] = DependencyNodeUtils.toArtifact(deps[i]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BootstrapDependencyProcessingException("Failed to parse conditional dependencies configuration of " + runtimeArtifact, e);
                    }
                }
            } else {
                this.conditionalDeps = NO_ARTIFACTS;
            }
            this.dependencyCondition = BootstrapUtils.parseDependencyCondition((String)props.getProperty("dependency-condition"));
        }

        void ensureActivated() {
            if (this.activated) {
                return;
            }
            this.activated = true;
            DeploymentInjectingDependencyVisitor.this.appBuilder.handleExtensionProperties(this.props, this.runtimeArtifact.toString());
            String providesCapabilities = this.props.getProperty("provides-capabilities");
            if (providesCapabilities != null) {
                DeploymentInjectingDependencyVisitor.this.appBuilder.addExtensionCapabilities((ExtensionCapabilities)CapabilityContract.providesCapabilities((String)DeploymentInjectingDependencyVisitor.toGactv(this.runtimeArtifact), (String)providesCapabilities));
            }
        }
    }
}

