/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

public class BootstrapModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final String context;
    private List<RemoteRepository> repositories;
    private final List<RemoteRepository> externalRepositories;
    private final ArtifactResolver resolver;
    private final VersionRangeResolver versionRangeResolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;

    public static BootstrapModelResolver newInstance(BootstrapMavenContext ctx, WorkspaceReader workspace) throws BootstrapMavenException {
        final RepositorySystem repoSystem = ctx.getRepositorySystem();
        RepositorySystemSession session = workspace == null ? ctx.getRepositorySystemSession() : new DefaultRepositorySystemSession(ctx.getRepositorySystemSession()).setWorkspaceReader(workspace);
        return new BootstrapModelResolver(session, null, null, new ArtifactResolver(){

            public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
                return repoSystem.resolveArtifact(session, request);
            }

            public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
                return repoSystem.resolveArtifacts(session, requests);
            }
        }, (arg_0, arg_1) -> ((RepositorySystem)repoSystem).resolveVersionRange(arg_0, arg_1), ctx.getRemoteRepositoryManager(), ctx.getRemoteRepositories());
    }

    BootstrapModelResolver(RepositorySystemSession session, RequestTrace trace, String context, ArtifactResolver resolver, VersionRangeResolver versionRangeResolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories) {
        this.session = session;
        this.trace = trace;
        this.context = context;
        this.resolver = resolver;
        this.versionRangeResolver = versionRangeResolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.repositories = repositories;
        this.externalRepositories = List.copyOf(repositories);
        this.repositoryIds = new HashSet<String>();
    }

    private BootstrapModelResolver(BootstrapModelResolver original) {
        this.session = original.session;
        this.trace = original.trace;
        this.context = original.context;
        this.resolver = original.resolver;
        this.versionRangeResolver = original.versionRangeResolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.repositories = new ArrayList<RemoteRepository>(original.repositories);
        this.externalRepositories = original.externalRepositories;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        if (this.session.isIgnoreArtifactDescriptorRepositories()) {
            return;
        }
        if (!this.repositoryIds.add(repository.getId())) {
            if (!replace) {
                return;
            }
            BootstrapModelResolver.removeMatchingRepository(this.repositories, repository.getId());
        }
        this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, List.of(ArtifactDescriptorUtils.toRemoteRepository((Repository)repository)), true);
    }

    private static void removeMatchingRepository(Iterable<RemoteRepository> repositories, String id) {
        Iterator<RemoteRepository> iterator = repositories.iterator();
        while (iterator.hasNext()) {
            RemoteRepository remoteRepository = iterator.next();
            if (!remoteRepository.getId().equals(id)) continue;
            iterator.remove();
        }
    }

    public ModelResolver newCopy() {
        return new BootstrapModelResolver(this);
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest((Artifact)pomArtifact, this.repositories, this.context);
            request.setTrace(this.trace);
            pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
        return new FileModelSource(pomArtifact.getFile());
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "", "pom", parent.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, this.repositories, this.context);
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.versionRangeResolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested parent version range '%s'", parent.getVersion()), parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested parent version range '%s' does not specify an upper bound", parent.getVersion()), parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            parent.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), (Throwable)e);
        }
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "", "pom", dependency.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, this.repositories, this.context);
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.versionRangeResolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested dependency version range '%s'", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested dependency version range '%s' does not specify an upper bound", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            dependency.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), (Throwable)e);
        }
    }
}

