/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.EffectiveModelResolver;
import io.quarkus.bootstrap.resolver.maven.LocalRepoModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenLocalPomResolver;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.resolution.ModelResolver;
import org.eclipse.aether.repository.RemoteRepository;

class LocalRepositoryEffectiveModelResolver
implements EffectiveModelResolver {
    private final LocalRepoModelResolver modelResolver;

    LocalRepositoryEffectiveModelResolver(File localRepoDir) {
        this.modelResolver = LocalRepoModelResolver.of(new MavenLocalPomResolver(localRepoDir));
    }

    @Override
    public Model resolveEffectiveModel(ArtifactCoords coords) {
        return this.resolveEffectiveModel(coords, List.of());
    }

    @Override
    public Model resolveEffectiveModel(ArtifactCoords coords, List<RemoteRepository> repos) {
        File pom = this.modelResolver.resolvePom(coords.getGroupId(), coords.getArtifactId(), coords.getVersion());
        if (pom == null) {
            return null;
        }
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setModelResolver((ModelResolver)this.modelResolver);
        req.setPomFile(pom);
        req.getSystemProperties().putAll((Map<?, ?>)System.getProperties());
        req.setValidationLevel(0);
        DefaultModelBuilderFactory factory = new DefaultModelBuilderFactory();
        DefaultModelBuilder builder = factory.newInstance();
        try {
            return builder.build((ModelBuildingRequest)req).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new RuntimeException("An error occurred attempting to resolve effective POM", e);
        }
    }
}

