/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.util;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public class DependencyUtils {
    public static ArtifactKey getKey(Artifact artifact) {
        return ArtifactKey.of((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier(), (String)artifact.getExtension());
    }

    public static ArtifactCoords getCoords(Artifact artifact) {
        return new GACTV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion());
    }

    public static List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive, Map<ArtifactKey, String> managedVersions, Set<String> excludedScopes) {
        int initialCapacity = dominant.size() + recessive.size();
        if (initialCapacity == 0) {
            return List.of();
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>(initialCapacity);
        HashSet<ArtifactKey> ids = new HashSet<ArtifactKey>(initialCapacity, 1.0f);
        for (Dependency dependency : dominant) {
            if (excludedScopes.contains(dependency.getScope())) continue;
            ids.add(DependencyUtils.getKey(dependency.getArtifact()));
            result.add(dependency);
        }
        for (Dependency dependency : recessive) {
            ArtifactKey id;
            if (excludedScopes.contains(dependency.getScope()) || ids.contains(id = DependencyUtils.getKey(dependency.getArtifact()))) continue;
            String managedVersion = managedVersions.get(id);
            if (managedVersion != null) {
                dependency = dependency.setArtifact(dependency.getArtifact().setVersion(managedVersion));
            }
            result.add(dependency);
        }
        return result;
    }

    public static Artifact toArtifact(String str) {
        String artifactId;
        String classifier = "";
        String type = "jar";
        String version = null;
        int offset = 0;
        int colon = str.indexOf(58, offset);
        int length = str.length();
        if (colon < offset + 1 || colon == length - 1) {
            DependencyUtils.illegalDependencyFormat(str);
        }
        String groupId = str.substring(offset, colon);
        offset = colon + 1;
        if ((colon = str.indexOf(58, offset)) < 0) {
            artifactId = str.substring(offset, length);
        } else {
            if (colon == length - 1) {
                DependencyUtils.illegalDependencyFormat(str);
            }
            artifactId = str.substring(offset, colon);
            offset = colon + 1;
            if ((colon = str.indexOf(58, offset)) < 0) {
                version = str.substring(offset, length);
            } else {
                if (colon == length - 1) {
                    DependencyUtils.illegalDependencyFormat(str);
                }
                type = str.substring(offset, colon);
                offset = colon + 1;
                if ((colon = str.indexOf(58, offset)) < 0) {
                    version = str.substring(offset, length);
                } else {
                    if (colon == length - 1) {
                        DependencyUtils.illegalDependencyFormat(str);
                    }
                    classifier = type;
                    type = str.substring(offset, colon);
                    version = str.substring(colon + 1);
                }
            }
        }
        return new DefaultArtifact(groupId, artifactId, classifier, type, version);
    }

    private static void illegalDependencyFormat(String str) {
        throw new IllegalArgumentException("Bad artifact coordinates " + str + ", expected format is <groupId>:<artifactId>[:<extension>|[:<classifier>:<extension>]]:<version>");
    }

    public static ResolvedDependencyBuilder newDependencyBuilder(DependencyNode node, MavenArtifactResolver resolver) throws BootstrapMavenException {
        Artifact artifact = node.getDependency().getArtifact();
        if (artifact.getFile() == null) {
            artifact = resolver.resolve(artifact, node.getRepositories()).getArtifact();
        }
        int flags = 0;
        if (node.getDependency().isOptional()) {
            flags |= 1;
        }
        WorkspaceModule module = null;
        if (resolver.getProjectModuleResolver() != null && (module = resolver.getProjectModuleResolver().getProjectModule(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion())) != null) {
            flags |= 0x20;
        }
        return (ResolvedDependencyBuilder)((ResolvedDependencyBuilder)DependencyUtils.toAppArtifact(artifact, module).setScope(node.getDependency().getScope())).setFlags(flags);
    }

    public static ResolvedDependencyBuilder toAppArtifact(Artifact artifact, WorkspaceModule module) {
        return ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setWorkspaceModule(module).setGroupId(artifact.getGroupId())).setArtifactId(artifact.getArtifactId())).setClassifier(artifact.getClassifier())).setType(artifact.getExtension())).setVersion(artifact.getVersion())).setResolvedPaths((PathCollection)(artifact.getFile() == null ? PathList.empty() : PathList.of((Path[])new Path[]{artifact.getFile().toPath()})));
    }
}

