/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.BootstrapDependencyProcessingException;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.ApplicationDependencyTreeResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvableDependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.version.Version;

public class BootstrapAppModelResolver
implements AppModelResolver {
    protected final MavenArtifactResolver mvn;
    protected Consumer<String> buildTreeConsumer;
    protected boolean devmode;
    protected boolean test;
    private boolean collectReloadableDeps = true;

    public BootstrapAppModelResolver(MavenArtifactResolver mvn) {
        this.mvn = mvn;
    }

    public void setBuildTreeLogger(Consumer<String> buildTreeConsumer) {
        this.buildTreeConsumer = buildTreeConsumer;
    }

    public BootstrapAppModelResolver setDevMode(boolean devmode) {
        this.devmode = devmode;
        return this;
    }

    public BootstrapAppModelResolver setTest(boolean test) {
        this.test = test;
        return this;
    }

    public BootstrapAppModelResolver setCollectReloadableDependencies(boolean collectReloadableDeps) {
        this.collectReloadableDeps = collectReloadableDeps;
        return this;
    }

    public void addRemoteRepositories(List<RemoteRepository> repos) {
        this.mvn.addRemoteRepositories(repos);
    }

    public void relink(ArtifactCoords artifact, Path path) throws AppModelResolverException {
        if (this.mvn.getLocalRepositoryManager() == null) {
            return;
        }
        this.mvn.getLocalRepositoryManager().relink(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), path);
        if (artifact instanceof ResolvableDependency) {
            ((ResolvableDependency)artifact).setResolvedPaths((PathCollection)PathList.of((Path[])new Path[]{path}));
        }
    }

    public ResolvedDependency resolve(ArtifactCoords artifact) throws AppModelResolverException {
        return this.resolve(artifact, BootstrapAppModelResolver.toAetherArtifact(artifact), this.mvn.getRepositories());
    }

    public Collection<ResolvedDependency> resolveUserDependencies(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> deps) throws AppModelResolverException {
        List<Dependency> mvnDeps;
        if (deps.isEmpty()) {
            mvnDeps = List.of();
        } else {
            mvnDeps = new ArrayList(deps.size());
            for (io.quarkus.maven.dependency.Dependency dep : deps) {
                mvnDeps.add(new Dependency(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)dep), dep.getScope()));
            }
        }
        final ArrayList<ResolvedDependency> result = new ArrayList<ResolvedDependency>();
        TreeDependencyVisitor visitor = new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                Dependency dep = node.getDependency();
                if (dep != null) {
                    result.add(((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)DependencyUtils.toAppArtifact(dep.getArtifact(), null).setScope(dep.getScope())).setOptional(dep.isOptional())).build());
                }
                return true;
            }
        });
        this.mvn.resolveDependencies(BootstrapAppModelResolver.toAetherArtifact(appArtifact), mvnDeps).getRoot().accept((DependencyVisitor)visitor);
        return result;
    }

    public ApplicationModel resolveModel(ArtifactCoords appArtifact) throws AppModelResolverException {
        return this.resolveManagedModel(appArtifact, List.of(), null, Set.of());
    }

    public ApplicationModel resolveModel(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> directDeps) throws AppModelResolverException {
        return this.resolveManagedModel(appArtifact, directDeps, null, Set.of());
    }

    public ApplicationModel resolveManagedModel(ArtifactCoords appArtifact, Collection<io.quarkus.maven.dependency.Dependency> directDeps, ArtifactCoords managingProject, Set<ArtifactKey> reloadableModules) throws AppModelResolverException {
        return this.doResolveModel(appArtifact, BootstrapAppModelResolver.toAetherDeps(directDeps), managingProject, reloadableModules);
    }

    public ApplicationModel resolveModel(WorkspaceModule module) throws AppModelResolverException {
        PathList.Builder resolvedPaths = PathList.builder();
        if (module.hasMainSources()) {
            if (!module.getMainSources().isOutputAvailable()) {
                throw new AppModelResolverException("The application module hasn't been built yet");
            }
            module.getMainSources().getSourceDirs().forEach(s -> {
                if (!resolvedPaths.contains(s.getOutputDir())) {
                    resolvedPaths.add(s.getOutputDir());
                }
            });
            module.getMainSources().getResourceDirs().forEach(s -> {
                if (!resolvedPaths.contains(s.getOutputDir())) {
                    resolvedPaths.add(s.getOutputDir());
                }
            });
        }
        DefaultArtifact mainArtifact = new DefaultArtifact(module.getId().getGroupId(), module.getId().getArtifactId(), null, "jar", module.getId().getVersion());
        ResolvedDependency mainDep = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(mainArtifact.getGroupId())).setArtifactId(mainArtifact.getArtifactId())).setClassifier(mainArtifact.getClassifier())).setType(mainArtifact.getExtension())).setVersion(mainArtifact.getVersion())).setResolvedPaths((PathCollection)resolvedPaths.build()).setWorkspaceModule(module).build();
        HashMap<ArtifactKey, Dependency> managedMap = new HashMap<ArtifactKey, Dependency>();
        for (Object d : module.getDirectDependencyConstraints()) {
            if ("import".equals(d.getScope())) {
                this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)d)).getManagedDependencies().forEach(dep -> managedMap.putIfAbsent(DependencyUtils.getKey(dep.getArtifact()), (Dependency)dep));
                continue;
            }
            managedMap.put(d.getKey(), new Dependency(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)d), d.getScope(), Boolean.valueOf(d.isOptional()), BootstrapAppModelResolver.toAetherExclusions(d.getExclusions())));
        }
        ArrayList<Dependency> directDeps = new ArrayList<Dependency>(module.getDirectDependencies().size());
        for (io.quarkus.maven.dependency.Dependency d : module.getDirectDependencies()) {
            String version = d.getVersion();
            if (version == null) {
                Dependency constraint = (Dependency)managedMap.get(d.getKey());
                if (constraint == null) {
                    throw new AppModelResolverException(d.toCompactCoords() + " is missing version and is not found among the dependency constraints");
                }
                version = constraint.getArtifact().getVersion();
            }
            directDeps.add(new Dependency((Artifact)new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), version), d.getScope(), Boolean.valueOf(d.isOptional()), BootstrapAppModelResolver.toAetherExclusions(d.getExclusions())));
        }
        ArrayList<Dependency> constraints = managedMap.isEmpty() ? List.of() : new ArrayList<Dependency>(managedMap.values());
        return this.buildAppModel(mainDep, (Artifact)mainArtifact, directDeps, this.mvn.getRepositories(), Set.of(), constraints);
    }

    private ApplicationModel doResolveModel(ArtifactCoords coords, List<Dependency> directMvnDeps, ArtifactCoords managingProject, Set<ArtifactKey> reloadableModules) throws AppModelResolverException {
        if (coords == null) {
            throw new IllegalArgumentException("Application artifact is null");
        }
        Artifact mvnArtifact = BootstrapAppModelResolver.toAetherArtifact(coords);
        ArrayList<Dependency> managedDeps = List.of();
        List<RemoteRepository> managedRepos = List.of();
        if (managingProject != null) {
            ArtifactDescriptorResult managingDescr = this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact(managingProject));
            managedDeps = managingDescr.getManagedDependencies();
            managedRepos = this.mvn.newResolutionRepositories(managingDescr.getRepositories());
        }
        List<RemoteRepository> aggregatedRepos = this.mvn.aggregateRepositories(managedRepos, this.mvn.getRepositories());
        ResolvedDependency appArtifact = this.resolve(coords, mvnArtifact, aggregatedRepos);
        mvnArtifact = BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)appArtifact);
        ArtifactDescriptorResult appArtifactDescr = this.resolveDescriptor(mvnArtifact, aggregatedRepos);
        Map<ArtifactKey, String> managedVersions = Map.of();
        if (!managedDeps.isEmpty()) {
            ArrayList<Dependency> mergedManagedDeps = new ArrayList<Dependency>(managedDeps.size() + appArtifactDescr.getManagedDependencies().size());
            managedVersions = new HashMap<ArtifactKey, String>(managedDeps.size());
            for (Dependency dep : managedDeps) {
                managedVersions.put(DependencyUtils.getKey(dep.getArtifact()), dep.getArtifact().getVersion());
                mergedManagedDeps.add(dep);
            }
            for (Dependency dep : appArtifactDescr.getManagedDependencies()) {
                ArtifactKey key = DependencyUtils.getKey(dep.getArtifact());
                if (managedVersions.containsKey(key)) continue;
                mergedManagedDeps.add(dep);
            }
            managedDeps = mergedManagedDeps;
        } else {
            managedDeps = appArtifactDescr.getManagedDependencies();
        }
        directMvnDeps = DependencyUtils.mergeDeps(directMvnDeps, appArtifactDescr.getDependencies(), managedVersions, Set.of());
        aggregatedRepos = this.mvn.aggregateRepositories(aggregatedRepos, this.mvn.newResolutionRepositories(appArtifactDescr.getRepositories()));
        return this.buildAppModel(appArtifact, mvnArtifact, directMvnDeps, aggregatedRepos, reloadableModules, (List<Dependency>)managedDeps);
    }

    private Set<String> getExcludedScopes() {
        if (this.test) {
            return Set.of();
        }
        if (this.devmode) {
            return Set.of("test");
        }
        return Set.of("provided", "test");
    }

    private ApplicationModel buildAppModel(ResolvedDependency appArtifact, Artifact artifact, List<Dependency> directDeps, List<RemoteRepository> repos, Set<ArtifactKey> reloadableModules, List<Dependency> managedDeps) throws AppModelResolverException {
        ApplicationModelBuilder appBuilder = new ApplicationModelBuilder().setAppArtifact(appArtifact);
        if (appArtifact.getWorkspaceModule() != null) {
            appBuilder.addReloadableWorkspaceModule(appArtifact.getKey());
        }
        if (!reloadableModules.isEmpty()) {
            appBuilder.addReloadableWorkspaceModules(reloadableModules);
        }
        ArrayList<Dependency> filteredProvidedDeps = new ArrayList<Dependency>(0);
        Set<String> excludedScopes = this.getExcludedScopes();
        if (!excludedScopes.isEmpty()) {
            ArrayList<Dependency> filtered = new ArrayList<Dependency>(directDeps.size());
            for (Dependency d : directDeps) {
                if (!excludedScopes.contains(d.getScope())) {
                    filtered.add(d);
                    continue;
                }
                if (!"provided".equals(d.getScope())) continue;
                filteredProvidedDeps.add(d);
            }
            directDeps = filtered;
        }
        CollectRequest collectRtDepsRequest = MavenArtifactResolver.newCollectRequest(artifact, directDeps, managedDeps, List.of(), repos);
        try {
            ApplicationDependencyTreeResolver.newInstance().setArtifactResolver(this.mvn).setApplicationModelBuilder(appBuilder).setCollectReloadableModules(this.collectReloadableDeps && reloadableModules.isEmpty()).setCollectCompileOnly(filteredProvidedDeps).setBuildTreeConsumer(this.buildTreeConsumer).resolve(collectRtDepsRequest);
        }
        catch (BootstrapDependencyProcessingException e) {
            throw new AppModelResolverException("Failed to inject extension deployment dependencies for " + appArtifact.toCompactCoords(), (Throwable)((Object)e));
        }
        return appBuilder.build();
    }

    private ResolvedDependency resolve(ArtifactCoords appArtifact, Artifact mvnArtifact, List<RemoteRepository> aggregatedRepos) throws BootstrapMavenException {
        ArtifactSources artifactSources;
        WorkspaceModule resolvedModule;
        ResolvedDependency resolvedArtifact;
        ResolvedDependency resolvedDependency = resolvedArtifact = ResolvedDependency.class.isAssignableFrom(appArtifact.getClass()) ? (ResolvedDependency)appArtifact : null;
        if (resolvedArtifact != null && (resolvedArtifact.getWorkspaceModule() != null || this.mvn.getProjectModuleResolver() == null)) {
            return resolvedArtifact;
        }
        WorkspaceModule workspaceModule = resolvedModule = this.mvn.getProjectModuleResolver() == null ? null : this.mvn.getProjectModuleResolver().getProjectModule(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getVersion());
        if (resolvedArtifact != null && resolvedModule == null) {
            return resolvedArtifact;
        }
        Object resolvedPaths = null;
        if ((this.devmode || this.test) && resolvedModule != null && (artifactSources = resolvedModule.getSources(appArtifact.getClassifier())) != null) {
            PathList.Builder pathBuilder = PathList.builder();
            BootstrapAppModelResolver.collectSourceDirs(pathBuilder, artifactSources.getSourceDirs());
            BootstrapAppModelResolver.collectSourceDirs(pathBuilder, artifactSources.getResourceDirs());
            if (!pathBuilder.isEmpty()) {
                resolvedPaths = pathBuilder.build();
            }
        }
        if (resolvedPaths == null) {
            resolvedPaths = resolvedArtifact == null || resolvedArtifact.getResolvedPaths() == null ? PathList.of((Path[])new Path[]{this.resolve(mvnArtifact, aggregatedRepos).getArtifact().getFile().toPath()}) : resolvedArtifact.getResolvedPaths();
        }
        return ((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setCoords(appArtifact)).setWorkspaceModule(resolvedModule).setResolvedPaths(resolvedPaths).build();
    }

    private static void collectSourceDirs(PathList.Builder pathBuilder, Collection<SourceDir> resources) {
        for (SourceDir src : resources) {
            Path p;
            if (!Files.exists(src.getOutputDir(), new LinkOption[0]) || pathBuilder.contains(p = src.getOutputDir())) continue;
            pathBuilder.add(p);
        }
    }

    public List<String> listLaterVersions(ArtifactCoords appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, appArtifact.getVersion(), false, upToVersion, inclusive);
        List resolvedVersions = rangeResult.getVersions();
        ArrayList<String> versions = new ArrayList<String>(resolvedVersions.size());
        for (Version v : resolvedVersions) {
            versions.add(v.toString());
        }
        return versions;
    }

    public String getNextVersion(ArtifactCoords appArtifact, String fromVersion, boolean fromVersionIncluded, String upToVersion, boolean upToVersionInclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, fromVersion, fromVersionIncluded, upToVersion, upToVersionInclusive);
        return this.getEarliest(rangeResult);
    }

    public String getLatestVersion(ArtifactCoords appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, appArtifact.getVersion(), false, upToVersion, inclusive);
        String latest = this.getLatest(rangeResult);
        return latest == null ? appArtifact.getVersion() : latest;
    }

    public String getLatestVersionFromRange(ArtifactCoords appArtifact, String range) throws AppModelResolverException {
        VersionRangeResult rangeResult = this.resolveVersionRangeResult(appArtifact, range);
        return this.getLatest(rangeResult);
    }

    public List<RemoteRepository> resolveArtifactRepos(ArtifactCoords appArtifact) throws AppModelResolverException {
        return this.mvn.resolveDescriptor(BootstrapAppModelResolver.toAetherArtifact(appArtifact)).getRepositories();
    }

    public void install(ArtifactCoords artifact, Path localPath) throws AppModelResolverException {
        this.mvn.install((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), Map.of(), localPath.toFile()));
    }

    private String getEarliest(VersionRangeResult rangeResult) {
        List versions = rangeResult.getVersions();
        if (versions.isEmpty()) {
            return null;
        }
        Version next = (Version)versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            Version candidate = (Version)versions.get(i);
            if (next.compareTo((Object)candidate) <= 0) continue;
            next = candidate;
        }
        return next.toString();
    }

    private String getLatest(VersionRangeResult rangeResult) {
        List versions = rangeResult.getVersions();
        if (versions.isEmpty()) {
            return null;
        }
        Version next = (Version)versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            Version candidate = (Version)versions.get(i);
            if (candidate.compareTo((Object)next) <= 0) continue;
            next = candidate;
        }
        return next.toString();
    }

    private VersionRangeResult resolveVersionRangeResult(ArtifactCoords appArtifact, String fromVersion, boolean fromVersionIncluded, String upToVersion, boolean upToVersionIncluded) throws AppModelResolverException {
        return this.resolveVersionRangeResult(appArtifact, (fromVersionIncluded ? (char)'[' : '(') + (String)(fromVersion == null ? "" : fromVersion + ",") + String.valueOf(upToVersion == null ? Character.valueOf(')') : upToVersion + (upToVersionIncluded ? (char)']' : ')')));
    }

    private VersionRangeResult resolveVersionRangeResult(ArtifactCoords appArtifact, String range) throws AppModelResolverException {
        return this.mvn.resolveVersionRange((Artifact)new DefaultArtifact(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getType(), range));
    }

    private static Artifact toAetherArtifact(ArtifactCoords artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
    }

    private static List<Dependency> toAetherDeps(Collection<io.quarkus.maven.dependency.Dependency> directDeps) {
        if (directDeps.isEmpty()) {
            return List.of();
        }
        ArrayList<Dependency> directMvnDeps = new ArrayList<Dependency>(directDeps.size());
        for (io.quarkus.maven.dependency.Dependency dep : directDeps) {
            directMvnDeps.add(new Dependency(BootstrapAppModelResolver.toAetherArtifact((ArtifactCoords)dep), dep.getScope()));
        }
        return directMvnDeps;
    }

    private static List<Exclusion> toAetherExclusions(Collection<ArtifactKey> keys) {
        if (keys.isEmpty()) {
            return List.of();
        }
        ArrayList<Exclusion> result = new ArrayList<Exclusion>(keys.size());
        for (ArtifactKey key : keys) {
            result.add(new Exclusion(key.getGroupId(), key.getArtifactId(), key.getClassifier(), key.getType() == null || key.getType().isBlank() ? "jar" : key.getType()));
        }
        return result;
    }

    private ArtifactResult resolve(Artifact artifact, List<RemoteRepository> aggregatedRepos) throws BootstrapMavenException {
        try {
            return this.mvn.getSystem().resolveArtifact(this.mvn.getSession(), new ArtifactRequest().setArtifact(artifact).setRepositories(aggregatedRepos));
        }
        catch (ArtifactResolutionException e) {
            throw new BootstrapMavenException("Failed to resolve artifact " + String.valueOf(artifact), e);
        }
    }

    private ArtifactDescriptorResult resolveDescriptor(Artifact artifact, List<RemoteRepository> aggregatedRepos) throws BootstrapMavenException {
        try {
            return this.mvn.getSystem().readArtifactDescriptor(this.mvn.getSession(), new ArtifactDescriptorRequest().setArtifact(artifact).setRepositories(aggregatedRepos));
        }
        catch (ArtifactDescriptorException e) {
            throw new BootstrapMavenException("Failed to read descriptor of " + String.valueOf(artifact), e);
        }
    }
}

