/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.logging;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.formatters.PatternFormatter;

public class QuarkusDelayedHandler
extends ExtHandler {
    private final Deque<ExtLogRecord> logRecords = new ArrayDeque<ExtLogRecord>();
    private final List<Runnable> logCloseTasks = new ArrayList<Runnable>();
    private final int queueLimit;
    private volatile boolean buildTimeLoggingActivated = false;
    private volatile boolean activated = false;
    private volatile boolean callerCalculationRequired = false;

    public QuarkusDelayedHandler() {
        this(4000);
    }

    public QuarkusDelayedHandler(int queueLimit) {
        this.queueLimit = queueLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPublish(ExtLogRecord record) {
        if (this.activated) {
            this.publishToNestedHandlers(record);
            super.doPublish(record);
        } else {
            QuarkusDelayedHandler quarkusDelayedHandler = this;
            synchronized (quarkusDelayedHandler) {
                if (this.activated || this.buildTimeLoggingActivated) {
                    this.publishToNestedHandlers(record);
                    super.doPublish(record);
                } else {
                    if (this.logRecords.size() >= this.queueLimit) {
                        this.reportError("The delayed handler's queue was overrun and log record(s) were lost. Did you forget to configure logging?", null, 1);
                        return;
                    }
                    if (this.isCallerCalculationRequired()) {
                        record.copyAll();
                    } else {
                        record.disableCallerCalculation();
                        record.copyMdc();
                    }
                    this.logRecords.addLast(record);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SecurityException {
        QuarkusDelayedHandler quarkusDelayedHandler = this;
        synchronized (quarkusDelayedHandler) {
            if (!this.logRecords.isEmpty()) {
                ExtLogRecord record;
                Formatter formatter = this.getFormatter();
                if (formatter == null) {
                    formatter = new PatternFormatter("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
                }
                StandardOutputStreams.printError((String)"The DelayedHandler was closed before any children handlers were configured. Messages will be written to stderr.");
                while ((record = this.logRecords.pollFirst()) != null) {
                    StandardOutputStreams.printError((String)formatter.format((LogRecord)record));
                }
            }
        }
        this.activated = false;
        super.close();
    }

    public void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
        this.activate();
    }

    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        Handler[] result = super.setHandlers(newHandlers);
        this.activate();
        return result;
    }

    public void addLoggingCloseTask(Runnable runnable) {
        this.logCloseTasks.add(runnable);
    }

    public synchronized Handler[] setBuildTimeHandlers(Handler[] newHandlers) throws SecurityException {
        ExtLogRecord record;
        Handler[] result = super.setHandlers(newHandlers);
        this.buildTimeLoggingActivated = true;
        while ((record = this.logRecords.pollFirst()) != null) {
            if (!this.isEnabled() || !this.isLoggable((LogRecord)record) || !Logger.getLogger(record.getLoggerName()).isLoggable(record.getLevel())) continue;
            this.publishToNestedHandlers(record);
        }
        return result;
    }

    public synchronized void buildTimeComplete() {
        this.buildTimeLoggingActivated = false;
    }

    public void removeHandler(Handler handler) throws SecurityException {
        super.removeHandler(handler);
        this.activated = this.handlers.length != 0;
    }

    public Handler[] clearHandlers() throws SecurityException {
        this.activated = false;
        for (Runnable i : this.logCloseTasks) {
            i.run();
        }
        return super.clearHandlers();
    }

    public boolean isCallerCalculationRequired() {
        return this.callerCalculationRequired || super.isCallerCalculationRequired();
    }

    public void setCallerCalculationRequired(boolean callerCalculationRequired) {
        this.callerCalculationRequired = callerCalculationRequired;
    }

    public final boolean isActivated() {
        return this.activated;
    }

    private synchronized void activate() {
        ExtLogRecord record;
        while ((record = this.logRecords.pollFirst()) != null) {
            if (!this.isEnabled() || !this.isLoggable((LogRecord)record) || !Logger.getLogger(record.getLoggerName()).isLoggable(record.getLevel())) continue;
            this.publishToNestedHandlers(record);
        }
        this.activated = true;
    }
}

