/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.JarResource;
import io.quarkus.bootstrap.runner.VirtualThreadSupport;
import io.smallrye.common.io.jar.JarFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;

public class JarFileReference {
    private CompletableFuture<JarFileReference> completedFuture;
    private final JarFile jarFile;
    private final AtomicInteger referenceCounter = new AtomicInteger(2);

    private JarFileReference(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public static JarFileReference completeWith(CompletableFuture<JarFileReference> completableFuture, JarFile jarFile) {
        Objects.requireNonNull(completableFuture);
        JarFileReference jarFileRef = new JarFileReference(jarFile);
        jarFileRef.completedFuture = completableFuture;
        completableFuture.complete(jarFileRef);
        return jarFileRef;
    }

    public static CompletableFuture<JarFileReference> completedWith(JarFile jarFile) {
        JarFileReference jarFileRef = new JarFileReference(jarFile);
        jarFileRef.completedFuture = CompletableFuture.completedFuture(jarFileRef);
        return jarFileRef.completedFuture;
    }

    private boolean acquire() {
        int count;
        do {
            if ((count = this.referenceCounter.get()) != 0) continue;
            return false;
        } while (!this.referenceCounter.compareAndSet(count, JarFileReference.addCount(count, 1)));
        return true;
    }

    private static int addCount(int count, int delta) {
        assert (count != 0);
        if (count < 0) {
            delta = -delta;
        }
        return count + delta;
    }

    private boolean release(JarResource jarResource) {
        int count;
        do {
            if ((count = this.referenceCounter.get()) != 1 && count != 0) continue;
            throw new IllegalStateException("Duplicate release? The reference counter cannot be " + count);
        } while (!this.referenceCounter.compareAndSet(count, JarFileReference.addCount(count, -1)));
        if (count == -1) {
            this.silentCloseJarResources(jarResource);
            return true;
        }
        return false;
    }

    private void silentCloseJarResources(JarResource jarResource) {
        jarResource.jarFileReference.compareAndSet(this.completedFuture, null);
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void markForClosing(JarResource jarResource) {
        int count;
        while ((count = this.referenceCounter.get()) > 0) {
            if (!this.referenceCounter.compareAndSet(count, JarFileReference.addCount(-count, -1)) || count != 1) continue;
            this.silentCloseJarResources(jarResource);
        }
        return;
    }

    static <T> T withJarFile(JarResource jarResource, String resource, JarFileConsumer<T> fileConsumer) {
        CompletableFuture<JarFileReference> localJarFileRefFuture = jarResource.jarFileReference.get();
        boolean closingLocalJarFileRef = false;
        if (localJarFileRefFuture != null && localJarFileRefFuture.isDone()) {
            JarFileReference jarFileReference = localJarFileRefFuture.join();
            if (jarFileReference.acquire()) {
                return JarFileReference.consumeSharedJarFile(jarFileReference, jarResource, resource, fileConsumer);
            }
            closingLocalJarFileRef = true;
        }
        if (!VirtualThreadSupport.isVirtualThread()) {
            return JarFileReference.consumeSharedJarFile(JarFileReference.asyncLoadAcquiredJarFile(jarResource), jarResource, resource, fileConsumer);
        }
        CompletableFuture<JarFileReference> newJarFileRef = JarFileReference.syncLoadAcquiredJarFile(jarResource);
        if (closingLocalJarFileRef && jarResource.jarFileReference.compareAndSet(localJarFileRefFuture, newJarFileRef) || jarResource.jarFileReference.compareAndSet(null, newJarFileRef)) {
            return JarFileReference.consumeSharedJarFile(newJarFileRef.join(), jarResource, resource, fileConsumer);
        }
        return JarFileReference.consumeUnsharedJarFile(newJarFileRef, jarResource, resource, fileConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T consumeSharedJarFile(JarFileReference jarFileReference, JarResource jarResource, String resource, JarFileConsumer<T> fileConsumer) {
        try {
            T t = fileConsumer.apply(jarFileReference.jarFile, jarResource.jarPath, resource);
            return t;
        }
        finally {
            jarFileReference.release(jarResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T consumeUnsharedJarFile(CompletableFuture<JarFileReference> jarFileReferenceFuture, JarResource jarResource, String resource, JarFileConsumer<T> fileConsumer) {
        JarFileReference jarFileReference = jarFileReferenceFuture.join();
        try {
            T t = fileConsumer.apply(jarFileReference.jarFile, jarResource.jarPath, resource);
            return t;
        }
        finally {
            boolean closed = jarFileReference.release(jarResource);
            assert (!closed);
            if (!jarResource.jarFileReference.compareAndSet(null, jarFileReferenceFuture)) {
                jarFileReference.markForClosing(jarResource);
            }
        }
    }

    private static CompletableFuture<JarFileReference> syncLoadAcquiredJarFile(JarResource jarResource) {
        try {
            return JarFileReference.completedWith(JarFiles.create((File)jarResource.jarPath.toFile()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open " + jarResource.jarPath, e);
        }
    }

    private static JarFileReference asyncLoadAcquiredJarFile(JarResource jarResource) {
        CompletableFuture<JarFileReference> newJarRefFuture = new CompletableFuture<JarFileReference>();
        CompletableFuture<JarFileReference> existingJarRefFuture = null;
        JarFileReference existingJarRef = null;
        do {
            if (!jarResource.jarFileReference.compareAndSet(null, newJarRefFuture)) continue;
            try {
                return JarFileReference.completeWith(newJarRefFuture, JarFiles.create((File)jarResource.jarPath.toFile()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } while ((existingJarRef = (existingJarRefFuture = jarResource.jarFileReference.get()) == null ? null : existingJarRefFuture.join()) == null || !existingJarRef.acquire());
        return existingJarRef;
    }

    @FunctionalInterface
    static interface JarFileConsumer<T> {
        public T apply(JarFile var1, Path var2, String var3);
    }
}

