/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.builder;

import java.util.Objects;
import org.jboss.builder.item.BuildItem;
import org.jboss.builder.item.MultiBuildItem;
import org.jboss.builder.item.NamedBuildItem;
import org.jboss.builder.item.NamedMultiBuildItem;
import org.wildfly.common.Assert;

final class ItemId {
    private final Class<? extends BuildItem> itemType;
    private final Object name;

    ItemId(Class<? extends BuildItem> itemType, Object name) {
        Assert.checkNotNullParam((String)"itemType", itemType);
        if (NamedBuildItem.class.isAssignableFrom(itemType)) {
            Assert.checkNotNullParam((String)"name", (Object)name);
        }
        this.itemType = itemType;
        this.name = name;
    }

    boolean isMulti() {
        return MultiBuildItem.class.isAssignableFrom(this.itemType) || NamedMultiBuildItem.class.isAssignableFrom(this.itemType);
    }

    public boolean equals(Object obj) {
        return obj instanceof ItemId && this.equals((ItemId)obj);
    }

    boolean equals(ItemId obj) {
        return this == obj || obj != null && this.itemType == obj.itemType && Objects.equals(this.name, obj.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name) * 31 + Objects.hashCode(this.itemType);
    }

    public String toString() {
        Object name = this.name;
        Class<? extends BuildItem> itemType = this.itemType;
        if (name == null) {
            assert (itemType != null);
            return itemType.toString();
        }
        if (itemType == null) {
            assert (name != null);
            return "name " + name.toString();
        }
        return itemType.toString() + " with name " + name;
    }

    Class<? extends BuildItem> getType() {
        return this.itemType;
    }
}

