/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.builder.BuildChain;
import org.jboss.builder.BuildException;
import org.jboss.builder.BuildResult;
import org.jboss.builder.Execution;
import org.jboss.builder.ItemId;
import org.jboss.builder.Messages;
import org.jboss.builder.item.BuildItem;
import org.jboss.builder.item.NamedBuildItem;
import org.wildfly.common.Assert;

public final class BuildExecutionBuilder {
    private final BuildChain buildChain;
    private final String buildTargetName;
    private final Map<ItemId, BuildItem> initialSingle;
    private final Map<ItemId, ArrayList<BuildItem>> initialMulti;

    BuildExecutionBuilder(BuildChain buildChain, String buildTargetName) {
        this.buildChain = buildChain;
        this.buildTargetName = buildTargetName;
        this.initialSingle = new HashMap<ItemId, BuildItem>(buildChain.getInitialSingleCount());
        this.initialMulti = new HashMap<ItemId, ArrayList<BuildItem>>(buildChain.getInitialMultiCount());
    }

    public String getBuildTargetName() {
        return this.buildTargetName;
    }

    public <T extends BuildItem> BuildExecutionBuilder produce(T item) {
        Assert.checkNotNullParam((String)"item", item);
        if (item instanceof NamedBuildItem) {
            throw new IllegalArgumentException("Cannot produce a named build item without a name");
        }
        this.produce(new ItemId(item.getClass(), null), item);
        return this;
    }

    public <T extends BuildItem> BuildExecutionBuilder produce(Class<T> type, T item) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"item", item);
        if (NamedBuildItem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot produce a named build item without a name");
        }
        this.produce(new ItemId(type, null), item);
        return this;
    }

    public <N, T extends NamedBuildItem<N>> BuildExecutionBuilder produce(N name, T item) {
        Assert.checkNotNullParam((String)"name", name);
        Assert.checkNotNullParam((String)"item", item);
        this.produce(new ItemId(item.getClass(), name), (BuildItem)item);
        return this;
    }

    public <N, T extends NamedBuildItem<N>> BuildExecutionBuilder produce(Class<T> type, N name, T item) {
        Assert.checkNotNullParam((String)"type", type);
        Assert.checkNotNullParam((String)"name", name);
        Assert.checkNotNullParam((String)"item", item);
        this.produce(new ItemId(type, name), (BuildItem)item);
        return this;
    }

    public BuildResult execute() throws BuildException {
        return new Execution(this, this.buildChain.getFinalIds()).run();
    }

    private void produce(ItemId id, BuildItem value) {
        if (!this.buildChain.hasInitial(id)) {
            throw Messages.msg.undeclaredItem(id);
        }
        if (id.isMulti()) {
            List list = this.initialMulti.computeIfAbsent(id, x -> new ArrayList());
            if (Comparable.class.isAssignableFrom(id.getType())) {
                int pos = Collections.binarySearch(list, value);
                if (pos < 0) {
                    pos = -(pos + 1);
                }
                list.add(pos, value);
            } else {
                list.add(value);
            }
        } else if (this.initialSingle.putIfAbsent(id, value) != null) {
            throw Messages.msg.cannotMulti(id);
        }
    }

    Map<ItemId, BuildItem> getInitialSingle() {
        return this.initialSingle;
    }

    Map<ItemId, ArrayList<BuildItem>> getInitialMulti() {
        return this.initialMulti;
    }

    BuildChain getChain() {
        return this.buildChain;
    }
}

