/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.builder;

import org.jboss.builder.BuildStepBuilder;
import org.jboss.builder.Constraint;
import org.jboss.builder.ItemId;
import org.jboss.builder.ProduceFlag;
import org.jboss.builder.ProduceFlags;

final class Produce {
    private final BuildStepBuilder stepBuilder;
    private final ItemId itemId;
    private final Constraint constraint;
    private final ProduceFlags flags;

    Produce(BuildStepBuilder stepBuilder, ItemId itemId, Constraint constraint, ProduceFlags flags) {
        this.stepBuilder = stepBuilder;
        this.itemId = itemId;
        this.constraint = constraint;
        this.flags = flags;
    }

    Produce combine(Constraint constraint, ProduceFlags flags) {
        Constraint outputConstraint = constraint == Constraint.REAL || this.constraint == Constraint.REAL ? Constraint.REAL : Constraint.ORDER_ONLY;
        ProduceFlags outputFlags = !flags.contains(ProduceFlag.WEAK) || !this.flags.contains(ProduceFlag.WEAK) ? (ProduceFlags)((ProduceFlags)flags.with(this.flags)).without(ProduceFlag.WEAK) : (ProduceFlags)flags.with(this.flags);
        return new Produce(this.stepBuilder, this.itemId, outputConstraint, outputFlags);
    }

    BuildStepBuilder getStepBuilder() {
        return this.stepBuilder;
    }

    ItemId getItemId() {
        return this.itemId;
    }

    Constraint getConstraint() {
        return this.constraint;
    }

    ProduceFlags getFlags() {
        return this.flags;
    }
}

